// Praktikum 1 Fertig

#include "mbed.h"
#include "IRSensor.h"
#include "Controller.h"

// LEDs
DigitalOut myled(LED1);
DigitalOut led0(PC_8);
DigitalOut led1(PC_6);
DigitalOut led2(PB_12);
DigitalOut led3(PA_7);
DigitalOut led4(PC_0);
DigitalOut led5(PC_9);

// Distanzmesser
AnalogIn distance(PB_1); // Kreieren der Ein- und Ausgangsobjekte
DigitalOut enable(PC_1);
DigitalOut bit0(PH_1);
DigitalOut bit1(PC_2);
DigitalOut bit2(PC_3);

// Motoren
DigitalOut enableMotorDriver(PB_2);
DigitalIn motorDriverFault(PB_14);
DigitalIn motorDriverWarning(PB_15);
PwmOut pwmLeft(PA_8);
PwmOut pwmRight(PA_9);

// Motoren Drehzahlgeber
EncoderCounter counterLeft(PB_6, PB_7);
EncoderCounter counterRight(PA_6, PC_7);

float d = 0;

IRSensor irSensor0(distance, bit0, bit1, bit2, 0); // Objekte kreieren
IRSensor irSensor1(distance, bit0, bit1, bit2, 1);
IRSensor irSensor2(distance, bit0, bit1, bit2, 2);
IRSensor irSensor3(distance, bit0, bit1, bit2, 3);
IRSensor irSensor4(distance, bit0, bit1, bit2, 4);
IRSensor irSensor5(distance, bit0, bit1, bit2, 5);

Controller controller(pwmLeft, pwmRight, counterLeft, counterRight);

int main()
{

    enable = 1; // schaltet die Sensoren ein


    // MOTOR
    
    pwmLeft.period(0.00005); // Setzt die Periode auf 50 μs
    pwmRight.period(0.00005);
    pwmLeft = 0.5; // Setzt die Duty-Cycle auf 50%
    pwmRight = 0.5;
    enableMotorDriver = 1; // Schaltet den Leistungstreiber ein
    

    /*
    bit0 = 0; // Wahl des Sensors mit dem Multiplexer (Sensor vorne)
    bit1 = 0;
    bit2 = 0;
    */

    while(1) {
        /*
        myled = 1; // LED is ON
        wait(0.2); // 200 ms
        myled = 0; // LED is OFF
        wait(0.2); // 1 sec

        led1 = 1; // LED is ON
        wait(0.2); // 200 ms
        led1 = 0; // LED is OFF
        wait(0.2); // 1 sec

        led2 = 1; // LED is ON
        wait(0.2); // 200 ms
        led2 = 0; // LED is OFF
        wait(0.2); // 1 sec

        led3 = 1; // LED is ON
        wait(0.2); // 200 ms
        led3 = 0; // LED is OFF
        wait(0.2); // 1 sec

        led4 = 1; // LED is ON
        wait(0.2); // 200 ms
        led4 = 0; // LED is OFF
        wait(0.2); // 1 sec

        led5 = 1; // LED is ON
        wait(0.2); // 200 ms
        led5 = 0; // LED is OFF
        wait(0.2); // 1 sec
        */

        /*wait(0.5);
        d = -0.58f*sqrt(distance)+0.58f; // Lesen der Distanz in [m]
        printf("Mein Wert: %f\n",d);
        */
        
        // Motoren drehen primitiv
        //pwmLeft = 0.55; // Duty-Cycle von 55%
        //pwmRight = 0.55;
        
        // Motoren per Drehzahlregler
        controller.setDesiredSpeedLeft(50.0f); // Drehzahl in [rpm]
        controller.setDesiredSpeedRight(-50.0f);
        
        // Ausgabe für Putty
        printf("Speed aktuell links: %f, rechts: %f \r\n",controller.getSpeedLeft(),controller.getSpeedRight());


        float distance0 = irSensor0.read(); // gibt die Distanz in [m] zurueck
        float distance1 = irSensor1.read();
        float distance2 = irSensor2.read();
        float distance3 = irSensor3.read();
        float distance4 = irSensor4.read();
        float distance5 = irSensor5.read();

        led0 = 0;
        led1 = 0;
        led2 = 0;
        led3 = 0;
        led4 = 0;
        led5 = 0;



        if(distance0 < 0.2f) {
            led0 = 1;
        }
        if(distance1 < 0.2f) {
            led1 = 1;
        }
        if(distance2 < 0.2f) {
            led2 = 1;
        }
        if(distance3 < 0.2f) {
            led3 = 1;
        }
        if(distance4 < 0.2f) {
            led4 = 1;
        }
        if(distance5 < 0.2f) {
            led5 = 1;
        }


    }
}
