#include "mbed.h"
#include "math.h"
//------------------------------------------
#define PI 3.1415927f
//------------------------------------------
#include "EncoderCounter.h"
#include "DiffCounter.h"
#include "IIR_filter.h"
#include "LinearCharacteristics.h"
#include "PI_Cntrl.h"
#include "GPA.h"
/* Cuboid balance on one edge on Nucleo F446RE

 **** IMPORTANT: use ..\Labormodelle\RT-MOD054 - Würfel\Escon_Parameter_4nucleo.edc 
                 settings for Maxon ESCON controller (upload via ESCON Studio) ****
hardware Connections:
 
 CN7                    CN10
  :                         :
  :                         :
 ..                        ..
 ..                        ..                  15.
 ..    AOUT i_des on (PA_5)o.
 ..                        ..
 ..                        ..
 ..               ENC CH A o.
 o. GND                    ..                  10.
 o. ENC CH B               ..
 ..                        ..
 ..                        ..
 .o AIN acx (PA_0)         ..
 .o AIN acy (PA_1)         ..                  5.
 .o AIN Gyro(PA_4)         .o Analog GND
 ..                        ..
 ..                        ..
 ..                        ..                  1.
 ----------------------------
 CN7               CN10
 */
Serial pc(SERIAL_TX, SERIAL_RX);        // serial connection via USB - programmer
InterruptIn button(USER_BUTTON);        // User Button, short presses: reduce speed, long presses: increase speed
AnalogIn ax(PA_0);                      // Analog IN (acc x) on PA_0
AnalogIn ay(PA_1);                      // Analog IN (acc y) on PA_1
AnalogIn gz(PA_4);                      // Analog IN (gyr z) on PA_4
AnalogOut out(PA_5);                    // Analog OUT on PA_5   1.6 V -> 0A 3.2A -> 2A (see ESCON)
float out_value = 1.6f;                 // set voltage on 1.6 V (0 A current)
float w_soll = 80.0f;                   // desired velocity
float Ts = 0.002f;                      // sample time of main loops
int k = 0;

//------------------------------------------
// ... here define variables like gains etc.
//------------------------------------------
//-------------DEFINE FILTERS----------------

//------------------------------------------
Ticker  ControllerLoopTimer;            // interrupt for control loop
EncoderCounter counter1(PB_6, PB_7);    // initialize counter on PB_6 and PB_7
DiffCounter diff(0.01,Ts);              // discrete differentiate, based on encoder data
//------------------------------------------
// ... here define instantiate classes
//------------------------------------------

LinearCharacteristics i2u(3.2f/4.0f,-2.0f);
LinearCharacteristics i2u2(-2.0f,2.0f,0.0f,3.2f);

LinearCharacteristics u2g(-4.622f*3.3f,0.45275f);
LinearCharacteristics u2a(0.3072f,0.70281f,-9.81f,9.81f);

// Filter
float tau = 1.0f;
IIR_filter LPF_gz(tau, Ts, 1.0f);
IIR_filter LPF_ax(tau, Ts, 1.0f);
IIR_filter LPF_ay(tau, Ts, 1.0f);

// Tn unknown, Kp grätlet 3.0
PI_Cntrl regler(3.0f, 0.1f, Ts, -0.4f, 0.4f);
PI_Cntrl vel2zero(-0.2f, 4.0, Ts, -0.4f, 0.4f);


// ----- User defined functions -----------
void updateControllers(void);   // speed controller loop (via interrupt)
// ------ END User defined functions ------

//******************************************************************************
//---------- main loop -------------
//******************************************************************************
int main()
{
    //attach controller loop to timer interrupt
    pc.baud(2000000);   // for serial comm.
    counter1.reset();   // encoder reset
    diff.reset(0.0f,0.0f);
    ControllerLoopTimer.attach(&updateControllers, Ts); //Assume Fs = ...;
        
    
}
//******************************************************************************
//---------- control loop (called via interrupt) -------------
//******************************************************************************
void updateControllers(void){
    short counts = counter1;            // get counts from Encoder
    float vel = diff(counts);           // motor velocity 

        // Motor still
        //out = i2u(0.0f)/3.3f;
        
        // Motor geregelt
        float value = regler(w_soll-vel);
        
        // /0.217f kein plan wieso aber het komisch tönt
        //out.write(i2u(value/0.217f)/3.3f);
        
        //pc.printf("test \r\n");
        
        float gyro = (u2g(gz.read()));
        
        float phi_mes = (PI/4.0f) + atan2( -LPF_ax(u2a(ax.read())), LPF_ay(u2a(ay.read())) ) + LPF_gz(gyro);
        
        float Mu = vel2zero(0.0f - vel);
        
        // values are from matlab script init_cub1.m (variable K)
        float torque = Mu - (-9.6910f * phi_mes -0.7119f * gyro);
        
        // versuch um geschwindigkeit die immer höher wird zu begrenzen... funktioniert nicht
        /*if(vel >= 20) {
            out.write(i2u(0)/3.3f);
        } else {
            out.write(i2u(torque/0.217f)/3.3f);
        }*/
        
        out.write(i2u(torque/0.217f)/3.3f);
        
        
        if(++k >= 249){
        k = 0;
        //pc.printf("Velocity: %2.2f \r\n",vel);
        //pc.printf("ax: %1.5f ay: %1.5f gz: %1.5f \r\n",u2a(ax.read()),u2a(ay.read()),u2g(gz.read()));
        pc.printf("winkel: %2.5f torque: %2.5f Mu: %2.5f vel: %2.5f \r\n",phi_mes, torque, Mu, vel);
        //pc.printf("Motor Still in A: %f \r\n",i2u(0.0f)/3.3f);
    }
}
//******************************************************************************
//********** User functions like buttens handle etc. **************

