/*  
    PI Controller class with anti windup reset in biquad transposed direct form 2
    see e.g.: https://www.dsprelated.com/freebooks/filters/Four_Direct_Forms.html
    everything is calculated in double
    
                  Tn*s + 1                      
      G(s) = Kp -------------  with s ~ (1 - z^-1)/Ts
                    Ts*s                     
*/

#include "PI_Cntrl.h"

using namespace std;


    PI_Cntrl::PI_Cntrl(float Kp, float Tn, float Ts) {
        this->Kp = Kp;
        this->Tn = Tn;
        this->Ts = Ts;   
        
        this->iMin = -0.4f;
        this->iMax = 0.4f;
        this->iPartOld = 0;
        
    }
    
    PI_Cntrl::PI_Cntrl(float Kp, float Tn, float Ts, float iMin, float iMax) {
        this->Kp = Kp;
        this->Tn = Tn;
        this->Ts = Ts;  
        this->iMin = iMin;
        this->iMax = iMax;
        this->iPartOld = 0;
        
    }
    
    PI_Cntrl::~PI_Cntrl() {}
    
    float PI_Cntrl::eval(float val) {
        
        float pPart = Kp*val;
        float iPart = iPartOld+(Ts*Kp/Tn)*val;
        
        
        // Begrenze I
        if(iPart > iMax) {
            iPart = iMax;   
        } else if(iPart < iMin) {
            iPart = iMin;   
        }
        
        iPartOld = iPart;
        
        return pPart+iPart;   
    }
    
    
