/*
 * SerialServer.h
 * Copyright (c) 2018, ZHAW
 * All rights reserved.
 */

#ifndef SERIAL_SERVER_H_
#define SERIAL_SERVER_H_

#include <cstdlib>
#include <string>
#include <mbed.h>
#include "IMU.h"
#include "Controller.h"

using namespace std;

/**
 * This class implements a communication server using a serial interface.
 */
class SerialServer {
    
    public:
        
                        SerialServer(Serial& serial, IMU& imu, Controller& controller);
        virtual         ~SerialServer();
        
    private:
        
        static const int    BUFFER_SIZE = 64;
        
        Serial&         serial;
        IMU&            imu;
        Controller&     controller;
        string          input;
        string          output;
        
        void            receive();
        void            transmit();
};

#endif /* SERIAL_SERVER_H_ */

