#include "mbed.h"
#include "IRSensor.h"
#include "Controller.h"

// User Button
DigitalIn button(USER_BUTTON);

// LED

DigitalOut led0(PC_8);
DigitalOut led1(PC_6);
DigitalOut led2(PB_12);
DigitalOut led3(PA_7);
DigitalOut led4(PC_0);
DigitalOut led5(PC_9);

// Distanzmesser
AnalogIn distance(PB_1); // Kreieren der Ein- und Ausgangsobjekte
DigitalOut enable(PC_1);
DigitalOut bit0(PH_1);
DigitalOut bit1(PC_2);
DigitalOut bit2(PC_3);

// Motoren
DigitalOut enableMotorDriver(PB_2);
//DigitalIn motorDriverFault(PB_14);
//DigitalIn motorDriverWarning(PB_15);
PwmOut pwmLeft(PA_8);
PwmOut pwmRight(PA_9);

// Motoren Drehzahlgeber
EncoderCounter counterLeft(PB_6, PB_7);
EncoderCounter counterRight(PA_6, PC_7);

enum { robOff, robMove, robSlowDown, robLeft, robRight };

int state;


// Objects
IRSensor irSensor0(distance, bit0, bit1, bit2, 0);
IRSensor irSensor1(distance, bit0, bit1, bit2, 1);
IRSensor irSensor2(distance, bit0, bit1, bit2, 2);
IRSensor irSensor3(distance, bit0, bit1, bit2, 3);
IRSensor irSensor4(distance, bit0, bit1, bit2, 4);
IRSensor irSensor5(distance, bit0, bit1, bit2, 5);

int main() {
                 
    Controller controller(pwmLeft, pwmRight, counterLeft, counterRight);
                 
    printf("\n============== ROME P2 ===================\n");
        
    enable = 1; // schaltet die Sensoren ein
    
    state = robOff;
    
    // MOTOR TEST
    /*
    enableMotorDriver = 1;
    wait(3);
    controller.setTranslationalVelocity(10);
    
    wait(5);
    controller.setTranslationalVelocity(5);
    wait(5);
    controller.setTranslationalVelocity(10); 
    */
    short lb = button.read();
    while(1) {
        short b = button.read();
        // Initial reads
        
        float distanceStraight = irSensor0.read(); // gibt die Distanz in [m] zurueck
        float distanceRight = irSensor1.read();
        float distanceBackRight = irSensor2.read();
        float distanceBack = irSensor3.read();
        float distanceBackLeft = irSensor4.read();
        float distanceLeft = irSensor5.read();
        
        // FSM
        
        if (distanceStraight < 0.2f) {
            led3.write(true);
        } else {
            led3.write(false);
        }
        
        
        switch(state) {

        // Robot off
        case(robOff):
        
            controller.setTranslationalVelocity(0.0f);
            controller.setRotationalVelocity(0.0f);
        
            enableMotorDriver = 0; // Schaltet den Leistungstreiber
        
            // button pressed
            if (b && b != lb){
                enableMotorDriver = 1; // Schaltet den Leistungstreiber ein
                
                state = robMove;
            }
            
        break;
        // Move Forward
        case(robMove):
            
            controller.setTranslationalVelocity(0.7f);
            controller.setRotationalVelocity(0.0f);
        
        
            // button pressed
            if (b && b != lb){
                state = robOff;
            } else if(distanceStraight <= 0.2f) {
                
                if(distanceLeft > 0.2f) {
                    state = robLeft;    
                } else if(distanceRight > 0.2f) {
                    state = robRight;    
                } else {
                    state = robSlowDown;    
                } 
            } 
        break;
        // Slowing Down
        case(robSlowDown):
        
            controller.setTranslationalVelocity(0.0f);
            controller.setRotationalVelocity(0.0f);
            
            if(abs(controller.getActualTranslationalVelocity()) < 0.01f && abs(controller.getActualRotationalVelocity()) < 0.01f) {
                state = robOff;   
            }
        
        
        break;
        // Turn Left
        case(robLeft):
            
            controller.setTranslationalVelocity(0.0f);
            controller.setRotationalVelocity(5.0f);
        
        
            // button pressed
            if (b && b != lb){
                state = robSlowDown;
            } else if(distanceStraight > 0.2f) {
                state = robMove;    
            }
        break;
        // Turn Right
        case(robRight):
        
            controller.setTranslationalVelocity(0.0f);
            controller.setRotationalVelocity(-5.0f);
        
            // button pressed
            if (b && b != lb){
                state = robSlowDown;
            } else if(distanceStraight > 0.2f) {
                state = robMove;    
            }
        break;
        default:
        // fuck off
                

        break;
        }    

        lb = b;
        
    }
}
