/*
 * IMU.h
 * Copyright (c) 2018, ZHAW
 * All rights reserved.
 */

#ifndef IMU_H_
#define IMU_H_

#include <cstdlib>
#include <mbed.h>

/**
 * This is a device driver class for the ST LSM9DS0 inertial measurement unit.
 */
class IMU {

    public:
        
                    IMU(SPI& spi, DigitalOut& csG, DigitalOut& csXM);
        virtual     ~IMU();
        float       readGyroX();
        float       readGyroY();
        float       readGyroZ();
        float       readAccelerationX();
        float       readAccelerationY();
        float       readAccelerationZ();
        float       readMagnetometerX();
        float       readMagnetometerY();
        float       readMagnetometerZ();
        float       readHeading();
        
    private:
        
        static const char   WHO_AM_I_G = 0x0F;
        static const char   CTRL_REG1_G = 0x20;
        static const char   OUT_X_L_G = 0x28;
        static const char   OUT_X_H_G = 0x29;
        static const char   OUT_Y_L_G = 0x2A;
        static const char   OUT_Y_H_G = 0x2B;
        static const char   OUT_Z_L_G = 0x2C;
        static const char   OUT_Z_H_G = 0x2D;
        
        static const char   WHO_AM_I_XM = 0x0F;
        
        static const char   INT_CTRL_REG_M = 0x12;
        static const char   CTRL_REG0_XM = 0x1F;
        static const char   CTRL_REG1_XM = 0x20;
        static const char   CTRL_REG2_XM = 0x21;
        static const char   CTRL_REG3_XM = 0x22;
        static const char   CTRL_REG4_XM = 0x23;
        static const char   CTRL_REG5_XM = 0x24;
        static const char   CTRL_REG6_XM = 0x25;
        static const char   CTRL_REG7_XM = 0x26;
        
        static const char   OUT_X_L_A = 0x28;
        static const char   OUT_X_H_A = 0x29;
        static const char   OUT_Y_L_A = 0x2A;
        static const char   OUT_Y_H_A = 0x2B;
        static const char   OUT_Z_L_A = 0x2C;
        static const char   OUT_Z_H_A = 0x2D;
        
        static const float  PI;
    
        SPI&            spi;
        DigitalOut&     csG;
        DigitalOut&     csXM;
    
        void            writeRegister(DigitalOut& cs, char address, char value);
        char            readRegister(DigitalOut& cs, char address);
};

#endif /* IMU_H_ */
