#include "mbed.h"
#include <iostream>
#include <string>
#include <fstream>
#include "MODSERIAL.h"

MODSERIAL pc(USBTX, USBRX);
MODSERIAL esp(p28, p27); // tx, rx
DigitalOut reset(p26);
Timer t;
DigitalOut led(p7);
DigitalOut vib(p5);
DigitalOut buz(p6);

int  count,ended,timeout;
char buf[1024];
char snd[255];

char ssid[32] = "IOP-LEGRAND";     
char pwd [32] = "1Up-8445";

char reponse_esp[5];
char reception_esp[3] = "OK";
char test[5] = "test";

char ledon[5] = "DELA";
char ledoff[5] = "DELE";

int longueur_recue = 0;
int nouvelle_reception = 0;
char recept[5] = {0};



void SendCMD(),getreply(),ESPconfig(),ESPsetbaudrate(),WIFI(), Donnee();

using namespace std;

int main()
{
    reset=0; //hardware reset for 8266
    pc.baud(9600);  // set what you want here depending on your terminal program speed
    pc.printf("\f\n\r-------------Demarrage du module WIFI-------------\n\r");
    wait(0.5);
    reset=1;
    timeout=2;
    getreply();

    esp.baud(115200);   // change this to the new ESP8266 baudrate if it is changed at any time.
     
    ESPconfig();        //******************  include Config to set the ESP8266 configuration  ***********************

    pc.printf("\f\n\r- Module pret -\n\r");

    while(1){
        if(esp.readable()){
            wait(1);
        }
            while(esp.readable())
            {
            recept[longueur_recue]=esp.getc();
            longueur_recue++;
            nouvelle_reception = 1;
            }
            
        /*for(int i=0; i<5; i++){
            pc.printf("%c",recept);
        }*/
        
        //char c = esp.getc();
        //pc.printf("%c",recept);
    
        /*if(reception_esp == test){
        strcpy(snd, "AT+CIPSEND=0,4");
        strcat(snd, reponse_esp);
        SendCMD();
        timeout=10;
        getreply();
        pc.printf(buf);
        }*/

        // VIBREUR
        /*if(c == 'a'){
            vib=1;
            }
        if(c == 'b'){
            vib=0;
            } */
            
             // LED  
            if(recept == ledon){
                 led=1;
                 pc.printf("> Les leds sont ON -\n\r");
             }
            if(recept == ledoff){
                led=0;
                pc.printf("> Les leds sont OFF -\n\r");
             } 
            
        // BUZZER    
        /*if(c == 'e'){
            buz=1;
            }
        if(c == 'f'){
            buz=0;
            } 
        // TOTAL
        if(c =='g'){
            buz=1;
            led=1;
            vib=1;
            }
        if(c =='h'){
            buz=0;
            led=0;
            vib=0;
            }*/
    }
        
}


//  +++++++++++++++++++++++++++++++++ This is for ESP8266 config only, run this once to set up the ESP8266 +++++++++++++++
void ESPconfig()
{
    wait(5);
    strcpy(snd,"AT\r\n");
    SendCMD();
    timeout=1;
    getreply();
    wait(1);
    pc.printf("---------- Redemarrage du module ----------\r\n");
    strcpy(snd,"AT+RST\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(buf);

    wait(3);

    // set CWMODE to 1=Station,2=AP,3=BOTH, default mode 1 (Station)
    pc.printf("\n---------- Mode Wifi ----------\r\n");
    strcpy(snd, "AT+CWMODE=3\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(buf);

    wait(2);

    // set CIPMUX to 0=Single,1=Multi
    pc.printf("\n---------- Choix de connexion multiple ou unique ----------\r\n");
    strcpy(snd, "AT+CIPMUX=1\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(buf);
    
    wait(2);

    pc.printf("\n---------- Connexion au point d acces ----------\r\n");
    pc.printf("ssid = %s   pwd = %s\r\n",ssid,pwd);
    strcpy(snd, "AT+CWJAP=\"");
    strcat(snd, ssid);
    strcat(snd, "\",\"");
    strcat(snd, pwd);
    strcat(snd, "\"\r\n");
    SendCMD();
    timeout=10;
    getreply();
    pc.printf(buf);

    wait(5);

    pc.printf("\n---------- Adresse IP local ----------\r\n");
    strcpy(snd, "AT+CIFSR\r\n");
    SendCMD();
    timeout=3;
    getreply();
    pc.printf(buf);

    wait(5);

    pc.printf("\n---------- TCP Client ----------\r\n");
    strcpy(snd, "AT+CIPSERVER=1\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(buf);   

    wait(5);

   /* pc.printf("\n---------- DATA SEND ----------\r\n");
    strcpy(snd, "AT+CIPSEND=0,4\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(buf);*/    
}

void SendCMD()
{
    esp.printf("%s", snd);
}



void getreply()
{
    memset(buf, '\0', sizeof(buf));
    t.start();
    ended=0;
    count=0;
    while(!ended) {
        if(esp.readable()) {
            buf[count] = esp.getc();
            count++;
        }
        if(t.read() > timeout) {
            ended = 1;
            t.stop();
            t.reset();
        }
    }
}
