#include "mbed.h"                                                                       //
#include <iostream>                                                                     //
#include <string>                                                                       //
#include <fstream>                                                                      //Déclaration des librairies utilisées
#include "MODSERIAL.h"                                                                  //
#include "Servo.h"                                                                      //
#include <Serial.h>
#include "stdio.h"
   
Serial pc(USBTX, USBRX);
Serial rfid1(p9, NC);
Serial rfid2(NC, p10);
MODSERIAL esp(p28, p27);                                                                // tx, rx
DigitalOut reset(p26);                                                                  //Pin reset WIFI
Timer t;                                                                                //Timer
Servo myservo(p21);                                                                     //Servomoteur
DigitalIn manuel1 (p20);                                                                //Mode manuel position n°1 (entrée seulement)
//DigitalIn manuel2 (p19);                                                                //Mode manuel position n°2 (sortie seulement)(non réalisé car changement de servomoteur)
DigitalOut ledmm (p18);                                                                 //Led indiquant si le mode manuel est activé
DigitalIn manuel2 (p17);                                                                //Mode manuel position n°2 (entréé ou sortie)
DigitalIn manuel3 (p16);                                                                //Mode manuel position n°3 (verrouillage complet)
DigitalIn bpmanuel (p15);                                                               //Bouton ON/OFF du mode manuel
DigitalIn capteurfermeture (p14);                                                       //Capteur détectant la fermeture
DigitalIn capext (p12) ;                                                                //Capteur de présence extérieur
DigitalIn capint (p11) ;                                                                //Capteur de présence intérieur
DigitalIn CTS(p8);                                                                      
DigitalIn F411 (p7);                                                                    //Detection alimentation servomoteur (CHALLENGE LEGRAND !!!!!!!!!!!)

DigitalOut led1(LED1);                                                                  //Led n°1 du mbed
DigitalOut led2(LED2);                                                                  //Led n°2 du mbed
DigitalOut led3(LED3);                                                                  //Led n°3 du mbed
DigitalOut led4(LED4);                                                                  //Led n°4 du mbed

int egal1 = 0;                                                                          //TAG RFID n°1
int egal2 = 0;                                                                          //TAG RFID n°2
int egal3 = 0;                                                                          //TAG RFID n°3
int egal4 = 0;                                                                          //TAG RFID n°
int egal5 = 0;                                                                          //TAG RFID n°
int tag1[4]= {0xAE,0xFB,0x63,0x10};                                                     //Identifiant TAG RFID n°1
int tag2[4]= {0x25,0x02,0x64,0x10};                                                     //Identifiant TAG RFID n°2
int tag3[4]= {0x3F,0xFC,0x63,0x10};                                                     //Identifiant TAG RFID n°3
int tag4[4]= {0xCE,0xEE,0x63,0x10};                                                     //Identifiant TAG RFID n°4
int tag5[4]= {0xD6,0xD9,0x63,0x10};                                                     //Identifiant TAG RFID n°5
int tag[4]= {0x00,0x00,0x00,0x00};                                                      //Tableau relevant l'identifiant du TAG RFID
int reponse_rfid[5];                                                        
int reponse_rfid1[255];
int lireuid[8]= {0x52,0x00};

int position ;                                                                          //Position de la chatière
float pos1 = 1.0 ;                                                                      //Position n°1 (entrée seulement)
float pos2 = 0.42 ;                                                                     //Position n°2 (complétement ouvert)
float pos3 = 0.001 ;                                                                    //Position n°3 (complétement fermé)


int i = 0;
int e = 0;
int  count,ended,timeout;
int pass = 0 ;                                                                          //
int pass1 = 0 ;                                                                         //
int pass3 = 0 ;                                                                         //Variable permettant d'écrire le mode manuel actif/inactif/position
int pass2 = 0 ;                                                                         //
int pass5 = 0 ;                                                                         //
int secu=0;

char buf[1024];
char snd[255];

char ssid[32] = "IOP_LEGRAND_2";                                                        //Nom du WIFI IOP
char pwd [32] = "legrandMDP";                                                           //Mot de passe du WIFI IOP

char ECHA[5] = "ECHA";                                                                  //Le chat vient de l'extérieur
char ICHA[5] = "ICHA";                                                                  //Le chat vient de l'intérieur


char tcpip[14] = "192.168.2.20";                                                        //Adresse IP du module ESP8666
char tcpport[3] = "23";

int longueur_recue = 0;
int nouvelle_reception = 0;
int a = 0;
int b = 0;

char recept[18];
char tabconnect[10] = {0};
char tabclosed[9] = {0};
char tabrec[5] = {0};
char connect[10] = "0,CONNECT";
char closed[9] = "0,CLOSED";

int drapeau = 1;

void HandShake();                                                                       //
void Antenna();                                                                         //
void field();                                                                           //Déclaration des voids
void SendCMD(),getreply(),ESPconfig(),ESPsetbaudrate(),WIFI(), Donnee();                //

using namespace std;

int main()                                                                              //Début du int main
 {
ledmm = 0;
myservo = pos3 ;                                                                        //La chatière est fermé
wait_ms(200);

    reset=0;                                                                            //Reset du module ESP8266
    pc.baud(9600);                                                                      //Vitesse de transmission du terminal
    pc.printf("\f\n\r--------------- Demarrage du module WIFI ---------------\n\r");    //Démarrage du module WIFI ESP8266
    wait(0.25);
    reset=1;
    timeout=2;
    getreply();

    esp.baud(115200);                                                                   //Vitesse de transmission du module WIFI ESP8266

    ESPconfig();                                                                        //Configuration du module WIFI ESP8266

    pc.printf("\f\n\r- Module pret -\n\r");                                             //Le module WIFI ESP8266
   // pc.printf("-------------------- La chatiere est verrouillee ----------------\n\r");
        
    while(1) 
{
                                                                                        // Partie RFID
        led4=1;
        ledmm = 0;
        egal1=0;                                                                        //Variable TAG RFID n°1
        egal2=0;                                                                        //Variable TAG RFID n°2
        egal3=0;                                                                        //Variable TAG RFID n°3
        egal4=0;                                                                        //Variable TAG RFID n°4
        egal5=0;                                                                        //Variable TAG RFID n°5



        if (CTS == 0)                                                                   //Vérification des câblages
        {
            led4=0;
            led2=1;

            for (int i=0; i<2; i++) 
            {
                rfid2.putc(lireuid[i]);
            }
            wait_ms(25);
            for (int e=0; e<1; e++) 
            {
                reponse_rfid1[e]=(rfid1.getc());
                led1=1;
            }
            if (reponse_rfid1[0] == 0xD6) 
            {
                for (int i=0; i<2; i++) 
                {
                    rfid2.putc(lireuid[i]);
                    led2=1;
                }
                wait_ms(50);
                for (int e=1; e<5; e++) 
                {
                    reponse_rfid[e]=(rfid1.getc());
                    led3=1;
                }

                pc.printf("---------------------------------------");
                pc.printf("\n\r");
                pc.printf("Trame de reponse du PCB en hexa : ");
                for (int i=0; i<2; i++) pc.printf("%X ",lireuid[i]);
                pc.printf("\n\r");
                pc.printf("Status = %X\n\r",reponse_rfid1[0]);
                pc.printf("UID = ");
                for (int i=1; i<5; i++) pc.printf("%X ",reponse_rfid[i]);
                pc.printf("\n\r");
                pc.printf("---------------------------------------");
                pc.printf("\n\r");
            } 
            else if (reponse_rfid1[0] == 0xC0) 
            {
                field();
            }
            if (reponse_rfid1[0] == 0xE0) 
            {
                Antenna();
            }
                for(int i=1; i<5; i++) 
                {
                tag[i-1] = reponse_rfid[i];
                }
            if(tag[0] != 0x00) 
            {
                pc.printf("\n\r");
                pc.printf("tableau de 0: %X", tag[0]);
                pc.printf("\n\r");

                for(int i=0; i<4; i++)                                                  //Identification du TAG RFID n°1
                {
                    if(tag[i] == tag1[i]) 
                    {
                        egal1 = 1;                                                      //Le TAG RFID n°1 est détecté
                        pc.printf("Tag1 - OK ");
                        pc.printf("\n\r");
                        break;
                    } 
                    else if(tag[i] != tag1[i]) 
                    {
                        pc.printf("Tag1 - NOK ");
                        pc.printf("\n\r");
                        egal1 = 0;                                                      //Le TAG RFID n°1 n'est pas détecté
                        break;
                    }
                }
                for(int i=0; i<4; i++)                                                  //Identification du TAG RFID n°2
                {
                    if(tag[i] == tag2[i]) 
                    {
                        egal2 = 1;                                                      //Le TAG RFID n°2 est détecté
                        pc.printf("Tag2 - OK ");
                        pc.printf("\n\r");
                        break;
                    } 
                    else if(tag[i] != tag2[i]) 
                    {
                        pc.printf("Tag2 - NOK ");
                        pc.printf("\n\r");
                        egal2 = 0;                                                      //Le TAG RFID n°2 n'est pas détecté
                        break;
                    }
                }
                for(int i=0; i<4; i++)                                                  //Identification du TAG RFID n°3
                {
                    if(tag[i] == tag3[i]) 
                    {
                        egal3 = 1;                                                      //Le TAG RFID n°3 est détecté
                        pc.printf("Tag3 - OK ");
                        pc.printf("\n\r");
                        break;
                    } 
                    else if(tag[i] != tag3[i]) 
                    {
                        pc.printf("Tag3 - NOK ");
                        pc.printf("\n\r");
                        egal3 = 0;                                                      //Le TAG RFID n°3 n'est pas détecté
                        break;
                    }
                }
                for(int i=0; i<4; i++)                                                  //Identification du TAG RFID n°4
                {
                    if(tag[i] == tag4[i]) 
                    {
                        egal4 = 1;                                                      //Le TAG RFID n°4 est détecté
                        pc.printf("Tag4 - OK ");
                        pc.printf("\n\r");
                        break;
                    } 
                    else if(tag[i] != tag4[i]) 
                    {
                        pc.printf("Tag4 - NOK ");
                        pc.printf("\n\r");
                        egal4 = 0;                                                      //Le TAG RFID n°4 n'est détecté
                        break;
                    }
                }
                for(int i=0; i<4; i++)                                                  //Identification du TAG RFID n°5
                {
                    if(tag[i] == tag5[i]) 
                    {
                        egal5 = 1;                                                      //Le TAG RFID n°5 est détecté
                        pc.printf("Tag5 - OK ");
                        pc.printf("\n\r");
                        break;
                    } else if(tag[i] != tag5[i]) 
                    {
                        pc.printf("Tag5 - NOK ");
                        pc.printf("\n\r");
                        egal5 = 0;                                                      //Le TAG RFID n°5 n'est pas détecté
                        break;
                    }
                }
                reponse_rfid[1]=0x00;
            }

            led1=0;
            led2=0;
            led3=1;

            wait_ms(500);

        }


        if(capext ==1 && egal1 ==1)                                                    //Si le capteur extérieur est à 1 & le TAG 1 est détecté
        {
            pc.printf("---------- Envoi de donnees au serveur ----------\r\n");        //Envoi de données au serveur
            pc.printf("---------- L'animal vient de l'exterieur ---------\r\n");
            pc.printf("---------- Le TAG numero 1 est detecte ----------\r\n");
            strcpy(snd, "AT+CIPSEND=4\r\n");                                           //Commande envoyant le nombre de bytes voulu
            SendCMD();
            timeout=3;
            getreply();
            pc.printf(buf);
            strcpy(snd, "ECHA\r\n");                                                    //Le chat vient de l'extérieur
            SendCMD();
            timeout=3;
            getreply();
            pc.printf(buf);                                                             //Statut de l'étape (OK/ERROR)
            if (F411==1) 
            {                                                                           //Vérification alimentation servo par F411
           pc.printf("++++++++ Deblocage de la chatiere ++++++++\r\n");
            myservo = pos2 ;                                                            //Position du servomoteur n°2 (ouvert)
            wait(2)    ;                                                                
            while(capteurfermeture==0)
            {
                led3=1;
                
            } 
                led3=0;
                pc.printf("++++++++ Passage de l'animal ++++++++\r\n");
                wait(2);
                while(capteurfermeture==0)
                    {
                    led2=1;
                    }
                wait(1);
                pc.printf("++++++++ Verrouillage de la chatiere ++++++++\r\n");                                                           
                myservo = pos3 ;                                                        //Position du servomoteur n°3(bloqué)
                position=3;
            }
            else
            {
                pc.printf("++++++++ L'animal n'est pas autorise a entrer ++++++++\n\r");
            } 
        }                
        
    if(capint ==1 && egal1 ==1)                                                         //Si le capteur intérieur est à 1 & le TAG 1 est détecté
    {                                                       
        pc.printf("---------- Envoi de donnees au serveur ----------\r\n");             //Envoi de données au serveur
        pc.printf("---------- L'animal vient de l'interieur ---------\r\n");
        pc.printf("---------- Le TAG numero 1 est detecte ----------\r\n");
        strcpy(snd, "AT+CIPSEND=4\r\n");                                                //Commande envoyant le nombre de bytes voulu
        SendCMD();
        timeout=3;
        getreply();
        pc.printf(buf);
        strcpy(snd, "ICHA\r\n");                                                        //Le chat vient de l'intérieur
        SendCMD();
        timeout=3;
        getreply();
        pc.printf(buf);                                                                 //Statut de l'étape (OK/ERROR)
        if (F411 ==1) 
        {                                                                               //Vérification alimentation servo par F411 (MyHome)
            pc.printf("++++++++ Deblocage de la chatiere ++++++++\r\n");
            myservo = pos2 ;                                                            //Position du servomoteur n°2 (ouvert)
            wait(2)    ;                                                                
            while(capteurfermeture==0)
            {
                led3=1;
                
            } 
                led3=0;
                pc.printf("++++++++ Passage de l'animal ++++++++\r\n");
                wait(2);
                while(capteurfermeture==0)
                    {
                    led2=1;
                    }
                wait(1);
                pc.printf("++++++++ Verrouillage de la chatiere ++++++++\r\n");                                                           
                myservo = pos3 ;                                                        //Position du servomoteur n°3(bloqué)
                position=3;                                                             
        }
        else 
        {
            pc.printf("++++++++ L'animal n'est pas autorise a sortir ++++++++\n\r");
        }
    }

    if(capext ==1 && egal2 ==1)                                                        //Si le capteur extérieur est à 1 & le TAG 2 est détecté
        {
            pc.printf("---------- Envoi de donnees au serveur ----------\r\n");        //Envoi de données au serveur
            pc.printf("---------- L'animal vient de l'exterieur ---------\r\n");
            pc.printf("---------- Le TAG numero 2 est detecte ----------\r\n");
            strcpy(snd, "AT+CIPSEND=4\r\n");                                           //Commande envoyant le nombre de bytes voulu
            SendCMD();
            timeout=3;
            getreply();
            pc.printf(buf);
            strcpy(snd, "ECHA\r\n");                                                    //Le chat vient de l'extérieur
            SendCMD();
            timeout=3;
            getreply();
            pc.printf(buf);                                                             //Statut de l'étape (OK/ERROR)
            if (F411==1) 
            {                                                                           //Vérification alimentation servo par F411
            pc.printf("++++++++ Deblocage de la chatiere ++++++++\r\n");
                myservo = pos2 ;                                                        //Position du servomoteur n°2 (ouvert)
                wait(2);   
                while(capteurfermeture==0)
                    {
                    led2=1;
                    }
                    led2=0;
                    pc.printf("++++++++ Passage de l'animal ++++++++\r\n");
                    wait(2);
                    while(capteurfermeture==0)
                    {
                    led2=1;
                    }
                    wait(1);
                    pc.printf("++++++++ Verrouillage de la chatiere ++++++++\r\n");
                    myservo=pos3;                                                       //Position du servomoteur n°3(bloqué)
                    position = 3;
            }
            else 
            {
                pc.printf("++++++++ L'animal n'est pas autorise a entrer ++++++++\n\r");
            } 
        }            

    if(capint ==1 && egal2 ==1)                                                         //Si le capteur extérieur est à 1 & le TAG 2 est détecté
        {
            pc.printf("---------- Envoi de donnees au serveur ----------\r\n");         //Envoi de données au serveur
            pc.printf("---------- L'animal vient de l'interieur ---------\r\n");
            pc.printf("---------- Le TAG numero 2 est detecte ----------\r\n");
            strcpy(snd, "AT+CIPSEND=4\r\n");                                            //Commande envoyant le nombre de bytes voulu
            SendCMD();
            timeout=3;
            getreply();
            pc.printf(buf);
            strcpy(snd, "ECHA\r\n");                                                    //Le chat vient de l'extérieur
            SendCMD();
            timeout=3;
            getreply();
            pc.printf(buf);                                                             //Statut de l'étape (OK/ERROR)
            if (F411==1) 
            {                                                                           //Vérification alimentation servo par F411
            pc.printf("++++++++ Deblocage de la chatiere ++++++++\r\n");
                myservo = pos2 ;                                                        //Position du servomoteur n°2 (ouvert)
                wait(2);   
                while(capteurfermeture==0)
                    {
                    led2=1;
                    }
                    led2=0;
                    pc.printf("++++++++ Passage de l'animal ++++++++\r\n");
                    wait(2);
                    while(capteurfermeture==0)
                    {
                    led2=1;
                    }
                    wait(1);
                    pc.printf("++++++++ Verrouillage de la chatiere ++++++++\r\n");
                    myservo=pos3;                                                       //Position du servomoteur n°3(bloqué)
                    position = 3;
            }
            else 
            {
                pc.printf("++++++++ L'animal n'est pas autorise a sortir ++++++++\n\r");
            } 
        }    
    if(capext ==1 && egal3 ==1)                                                         //Si le capteur extérieur est à 1 & le TAG 3 est détecté
        {
            pc.printf("---------- Envoi de donnees au serveur ----------\r\n");         //Envoi de données au serveur
            pc.printf("---------- L'animal vient de l'exterieur ---------\r\n");
            pc.printf("---------- Le TAG numero 3 est detecte ----------\r\n");
            strcpy(snd, "AT+CIPSEND=4\r\n");                                            //Commande envoyant le nombre de bytes voulu
            SendCMD();
            timeout=3;
            getreply();
            pc.printf(buf);
            strcpy(snd, "ECHA\r\n");                                                    //Le chat vient de l'extérieur
            SendCMD();
            timeout=3;
            getreply();
            pc.printf(buf);                                                             //Statut de l'étape (OK/ERROR)
            if (F411==1) 
            {                                                                           //Vérification alimentation servo par F411
            pc.printf("++++++++ Deblocage de la chatiere ++++++++\r\n");
                myservo = pos2 ;                                                        //Position du servomoteur n°2 (ouvert)
                wait(2);   
                while(capteurfermeture==0)
                    {
                    led2=1;
                    
                    }
                    led2=0;
                    pc.printf("++++++++ Passage de l'animal ++++++++\r\n");
                    wait(2);
                    while(capteurfermeture==0)
                    {
                    led2=1;
                    }
                    wait(1);
                    pc.printf("++++++++ Verrouillage de la chatiere ++++++++\r\n");
                    myservo=pos3;                                                       //Position du servomoteur n°3(bloqué)
                    position = 3;
            }
            else
            {
                pc.printf("++++++++ L'animal n'est pas autorise a entrer ++++++++\n\r");
            } 
        }   
    if(capint ==1 && egal3 ==1)                                                         //Si le capteur inérieur est à 1 & le TAG 3 est détecté
        {
            pc.printf("---------- Envoi de donnees au serveur ----------\r\n");         //Envoi de données au serveur
            pc.printf("---------- L'animal vient de l'interieur ---------\r\n");
            pc.printf("---------- Le TAG numero 3 est detecte ----------\r\n");
            strcpy(snd, "AT+CIPSEND=4\r\n");                                            //Commande envoyant le nombre de bytes voulu
            SendCMD();
            timeout=3;
            getreply();
            pc.printf(buf);
            strcpy(snd, "ECHA\r\n");                                                    //Le chat vient de l'extérieur
            SendCMD();
            timeout=3;
            getreply();
            pc.printf(buf);                                                             //Statut de l'étape (OK/ERROR)
            if (F411==1) 
            {                                                                           //Vérification alimentation servo par F411
            pc.printf("++++++++ Deblocage de la chatiere ++++++++\r\n");
                myservo = pos2 ;                                                        //Position du servomoteur n°2 (ouvert)
                wait(2);   
                while(capteurfermeture==0)
                    {
                    led2=1;
                    }
                    led2=0;
                    pc.printf("++++++++ Passage de l'animal ++++++++\r\n");
                    wait(2);
                    while(capteurfermeture==0)
                    {
                    led2=1;
                    }
                    wait(1);
                    pc.printf("++++++++ Verrouillage de la chatiere ++++++++\r\n");
                    myservo=pos3;                                                       //Position du servomoteur n°3(bloqué)
                    position = 3;
            }
            else
            {
                pc.printf("++++++++ L'animal n'est pas autorise a sortir ++++++++\n\r");
            } 
        }
    if(capext ==1 && egal4 ==1)                                                         //Si le capteur extérieur est à 1 & le TAG 4 est détecté
        {
            pc.printf("---------- Envoi de donnees au serveur ----------\r\n");        //Envoi de données au serveur
            pc.printf("---------- L'animal vient de l'exterieur ---------\r\n");
            pc.printf("---------- Le TAG numero 4 est detecte ----------\r\n");
            strcpy(snd, "AT+CIPSEND=4\r\n");                                           //Commande envoyant le nombre de bytes voulu
            SendCMD();
            timeout=3;
            getreply();
            pc.printf(buf);
            strcpy(snd, "ECHA\r\n");                                                    //Le chat vient de l'extérieur
            SendCMD();
            timeout=3;
            getreply();
            pc.printf(buf);                                                             //Statut de l'étape (OK/ERROR)
            if (F411==1) 
            {                                                                           //Vérification alimentation servo par F411
            pc.printf("++++++++ Deblocage de la chatiere ++++++++\r\n");
                myservo = pos2 ;                                                        //Position du servomoteur n°2 (ouvert)
                wait(2);   
                while(capteurfermeture==0)
                    {
                    led2=1;
                    }
                    led2=0;
                    pc.printf("++++++++ Passage de l'animal ++++++++\r\n");
                    wait(2);
                    while(capteurfermeture==0)
                    {
                    led2=1;
                    }
                    wait(1);
                    pc.printf("++++++++ Verrouillage de la chatiere ++++++++\r\n");
                    myservo=pos3;                                                       //Position du servomoteur n°3(bloqué)
                    position = 3;
            }
            else
            {
                pc.printf("++++++++ L'animal n'est pas autorise a entrer ++++++++\n\r");
            } 
        }
    if(capint ==1 && egal4 ==1)                                                         //Si le capteur intérieur est à 1 & le TAG 1 est détecté
        {
            pc.printf("---------- Envoi de donnees au serveur ----------\r\n");         //Envoi de données au serveur
            pc.printf("---------- L'animal vient de l'interieur ---------\r\n");
            pc.printf("---------- Le TAG numero 4 est detecte ----------\r\n");
            strcpy(snd, "AT+CIPSEND=4\r\n");                                            //Commande envoyant le nombre de bytes voulu
            SendCMD();
            timeout=3;
            getreply();
            pc.printf(buf);
            strcpy(snd, "ECHA\r\n");                                                    //Le chat vient de l'extérieur
            SendCMD();
            timeout=3;
            getreply();
            pc.printf(buf);                                                             //Statut de l'étape (OK/ERROR)
            if (F411==1) 
            {                                                                           //Vérification alimentation servo par F411
            pc.printf("++++++++ Deblocage de la chatiere ++++++++\r\n");
                myservo = pos2 ;                                                        //Position du servomoteur n°2 (ouvert)
                wait(2);   
                while(capteurfermeture==0)
                    {
                    led2=1;
                    }
                    led2=0;
                    pc.printf("++++++++ Passage de l'animal ++++++++\r\n");
                    wait(2);
                    while(capteurfermeture==0)
                    {
                    led2=1;
                    }
                    wait(1);
                    pc.printf("++++++++ Verrouillage de la chatiere ++++++++\r\n");
                    myservo=pos3;                                                       //Position du servomoteur n°3(bloqué)
                    position = 3;
            }
            else
            {
                pc.printf("++++++++ L'animal n'est pas autorise a sortir ++++++++\n\r");
            } 
        }        
     if(capext ==1 && egal5 ==1)                                                        //Si le capteur extérieur est à 1 & le TAG 4 est détecté
        {
            pc.printf("---------- Envoi de donnees au serveur ----------\r\n");         //Envoi de données au serveur
            pc.printf("---------- L'animal vient de l'exterieur ---------\r\n");
            pc.printf("---------- Le TAG numero 5 est detecte ----------\r\n");
            strcpy(snd, "AT+CIPSEND=4\r\n");                                            //Commande envoyant le nombre de bytes voulu
            SendCMD();
            timeout=3;
            getreply();
            pc.printf(buf);
            strcpy(snd, "ECHA\r\n");                                                    //Le chat vient de l'extérieur
            SendCMD();
            timeout=3;
            getreply();
            pc.printf(buf);                                                             //Statut de l'étape (OK/ERROR)
            if (F411==1) 
            {                                                                           //Vérification alimentation servo par F411
            pc.printf("++++++++ Deblocage de la chatiere ++++++++\r\n");
                myservo = pos2 ;                                                        //Position du servomoteur n°2 (ouvert)
                wait(2);   
                while(capteurfermeture==0)
                    {
                    led2=1;
                    }
                    led2=0;
                    pc.printf("++++++++ Passage de l'animal ++++++++\r\n");
                    wait(2);
                    while(capteurfermeture==0)
                    {
                    led2=1;
                    }
                    wait(1);
                    pc.printf("++++++++ Verrouillage de la chatiere ++++++++\r\n");
                    myservo=pos3;                                                       //Position du servomoteur n°3(bloqué)
                    position = 3;
            }
            else
            {
                pc.printf("++++++++ L'animal n'est pas autorise a entrer ++++++++\n\r");
            } 
        }
    if(capint ==1 && egal5 ==1)                                                         //Si le capteur intérieur est à 1 & le TAG 1 est détecté
        {
            pc.printf("---------- Envoi de donnees au serveur -----------\r\n");        //Envoi de données au serveur
            pc.printf("---------- L'animal vient de l'interieur ---------\r\n");
            pc.printf("---------- Le TAG numero 5 est detecte -----------\r\n");
            strcpy(snd, "AT+CIPSEND=4\r\n");                                            //Commande envoyant le nombre de bytes voulu
            SendCMD();
            timeout=3;
            getreply();
            pc.printf(buf);
            strcpy(snd, "ECHA\r\n");                                                    //Le chat vient de l'extérieur
            SendCMD();
            timeout=3;
            getreply();
            pc.printf(buf);                                                             //Statut de l'étape (OK/ERROR)
            if (F411==1) 
            {                                                                           //Vérification alimentation servo par F411
            pc.printf("++++++++ Deblocage de la chatiere ++++++++\r\n");
                myservo = pos2 ;                                                        //Position du servomoteur n°2 (ouvert)
                wait(1);   
                while(capteurfermeture==0)
                    {
                    led2=1; 
                    }
                    led2=0;
                    pc.printf("++++++++ Passage de l'animal ++++++++\r\n");
                    wait(2);
                    while(capteurfermeture==0)
                    {
                    led2=1;
                    }
                    wait(1);
                    pc.printf("++++++++ Verrouillage de la chatiere ++++++++\r\n");
                    myservo=pos3;                                                       //Position du servomoteur n°3(bloqué)
                    position = 3;
            }
            else
            {
                pc.printf("++++++++ L'animal n'est pas autorise a sortir ++++++++\n\r");
            } 
        }
        
    while(bpmanuel ==1 ) 
    {                                                                                   //Activation du mode manuel
        if(pass==0)
        { 
        pc.printf("\r------------------- Le mode manuel est actif ---------------------\r\n\n");
        pass = 1 ;
        }
        pass5 = 0;
        ledmm = 1 ;                                                                    //Allumage Led indiquant que le mode manuel est activé
        if (manuel1==1)
        {
            position = 1;
        }
         if (manuel2==1)
        {
            position = 2;
        }
        if (manuel3==1)
        {
            position = 3;
        }   
        switch(position)                                                                    //Switch en fonction de la position de la chatière pour le mode manuel
        {
            case 1 :                                                                        //Mode manuel position n°1 (entrée seulement)
                    pass2=0;
                    pass3=0;
                    if(capteurfermeture==1)                                                 //Vérification de la fermeture de la chatière
                    {
                    myservo = pos1 ;                                                        //Position du servomoteur n°1
                    position = 1;                                                           //La chatière est en position n°1 (entrée seulement)
                    if(pass1==0)
                    {                                                          
                    pc.printf("++++++++ La chatiere est en position numero 1 : entree seulement +++++++\r\n\n");
                    pass1 = 1 ;
                    }}
                break;                                                                      //Fin du case n°1     
            case 2 :                                                                        //Mode manuel position n°2 (entréé ou sortie)
                    pass1=0;
                    pass3=0;
                    if(capteurfermeture==1)                                                 //Vérification de la fermeture de la chatière
                    {
                    myservo = pos2 ;                                                        //Position du servomoteur n°2
                    position = 2;                                                           //La chatière est en position n°2 (entréé ou sortie)
                    if(pass2==0)
                    {
                    pc.printf("++++++++ La chatiere est en position numero 2 : ouverte ++++++++\r\n\n");
                    pass2 = 1;
                    }}
                break;                                                                      //Fin du case n°2
            case 3 :                                                                        //Mode manuel position n°3 (verrouillage complet)
                    pass1=0;
                    pass2=0;                                                                        
                    if(capteurfermeture==1)                                                 //Vérification de la fermeture de la chatière
                    {
                    myservo = pos3 ;                                                        //Position du servomoteur n°3
                    position = 3;                                                           //La chatière est en position n°3 (verrouillage complet)
                    if(pass3==0)
                    {
                    pc.printf("++++++++ La chatiere est en position numero 3 : verouillage complet ++++++++\r\n\n");
                    pass3 = 1 ;
                    }}                                                                      //Fin du case n°3
                break;                                                                  
            default :                                                                               
        }                                                                                   //Fin du switch
 }                                                                                       //Fin du mode manuel
    if(pass5==0)
    {
    pc.printf("-------------------- Le mode manuel est inactif -----------------\r\n\n");
    pc.printf("-------------------- La chatiere est verrouillee ----------------\r\n\n");
    pass5=1;
    }
    pass = 0 ;
    
    pass5 = 1 ;
    myservo=pos3;                                                                          
}}                                                                                  //Fin du int main
//+++++++++++++++++++++++++++++ Voids RFID +++++++++++++++++++++++++++++

void Antenna()
{
    pc.printf("\n\r");
    pc.printf("ANTENNA NOT DETECTED");
    pc.printf("\n\r");
}

void field()
{
    pc.printf("\n\r");
    pc.printf("NOT TAG IN FIELD");
    pc.printf("\n\r");
}

//  +++++++++++++++++++++++++++++++++ This is for ESP8266 config only, run this once to set up the ESP8266 +++++++++++++++
void ESPconfig()
{
    wait(2);
    strcpy(snd,"AT\r\n");
    SendCMD();
    timeout=1;
    getreply();
    wait(1);
    pc.printf("-------------- Redemarrage du module --------------\r\n");               //Redémarrage du module WIFI ESP8266
    strcpy(snd,"AT+RST\r\n");                                                           //Commande redémarrage du module WIFI ESP8266
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(buf);

    wait(2);                                                                            //Délai inter-étape

    pc.printf("\n---------- Mode Wifi ----------\r\n");                                 //Initialisation du mode WIFI
    strcpy(snd, "AT+CWMODE=3\r\n");                                                     //Commande initialisation du module WIFI ESP8266
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(buf);

    wait(1);                                                                            //Délai inter-étape

    pc.printf("\n---------- Connexion au point d acces ----------\r\n");                //Connection au serveur IOP
    pc.printf("ssid = %s   pwd = %s\r\n",ssid,pwd);
    strcpy(snd, "AT+CWJAP=\"");                                                         //Commande de connection au serveur IOP
    strcat(snd, ssid);
    strcat(snd, "\",\"");
    strcat(snd, pwd);
    strcat(snd, "\"\r\n");
    SendCMD();
    timeout=10;
    getreply();
    pc.printf(buf);                                                                     //Statut de l'étape (OK/ERROR)

    wait(2);                                                                            //Délai inter-étape

    pc.printf("\n---------- Adresse IP local ----------\r\n");                          //Adressage IP
    strcpy(snd, "AT+CIFSR\r\n");                                                        //Commande affichant adresse IP et MAC du PC ainsi que du module WIFI ESP8266
    SendCMD();
    timeout=3;
    getreply();
    pc.printf(buf);                                                                     //Statut de l'étape (OK/ERROR)

    wait(2);                                                                            //Délai inter-étape

    pc.printf("\n---------- TCP Client ----------\r\n");                                //Connection au serveur en tant que client
    strcpy(snd, "AT+CIPSTART=\"TCP\",\"192.168.2.1\",55555\r\n");                     //Commande connection au serveur : Protocol , Adresse IP serveur , port
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(buf);                                                                     //Statut de l'étape (OK/ERROR)

    wait(2);                                                                            //Délai inter-étape


}                                                                                       //Fin du void config

void SendCMD()
{
    esp.printf("%s", snd);
}

void getreply()
{
    memset(buf, '\0', sizeof(buf));
    t.start();
    ended=0;
    count=0;
    while(!ended) {
        if(esp.readable()) {
            buf[count] = esp.getc();
            count++;
        }
        if(t.read() > timeout) {
            ended = 1;
            t.stop();
            t.reset();
        }
    }
}