#include "mbed.h"
#include "MODSERIAL.h"
#include "MACROS.h"
#include <string>

char position[16]={"45.1234,1.12345"};
char reponse_gsm[256];
int element=0;

Serial pc(USBTX,USBRX);
MODSERIAL gsm(p9,p10);

DigitalOut pwrkey(p21);
DigitalOut emerg_off(p22);
DigitalIn status(p11);

void reception();
void clear_pc(void);
void clear_buffer(void);
void power_on();
void init_gsm();
void data_gsm();

int main() {
  
   for (int i=0;i<20;i++) reponse_gsm[i]=0; //initialisation tableau réponse
   
    gsm.baud(115200);
    pc.baud(115200);
    
    clear_buffer();
    pc.printf("Le buffer serie est vide\r\n");
    wait(2);
    clear_pc();
    pc.printf("Le buffer pc est vide\r\n");
   
    init_gsm();
    clear_buffer();
   while(1){
     
    reception();
    wait(5);
   }
    
}


void init_gsm(){
    
    power_on();
    wait(2);
    
    pc.printf("=======================\r\n");
    pc.printf("Configuration du module\r\n");
    pc.printf("=======================\r\n");
    
    gsm.printf("AT\r");
    wait(0.3);
    pc.printf("AT\r\n");
    data_gsm();
    gsm.printf("AT+CPIN=1234\r"); // je rentre le code pin
    wait(5);
    pc.printf("AT+CPIN=1234\r\n");
    data_gsm();
    gsm.printf("ATE0\r"); // pas d'echo vers le DTE pour les l'envoi des commandes
    wait(0.3); 
    gsm.printf("AT+CMGF=1\r"); // je passe en mode texte
    wait(0.3);
    gsm.printf("AT+CNMI=2,1,0,0,0\r");
    wait(0.3);
    gsm.printf("AT+CMGD=1,4\r");
    wait(0.3);
  }     
  
void data_gsm(){
   for(int i=0;i<255;i++) reponse_gsm[i]=0;
    element=0;
    while(gsm.readable()){
         reponse_gsm[element]=gsm.getc();
         element++;
         }
    for(int i=0; i<element; i++)pc.printf("%c",reponse_gsm[i]);
    pc.printf("\n\r");
   
} 

void power_on(){
    pwrkey=1;
    wait(3);
    while(status==0);
    wait(1);
    pwrkey=0;
    pc.printf("\n | Module connected | \r\n");
} 

void clear_buffer(){
    char char1;
    while(gsm.readable()){
        char1 = gsm.getc();
        }
        return;
   }     
     
void clear_pc(){
    char char1;
    while(pc.readable()){
        char1 = pc.getc();
        pc.printf("Le buffer pc est vide\r\n");
        }
        return;
   }          
        
void reception(){
    int notification =0 ;
    int nouveau_message = 0 ;
    char sms[256];
    char sms_brut[256];
    char num_mem[3];
    int longueur_msg1=0;
    int longueur_msg2=0;
    char numero[12];
    
    pc.printf("Reception !\r\n");
    
    // attente notification
        while(gsm.readable()){
        sms[longueur_msg1] = gsm.getc();
          pc.printf("%c ",sms[longueur_msg1]);
        longueur_msg1++;
        nouveau_message = 1 ;
        }
        sms[longueur_msg1] = '\0';
        
        notification = 0 ;
        if (nouveau_message == 1)
        {
        pc.printf("Nouveau message : %s \r\n", sms);
        
        if (strncmp(sms,"\r\n+CMTI",7)==0)
        {notification = 1 ;
          pc.printf("Nouvelle notification ! \r\n");
        }
        else
        {notification = 0 ;
         pc.printf("Pas de notification ! \r\n");
         }
        nouveau_message = 0 ;
        // si notification
        if (notification == 1)
        {
        num_mem[0]=sms[14];
        num_mem[1]=sms[15];
        num_mem[2]='\0';
        pc.printf("Notification recue : %s, longueur_msg= %d \r\n", sms, longueur_msg1);
        pc.printf("Numero memoire : %s \r\n", num_mem );
        // lecture memoire sms
        notification = 0 ;
        
        pc.printf("AT+CMGR=%s",num_mem );
        gsm.printf("AT+CMGR=%s\r",num_mem );
        wait(1);
        
      
        
        longueur_msg2 = 0 ;
         while(gsm.readable()){
        sms[longueur_msg2] = gsm.getc();
        pc.printf("%c ",sms[longueur_msg2]);
        longueur_msg2++; 
        }
        sms[longueur_msg2] = '\0';
        pc.printf("sms recu : %s, longueur_msg= %d \r\n", sms, longueur_msg2);
        // suppression en tete
          numero[0]=sms[23];
        numero[1]=sms[24];
        numero[2]=sms[25];
        numero[3]=sms[26];
        numero[4]=sms[27];
        numero[5]=sms[28];
        numero[6]=sms[29];
        numero[7]=sms[30];
        numero[8]=sms[31];
        numero[9]=sms[32];
        numero[10]=sms[33];
        numero[11]=sms[34];
        numero[12]='\0';
        pc.printf("Le numero du message : %s \r\n", numero);
        for (int i=0;i<100;i++)
        {
        sms_brut[i]= sms[66+i];
        }
        // affichage message brut
         pc.printf("sms brut : %s", sms_brut);
       
        if (strncmp(sms_brut,"POS?",4)==0)
        { pc.printf("Demande de position !");
        
        pc.printf("AT+CMGS=\"%s\"\r",numero);
        gsm.printf("AT+CMGS=\"%s\"\r",numero);
        gsm.printf("%s",position);
        gsm.putc(0x1A);
        pc.printf("SMS position parti  !");
        clear_buffer();
        pc.printf("buffer vide  !");
       }  
    }
  } 
}