/* JF - Lycee Cabanis de Brive-la-Gaillarde - date : 20180304*/
/* Essai gsm modem M95 : envoi SMS */

#include "mbed.h"
 
 void power_on();   // to turn on le modem gsm
 void led1_blink(); // to blink led1
 void reset();      // to reset gsm modem
 void init_gsm();   // to init gsm modem
 void data_gsm();    //to receive a reply from gsm
 void reset_buffer();   // to reset rx buffer
 void power_off(); // Pour eteindre le module gsm
  
 DigitalOut led1(LED1);
 DigitalOut led2(LED2);
 DigitalOut led3(LED3);
 DigitalOut led4(LED4);
 
 DigitalOut  bp_fire(p14);
 DigitalOut  pwrkey(p21);
 DigitalOut  emerg_off(p22);
 DigitalIn status(p11);
  
Serial pc(USBTX, USBRX); // creation objet -> stream serial USB
Serial gsm(p9,p10); // creation objet -> stream serial uart p9 et p10


char message_transmis[100]={"Module GSM "};
char code_pin[5]={"1234"};
char reponse_gsm[256];
int element=0;  //indice pour tableau
int octet=0;

int main() 
 {
    //gsm.attach(&callback_rx);
    //gsm.baud(9600);  // vitesse uart gsm 9600 bauds
    //gsm.format(8,Serial::None,1); //Serial frame format
    for (int i=0;i<20;i++) reponse_gsm[i]=0; // initialisation tableau réponses
    
    pc.printf("Lycee cabanis - Brive-la-Gaillarde - date : 20180304");
    pc.printf("\n\r>");
    pc.printf("Essai gsm modem m95 : envoi SMS");
    pc.printf("\n\r>");
    
    init_gsm();
    pc.printf("Appuyez sur ''bp enter'' pour envoi SMS");
    pc.printf("\n\r>");
    
      
    while (1) {          
        
        if(bp_fire==1){
            // envoi message SMS au N° pré-saisi           
            gsm.printf("AT+CMGS=\"0618981390\" \r");
            gsm.printf("%s",message_transmis);
            gsm.putc(0x1A); // envoi ctrl+Z
            //wait(30);   // l'envoi du message SMS prends en 120 s maximum
            
            pc.printf("AT+CMGS=\"0618981390\" \r");
            pc.printf("\n\r>");
            pc.printf("%s",message_transmis);
            pc.putc(0x1A); // envoi ctrl+Z
            pc.printf("\n\r>");
                                
            wait(15);   // l'envoi du message SMS prends en 120 s maximum
            
            for (int i=0;i<20;i++) reponse_gsm[i]=0; // initialisation tableau réponses
            //reply_gsm();  // réponse du gsm
            
            pc.printf("Appuyez sur ''bp_enter'' pour envoi SMS");
            pc.printf("\n\r>");
            }
    }
        
}


       
// to turn on_off le modem gsm m95
void power_on(){
    pwrkey=1;   // création impulsion turn on sur ligne pwrkey
    wait(3);
    
    while(status==0);   // attente démarrage modem m95
    led1_blink();
    led1=1; 
    wait(1);
    pwrkey=0;
    }
    
void power_off(){
    while(bp_fire==1){
        gsm.printf("AT+QPOWD=1\r");
        wait(0.3);
        pc.printf("Arret en cours...\r\n");
        data_gsm();
    } 
}
    
// to turn on_off le modem gsm m95
void reset(){
    emerg_off=1;  // création impulsion turn on sur ligne emerg_off
    wait(0.7);
    emerg_off=0;
    wait(12);
    }

// to blink led1    
void led1_blink(){
    //int i;
    for(int i=0;i<3;i++)
        {
            led1=1;
            wait(0.250);
            led1=0;
            wait(0.250);
        }
    }
 // Recevoir une réponse du gsm    
/*void callback_rx() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    reponse_gsm[octet++]=gsm.getc());
    octet = octet++;
}*/
void data_gsm(){   
    for (int i=0;i<255;i++) reponse_gsm[i]=0; // initialisation tableau réponses
    element=0;
    while (gsm.readable()){
            reponse_gsm[element]=gsm.getc();
            element++;
            }
    for(int i=0 ; i<element ; i++)pc.printf("%c",reponse_gsm[i]);
    pc.printf("\n\r>");
    }

void reset_buffer(){
    while (gsm.readable()){
            reponse_gsm[element]=gsm.getc();
            element++;
            }
        } 
    
    
void init_gsm(){   
    pc.printf("Patientez quelques instants : initialisation du modem gsm");
    pc.printf("\n\r>");
    wait(5);    //tempo pour établissement tension alim. modem
    power_off(); // modem off
    pc.printf("Appuyez sur ''bp enter'' pour demarrer le modem gsm");
    pc.printf("\n\r>");
    while(bp_fire==0);
    
    /*led1=1;
    pwrkey=1;
    wait(5);
    pwrkey=0;*/
    //emerg_off=0;
    //reset();    // modem off (shutdowm)
    //wait(5);
    power_on(); // modem on
    
    wait(5); //10 ok
    //reply_gsm(5);  // réponse du gsm;
    //reply_gsm(11);  // réponse du gsm;
    
    gsm.printf("AT\r"); // report erreur gsm
    data_gsm();
    pc.printf("AT\r\n");
    
    gsm.printf("AT+CPIN=1234\r",code_pin);
    //gsm.printf("AT+CPIN?");
    wait(5);
    pc.printf("AT+CPIN=1234\r");
    data_gsm();
    
    gsm.printf("ATE0\r"); // pas d'echo vers le DTE pour les l'envoi des commandes
    wait(2);
    //gsm.printf("ATE0?\r"); //
    pc.printf("ATE0\r\n"); // 
    data_gsm();
    
                                                                               
    gsm.printf("AT+CSQ\r"); // Query the signal strength of current network
    wait(2);
    gsm.printf("AT+CSQ?\r"); // 
    pc.printf("AT+CSQ?\r\n"); // 
    data_gsm();
    
    gsm.printf("AT+COPS=?\r"); // pour voir la Operator Selection
    gsm.printf("AT+COPS?\r\n");
    wait(25);   // 75s max. déterminé par le réseau
    pc.printf("AT+COPS?\r\n"); //
    data_gsm();
    
    
    gsm.printf("AT+CREG?\r"); // enregistrement du réseau
    wait(0.3);
    pc.printf("AT+CREG?\r\n"); // 
    data_gsm(); 
   
    
    gsm.printf("AT+CMEE=2\r"); // report erreur gsm
    wait(0.3);
    pc.printf("AT+CMEE=2\r\n"); // report erreur gsm
    data_gsm();
    
    gsm.printf("AT+CMEE?\r"); // report erreur gsm
    wait(0.3);
    pc.printf("AT+CMEE?\r"); // report erreur gsm
    data_gsm();
    
    
    gsm.printf("AT+CMGF=1\r"); // sélection du format du message SMS
    wait(2);
    //gsm.printf("AT+CMGF?"); // sélection du format du message SMS
    pc.printf("AT+CMGF=1\r\n"); // sélection du format du message SMS
    data_gsm();
    
    gsm.printf("AT+CMGF?\r"); // sélection du format du message SMS
    wait(2);
    //gsm.printf("AT+CMGF?"); // sélection du format du message SMS
    pc.printf("AT+CMGF?\r\n"); // sélection du format du message SMS
    data_gsm();
  }  
    
    

