#include "mbed.h"
#include "MODSERIAL.h"
#include "MACROS.h"
#include <string>
#include "stdio.h"
#include "Serial.h"
#include <cstdlib>


char position[16]={"45.1234,1.12345"};
char reponse_gsm[256];
int element=0;

// variables gps

DigitalOut led5(p7);


char debut_trame[7]="XXXXXX";
char trame[81] ;
char lat[8];
char lat_NS;
char lon[9];
char lon_EW;
float lat_cnv;
float lon_cnv;
int lat_deg = 0;
float lat_dec;
int lon_deg = 0;
float lon_dec;
char GPS [25];
char rx ;
int e ; 
int pos_ok = 0 ;

// liaisons series
Serial pc(USBTX, USBRX, 115200);
MODSERIAL gsm(p9,p10);
Serial gps(p13, p14, 4800);



DigitalOut pwrkey(p21);
DigitalOut emerg_off(p22);
DigitalIn status(p11);

void reception();
void clear_pc(void);
void clear_buffer(void);
void power_on();
void init_gsm();
void data_gsm();

int main() {
  
   for (int i=0;i<20;i++) reponse_gsm[i]=0; //initialisation tableau réponse
   
   gsm.baud(115200);
    // pc.baud(115200);
    
    clear_buffer();
    pc.printf("Le buffer serie est vide\r\n");
    wait(2);
    clear_pc();
    pc.printf("Le buffer pc est vide\r\n");
   
    init_gsm(); 
    pc.printf("gsm initialised \r\n");
    clear_buffer();
    /*
    gsm.printf("AT+CMGD=1,4\r");
    wait(0.5);
     pc.printf("Memoire sms est vide\r\n");
    */
    while(1)
    {
    // debut gps
    led5=0;
    pc.printf("debut GPS ");
    e = 0 ;
   pos_ok= 0 ;
   
    while(pos_ok==0 ) {
        if (gps.readable())
        {   
        rx  = gps.getc();
        // pc.printf("%c",rx);
            for(int i = 0; i <80; i++)
                { 
                trame[i] = trame[i+1];
               
                }
        trame[76]=rx ;
        }
        strncpy(debut_trame,trame,6);  
                     
            if (strcmp(debut_trame,"$GPGGA") == 0)
                {     
                
         
                    for (int i = 0; i<=8; i++)
                        {
                            lat[i] = trame [18+i];
                            lat_cnv = atof(lat);
                        }  
                lat_NS = trame [28];
        
                    for (int a=0; a<=9; a++)
                        {
                            lon[a] = trame [30+a];
                            lon_cnv = atof(lon);
                        }
                lon_EW = trame [41];

                lat_cnv = lat_cnv/100;
                lat_deg = (int)lat_cnv;
                lat_dec = lat_cnv - lat_deg;
                lat_dec = (lat_dec/60)*100; 
                lat_cnv = lat_deg + lat_dec;
                
                lon_cnv = lon_cnv/100;
                lon_deg = (int)lon_cnv;
                lon_dec = lon_cnv - lon_deg;
                lon_dec = (lon_dec/60)*100; 
                lon_cnv = lon_deg + lon_dec;
                
                    if (lat_NS=='N')
                        {
                            lat_cnv = lat_cnv*1;
                        }
                        
                    else if (lat_NS=='S')
                        {
                            lat_cnv = lat_cnv*(-1);
                        }
                        
                    if (lon_EW=='E')
                        {
                            lat_cnv = lat_cnv*1;
                        }
                        
                    else if (lon_EW=='W')
                        {
                            lat_cnv = lat_cnv*(-1);
                        }
                sprintf(GPS, "POS: %f,%f", lat_cnv, lon_cnv);
                
                pos_ok = 1 ;
                }
               
    } // fin while pos_ok

     pc.printf("%s \n\r", GPS); 
    reception();
    wait(5);
   }
    
}


void init_gsm(){
    /*
    pwrkey=1;
    wait(5);
    pwrkey=0;
    */
    power_on();
    wait(3);
     pc.printf("AT\r\n");
    gsm.printf("AT\r");
    // wait(0.5);
    pc.printf("AT\r\n");
    data_gsm();
    
    gsm.printf("AT+CPIN=1234\r"); // je rentre le code pin
    wait(5);
    pc.printf("AT+CPIN=1234\r\n");
    data_gsm();
   
    gsm.printf("ATE0\r"); // pas d'echo vers le DTE pour les l'envoi des commandes
    wait(5);
    
    
    gsm.printf("AT+CMGF=1\r"); // je passe en mode texte
    wait(2);
   
    
    gsm.printf("AT+CNMI=2,1,0,0,0\r");
    wait(2);
   

  }     
 

void data_gsm(){
   for(int i=0;i<255;i++) reponse_gsm[i]=0;
    element=0;
    while(gsm.readable()){
         reponse_gsm[element]=gsm.getc();
         element++;
         }
    for(int i=0; i<element; i++)pc.printf("%c",reponse_gsm[i]);
    pc.printf("\n\r");
   
} 

void power_on(){
    pwrkey=1;
    wait(3);
    while(status==0);
    wait(1);
    pwrkey=0;
    pc.printf("Le module est connecter ! \r\n");
} 

void clear_buffer(){
    char char1;
    while(gsm.readable()){
        char1 = gsm.getc();
        }
        return;
   }     
     
void clear_pc(){
    char char1;
    while(pc.readable()){
        char1 = pc.getc();
        pc.printf("Le buffer pc est vide\r\n");
        }
        return;
   }          
        
void reception(){
    int nouveau_message=0 ;
    char sms[256];
     char sms_brut[256];
    char num_mem[3];
    int longueur_msg1=0;
    int longueur_msg2=0;
    pc.printf("Reception ! \n");
    // attente notification
    while(gsm.readable()){
        sms[longueur_msg1] = gsm.getc();
          pc.printf("%c ",sms[longueur_msg1]);
        longueur_msg1++;
        nouveau_message = 1 ;
        }
        // si notification
        if (nouveau_message == 1)
        {
        num_mem[0]=sms[14];
        num_mem[1]=sms[15];
        num_mem[2]='\0';
        pc.printf("Notification recue : %s, longueur_msg= %d", sms, longueur_msg1);
        pc.printf("Numero memoire : %s", num_mem );
        // lecture memoire sms
        pc.printf("AT+CMGR=%s",num_mem );
        gsm.printf("AT+CMGR=%s\r",num_mem );
        wait(1);
        longueur_msg2 = 0 ;
         while(gsm.readable()){
        sms[longueur_msg2] = gsm.getc();
        // pc.printf("%c ",sms[longueur_msg2]);
        longueur_msg2++; 
        }
        pc.printf("sms recu : %s, longueur_msg= %d \n", sms, longueur_msg2);
        // suppression en tete
        for (int i=0;i<100;i++)
        {
        sms_brut[i]= sms[66+i];
        }
        // affichage message brut
         pc.printf("sms brut : %s", sms_brut);
       
        if (strncmp(sms_brut,"POS?",4)==0)
        { pc.printf("Demande de position !");
        gsm.printf("AT+CMGS=\"0618981390\"\r");
        gsm.printf("%s",GPS);
        gsm.putc(0x1A);
        nouveau_message = 0 ;
        }
        
    }
    
           
    
    

 }
