#include "mbed.h"
#include <iostream>
#include <string>
#include <fstream>

Serial pc(USBTX, USBRX);
Serial esp(p28, p27); // tx, rx
DigitalOut reset(p26);
Timer t;

int  count,ended,timeout;
char buf[1024];
char snd[255];
char ip[30] = "192.168.10.100";

char ssid[32];     
char pwd [32];

LocalFileSystem local("local");

void SendCMD(),getreply(),ESPconfig(),ESPsetbaudrate(),WIFI(), Donnee();

using namespace std;

int main()
{
    reset=0; //hardware reset for 8266
    pc.baud(9600);  // set what you want here depending on your terminal program speed
    pc.printf("\f\n\r-------------ESP8266 Hardware Reset-------------\n\r");
    wait(0.5);
    reset=1;
    timeout=2;
    getreply();

    esp.baud(115200);   // change this to the new ESP8266 baudrate if it is changed at any time.
     
    ESPconfig();        //******************  include Config to set the ESP8266 configuration  ***********************



    // continuosly get AP list and IP
    while(1) {
    pc.printf("\n---------- Informations sur la connexion ----------\r\n");
    strcpy(snd, "AT+CIPSTATUS\r\n");
    SendCMD();
    timeout=10;
    getreply();
    pc.printf(buf);
    wait(15);
    Donnee();
    }
    
}

void WIFI()
{
 using namespace std;
    pc.printf("\f\r -------------lecture du fichier------------- \f\r");
    pc.baud(9600);
    
    FILE *set = fopen("/local/ssid.txt", "r");
    fscanf(set,"%s ",ssid);
    
    FILE *mdp = fopen("/local/pwd.txt", "r");
    fscanf(mdp,"%s ",pwd);
    
    wait(2);
    pc.printf("\f\r\n Lecture du SSID de connection : \f\r\n");
    wait(2);
    pc.printf(" ssid : %s    \r\n",ssid);
    pc.printf(" password : %s    \r\n",pwd);
    fclose(set);
    fclose(mdp);
}

//  +++++++++++++++++++++++++++++++++ This is for ESP8266 config only, run this once to set up the ESP8266 +++++++++++++++
void ESPconfig()
{
    wait(5);
    strcpy(snd,"AT\r\n");
    SendCMD();
    timeout=1;
    getreply();
    wait(1);
    pc.printf("---------- Redemarrage du module ----------\r\n");
    strcpy(snd,"AT+RST\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(buf);

    wait(2);

    pc.printf("\n---------- Information sur la version ----------\r\n");
    strcpy(snd,"AT+GMR\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(buf);

    wait(3);

    // set CWMODE to 1=Station,2=AP,3=BOTH, default mode 1 (Station)
    pc.printf("\n---------- Mode Wifi ----------\r\n");
    strcpy(snd, "AT+CWMODE=1\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(buf);

    wait(2);

    // set CIPMUX to 0=Single,1=Multi
    pc.printf("\n---------- Choix de connexion multiple ou unique ----------\r\n");
    strcpy(snd, "AT+CIPMUX=1\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(buf);

    wait(2);

    pc.printf("\n---------- Liste des points de connexion ----------\r\n");
    strcpy(snd, "AT+CWLAP\r\n");
    SendCMD();
    timeout=15;
    getreply();
    pc.printf(buf);

    wait(2);
    WIFI();
    wait(2);

    pc.printf("\n---------- Connexion au point d acces ----------\r\n");
    pc.printf("ssid = %s   pwd = %s\r\n",ssid,pwd);
    strcpy(snd, "AT+CWJAP=\"");
    strcat(snd, ssid);
    strcat(snd, "\",\"");
    strcat(snd, pwd);
    strcat(snd, "\"\r\n");
    SendCMD();
    timeout=10;
    getreply();
    pc.printf(buf);

    wait(5);

    pc.printf("\n---------- Adresse IP local ----------\r\n");
    strcpy(snd, "AT+CIFSR\r\n");
    SendCMD();
    timeout=3;
    getreply();
    pc.printf(buf);

    wait(1);

    pc.printf("\n---------- Informations sur la connexion ----------\r\n");
    strcpy(snd, "AT+CIPSTATUS\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(buf);
    wait(10);
}

void SendCMD()
{
    esp.printf("%s", snd);
}

void Donnee()
{
    pc.printf("\n---------- Envoie de donnees ----------\r\n");
    strcpy(snd, "AT+CIPSEND=\"");
    strcat(snd, "192.168.10.23");
    strcat(snd, "\",\"");
    strcat(snd, "1234");
    strcat(snd, "\"\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(buf);
    wait(15);   
}

void getreply()
{
    memset(buf, '\0', sizeof(buf));
    t.start();
    ended=0;
    count=0;
    while(!ended) {
        if(esp.readable()) {
            buf[count] = esp.getc();
            count++;
        }
        if(t.read() > timeout) {
            ended = 1;
            t.stop();
            t.reset();
        }
    }
}
