/*---------VIKTIG---------*/
/*DET MÅ BENYTTES MBED OS5*/
/*---------VIKTIG---------*/

#include "mbed.h"

LocalFileSystem local("local");
Serial pc(USBTX, USBRX);
Thread threadInputOutput;//tråd for readInput(), setOutput() og reset()
Thread threadBlink;
Mutex mutexLogg, mutexAF, mutexZone;

/*------funksjoner starter her------*/

void inputOutput(void);//samler readInput, setOutput og reset i en felles tråd
void readInput(void);//leser status på innganger til tabell zone[]
void setOutput(void);//aktiverer utganger og kaller opp logg ved alarm eller feil
void reset(void);//full reset av anlegget. Anlegget må deaktiveres før reset
void logg(int i, int x);// soneadresse, melding
void terminalCommand(void);//leser input fra terminal og kaller funksjoner basert på dette

void showMenu(int menuOption);
int passwordFunc(void);//funksjon for passord-håndtering
void printStatus(void);//skriver ut status på soner og logg
void blink(void);//styrer lysindikatorer
void setTime(void);//funksjon for å stille klokke

/*------funksjoner slutter her------*/

#define HVILE 0
#define ALARM 1
#define BRUDD 2
#define FEIL 3
#define RESET 4

#define MAIN 1
#define STATUS 2

/*------innganger og utganger starter------*/

/*------------------------------/
|   zone 1 = ain p17. out p28   |
|   zone 2 = ain p17. out p27   |
|   zone 3 = ain p18. out p26   |
|   zone 4 = ain p18. out p25   |
|   zone 5 = ain p19. out p24   |
|   zone 6 = ain p19. out p23   |
|   zone 7 = ain p20. out p22   |
|   zone 8 = ain p20. out p21   |
/------------------------------*/

DigitalIn resetSwitch(p12);

AnalogIn ain0(p17), ain1(p18), ain2(p19), ain3(p20);

DigitalOut output[] = { p28, p27, p26, p25, p24, p23, p22, p21 };

DigitalOut indikatorLed(p5), feilLed(p6);
//indikatorLed: Lyser når anlegg er aktivt. Blinker (10Hz) ved alarm
//feilLed: blinker (10Hz) når anlegget er i en feiltilstand

volatile int zone[8] = {};//status på soner
volatile int state[8] = {};//minne for status på soner

char *zoneName[] = {//sonenavn. I-argument i logg()
    "zone 1 p17.1", "zone 2 p17.2",
    "zone 3 p18.1", "zone 4 p18.2",
    "zone 5 p19.1", "zone 6 p19.2",
    "zone 7 p20.1", "zone 8 p20.2",
    "System"
};

/*------innganger og utganger slutter------*/

struct tm t; // struct for lagring av klokkeinnstillinger

volatile int loggSize = 1; // brukes til å nummerere hendelser i loggen

volatile int isAlarm, isFeil, on;
//isAlarm: indikator for om anlegget er i alarm
/isFeil: indikator for om anlegget er i en feiltilstand
//on: indikator for om anlegget er i aktivert eller deaktivert tilstand


/*--------------------------main()----------------------------------/
|                                                                   |
|Ved oppstart initsieres tråder for lesing og skriving av input og  |
|output samt lysindikatorer.                                        |
|                                                                   |
|Deretter brukes main() som tråd for brukergrensesnitt ved å        |
|kontinuerlig kjøre terminalCommand().                              |
|                                                                   |
/------------------------------------------------------------------*/

int main()
{
    setTime();
    threadInputOutput.start(inputOutput);
    threadBlink.start(blink);

    while(1) {
        terminalCommand();
    }
}

/*-----------------------inputOutput()------------------------------/
|                                                                   |
|Hovedfunksjon i tråd threadInputPutput.                            |
|Global variabel 'on' settes fra terminal og indikerer om anlegg er |
|aktivert(true) eller deaktivert(false).                            |
|                                                                   |
|Når 'on' er true kjøres readInput() og setOutput() i løkke til     |
|anlegget deaktiveres via terminal.                                 |
|                                                                   |
|reset() kan kjøres via bryter hvis anlegget er deaktivert.         |
|                                                                   |
/------------------------------------------------------------------*/
void inputOutput(void)
{
    while(1) {
        if( on ) {
            wait_ms(50);
            readInput();
            setOutput();
        } else {
            if( resetSwitch ) { reset(); }
        }
    }
}


/*---------------------------reset()--------------------------------/
|                                                                   |
|Funksjon for reset av anlegget.                                    |
|Kalles fra terminal via terminalCommand() eller fysisk via         |
|reset-bryter hvis anlegget er deaktivert.                          |
|                                                                   |
|Alarm- og feilvariabler isAlarm og isFeil settes til 0-ingen feil  |
|Alle utganger settes til hviletilstand.(Merk at status på innganger|
|ikke overstyres. Hvis det ligger aktive alarmer i anlegget vil     |
|anlegget umiddelbart gå i alarm igjen etter reset.)                |
|                                                                   |
|Deretter skrives en reset-logg.                                    |
|                                                                   |
/------------------------------------------------------------------*/
void reset(void)
{
    int i;
    mutexAF.lock();
    isAlarm = 0;
    isFeil = 0;
    mutexAF.unlock();
    
    for( i = 0; i < 8; i++ ) {
        output[i] = 0;
        state[i] = 0;
    }
    indikatorLed = on;
    feilLed = 0;
    mutexLogg.lock();
    logg( 8, RESET );
    mutexLogg.unlock();
}

/*-------------------------readInput()------------------------------/
|                                                                   |
|Funksjon som leser tilstander på de fire analoge inngangene p17-p20|
|Disse float-verdiene brukes til å oppdatere en global tabell,      |
|'zone[]' med status på alle de 8 alarmkontaktene i anlegget.       |
|                                                                   |
|funksjonen er delt inn i en if-else-if-struktur for å dele opp     |
|den avleste verdien på inngangen i intervaller og skrive en        |
|heltallsverdi                                                      |
|fra 0-3 til de 8 plassene i 'zone[]'.                              |
|Funksjonen gjør med dette om 4 analoge innganger med float-verdier |
|om til 8 forskjellige soner, hver med 4 forskjellige tilstander.   |
|                                                                   |
/------------------------------------------------------------------*/
void readInput()
{
    /*--------------------------------------/
    |    floatverdier på analog inngang     |
    |    0-3(p17-p20) tilsvarer:            |
    |                                       |
    |    0.0 - 0.1   brudd                            |
    |    0.1 - 0.44  feil                    |
    |    0.45 - 0.55 pxa+pxb i hvile        |
    |    0.56 - 0.7  alarm pxa               |
    |    0.71 - 0.85 alarm pxb              |
    |    0.86 - 1    alarm pxa+pxb             |
    |                                       |
    /--------------------------------------*/

    float input[4];
    input[0] = ain0;
    input[1] = ain1;
    input[2] = ain2;
    input[3] = ain3;

    int n = 0;
    for( int i = 0; i < 4 ; i++, n += 2 ) {

        if( 0.55 < input[i] && input[i] < 0.85 ) { //a eller b i alarm
            zone[n] = ( 0.55 <= input[i] && input[i] < 0.7 ); //a i alarm
            zone[n+1] = ( 0.7 <= input[i] && input[i] < 0.85 ); //b i alarm

        } else if( input[i] > 0.85 ) { //a+b i alarm
            zone[n] = 1;
            zone[n+1] = 1;

        } else if(0.45 < input[i] && input[i] < 0.55) { //begge i hvile
            zone[n] = 0;
            zone[n+1] = 0;

        } else { //feil eller brudd/sabotasje
            zone[n] = ( input[i] >= 0.1 ) + 2;
            zone[n+1] = ( input[i] >= 0.1 ) + 2;
        }
    }
}


/*-------------------------setOutput()------------------------------/
|                                                                   |
|setOutput() henter status på de 8 sonene i den golabe tabellen     |
|'zone[]' og sjekker disse for å utføre de riktige                  |
utgangs-operasjonene avhengig av status på sonene.                  |
|de forskjellige sonene i 'zone[]' sjekkes først mot en minne-tabell|
|'zoneBuffer[]' for å sikre at det har vært en endring i tilstand   |
|(hvile-alarm, alarm-feil etc.).                                    |
|                                                                   |
|Deretter oppdateres feil- eller alarmindikatorer som korresponderer|
|til den aktuelle inngangen.                                        |
|Alle tilstandsendringer logges.                                    |
|                                                                   |                                                                   |
/------------------------------------------------------------------*/
void setOutput()
{
    int zoneBuffer[8];

    for( int i = 0; i < 8; i++ ) {
        if(zone[i] != zoneBuffer[i]) {
            mutexLogg.lock();
            switch(zone[i]) {

                case HVILE:
                    break;

                case ALARM:
                    isAlarm = 1;
                    output[i] = ALARM;
                    state[i] = 1;
                    logg( i, ALARM );
                    break;

                case BRUDD:
                    isFeil = 1;
                    state[i] = 2;
                    logg( i, BRUDD );
                    break;

                case FEIL:
                    isFeil = 1;
                    state[i] = 3;
                    logg( i, FEIL );
                    break;
            }
            
            mutexLogg.unlock();
            
            zoneBuffer[i] = zone[i];
        }
    }
}




/*-----------------------passwordFunc()-----------------------------/
|                                                                   |
|Passord-funksjon.                                                  |
|Kalles fra passord-avhengige kommandoer i terminalCommand().       |
|Tar imot en tekstreng fra terminalen 'tempPassword[]' og           |
|sammenligner denne med en eksisterende streng der gyldig passord er|
|lagret 'password[]'.                                               |
|                                                                   |
|Funksjonen returnerer 1 ved gyldig passord og 0 ved ugyldig passord|
|                                                                   |
|Ingen globale variabler                                            |
/------------------------------------------------------------------*/
int passwordFunc(void)
{
    int i = 0;
    while(!i) {
        char password[16] = { "pass" };
        char tempPassword[16];
        int correctPassword;

        pc.printf( "\nTast inn passord:" );
        pc.scanf( "%s", &tempPassword );

        correctPassword = strcmp(password, tempPassword);

        if (!correctPassword) {
            i = 1;

        } else {
            pc.printf("\n Wrong password \n");
        }
    }

    return i;

}

/*---------------------terminalCommand()----------------------------/
|                                                                   |
|Funksjon for brukergrensesnitt via terminal(teraterm o.l)
|Funksjonen henter en inntastet char-verdi fra terminal (charInput)
|og tester denne i en switch-test.
|
|
|
/------------------------------------------------------------------*/
void terminalCommand()
{
    char charInput = pc.getc();

    pc.printf("\n");
    
    mutexLogg.lock();
    switch (charInput) {
        case '1':  //start
            on = passwordFunc();
            logg(8,6);
            indikatorLed = on;
            break;

        case '2':   //stopp
            on = !passwordFunc();
            logg(8,5);
            indikatorLed = on;
            break;

        case '3':   //reset

            if(passwordFunc()) {
                reset();
                logg(8,7);
            }
            break;

        case '4':  // print status
            if(passwordFunc()) {
                logg(8,8);
                printStatus();
            }
            break;

        case ' '://vis meny
            showMenu(MAIN);
            break;

    }
    
    mutexLogg.unlock();
    
}



void logg( int i, int x )// i: navn, x: melding
{
    char *loggString, *zoneString;
    char *loggMessage[] = {
        "NULL",                         /*0*/
        "Alarm triggered. point: ",     /*1*/
        "Line tamper. Line: ",          /*2*/
        "Line fault. Line: ",           /*3*/
        "Alarm reset: ",                /*4*/
        "Turned Off from computer",     /*5*/
        "Turned on from computer",       /*6*/
        "Reset from computer",          /*7*/
        "Status checked from computer"  /*8*/
    };

    FILE *fp;

    fp = fopen( "/local/logg.txt", "a" );

    if( fp == NULL ) {
        pc.printf( "Unable to create file: logg.txt\n" ) ;
    }

    loggString = loggMessage[x];
    mutexZone.lock();
    zoneString = zoneName[i];
    mutexZone.unlock();
    time_t seconds = time(NULL);

fprintf( fp, "%d)\n %s \n - %s - %s\n\n", loggSize, ctime(&seconds),loggString, zoneString );
    
loggSize++;

    fclose(fp);
}


/*-----------------------printStatus()------------------------------/
|                                                                   |
|Funksjon som skriver ut status på soner til terminal.              |
|Kalles fra brukergrensesnitt på terminal i terminalCommand().      |
|Den henter opp menystruktur fra showMenu() og skriver ut           |
|status avhengig av valgt input. 1-8 gir tilsvarende sone.          |
|9 gir status på alle soner fra 1-8                                 |
|                                                                   |
/------------------------------------------------------------------*/
void printStatus()
{
    char *status[8] = {"hvile", "alarm", "feil", "brudd"};
    int valg;

    showMenu(STATUS);

    pc.scanf("%d",&valg);
    
    mutexZone.lock();
    
    if (valg > 0 && valg < 9) {
        pc.printf("Sone %d - detektor: %s: %s\n", valg, zoneName[valg-1], status[int(state[valg-1])]);
    } else if(valg == 9) {
        pc.printf("Status for system:\n");

        for(int i = 0; i < 8; i++) {
            pc.printf("Sone %d - detektor: %s: %s\n", (i+1), zoneName[i], status[int(state[i])]);
        }
        
    } else {
        pc.printf("Feil valg. Prov igjen\n");
    }
    
    mutexZone.unlock();
    
}

void showMenu(int menuOption)
{
    switch(menuOption) {
        case 1://mainMenu
            pc.printf("1) Start\n");
            pc.printf("2) Stopp\n");
            pc.printf("3) Reset\n");
            pc.printf("4) Skriv status\n");
            pc.printf("Velg 0-4 =>");
            break;

        case 2://statusMenu
        mutexZone.lock();
            for(int i = 0; i < 8; i++) {
                pc.printf("%d) %s\n",(i+1), zoneName[i]);
            }
        mutexZone.unlock(); 
            pc.printf("9) System status\n");
            pc.printf("Velg 1-9 =>\n");
            break;

    }
}

void setTime()
{

    pc.printf("\nEnter current date and time:\n");

    pc.printf("YYYY DD MM HH MM SS[enter]\n");

    pc.scanf("%d %d %d %d %d %d", &t.tm_year, &t.tm_mday, &t.tm_mon
             , &t.tm_hour, &t.tm_min, &t.tm_sec);

    t.tm_year = t.tm_year - 1900;
    t.tm_mon = t.tm_mon - 1;

    set_time( mktime(&t) );
}


void blink(void)
{
    while(1) {
        mutexAF.lock();
        if( isAlarm == 1 ) indikatorLed = !indikatorLed;
        if( isFeil == 1 ) feilLed = !feilLed;
        mutexAF.unlock();
        wait(0.05);
    }
}
