#include "mbed.h"

#include <fstream>
#include <iostream>
#include <sstream>
#include <string>
#include <stdio.h>

#define On 0
#define Off 1

Serial pc(USBTX, USBRX); // tx, rx
Serial gps(PTE0, PTE1); // tx, rx

DigitalOut led(LED_RED);

char data[] = "$GPGGA,111636.932,2447.0949,N,12100.5223,E,1,11,0.8,118.2,M,,,,0000*02<CR><LF>";

char NMEA[10];
char UTC_time[10];
char Lat[10];
char NS[10];
char Long[10];
char ES[10];

int main()
{
    //sscanf(data,"%[^','],%[^','],%[^','],%[^','],%[^',']",NMEA, UTC_time, Lat, NS, Long);
    //pc.printf("%s\n%s\n%s\n%s\n%s\n", NMEA, UTC_time, Lat, NS, Long);
    
    while(true)
    {
        
        if(gps.readable())
        {
            led = On;
            //pc.putc(gps.getc());  //RAW Data
            char test[500]; 
            gps.gets(test, 500);
            sscanf(test,"%[^','],%[^','],%[^','],%[^','],%[^','],%[^',']",NMEA, UTC_time, Lat, NS, Long, ES);
            //pc.printf("-----TEST DATA------- \n");
            pc.puts(NMEA);
            pc.printf("\n");
            //wait_ms(1000);
        }
        led = Off;
    }
}

//FOR TROUBLESHOOTING: WILL OUTPUT RAW DATA
/*
int main(){
  while(true)
  {
    if (gps.readable())
      {
          led = On;
          pc.putc(gps.getc());
          
        }
    led=Off;
    }
}*/