#include "mbed.h"
#include "rtos.h"
#include "tHIH6130.h"

#define SIG_RX_CAN  0x01

#define I2C_SDA p28
#define I2C_SCL p27

#define ADR_HIH     0x27            // adresse I2C réelle (sur 7 bits)

I2C i2c(I2C_SDA , I2C_SCL );

DigitalOut led1(LED1);
DigitalOut led2(LED2);

Thread threadA;
Thread threadB;
 
 
CAN CanPort(p30, p29);
CANMessage  MessageRx; 
CANMessage  MessageTx;
tHIH6130 Capteur(ADR_HIH,&i2c);
int flag=0;


unsigned int    Id;

float mesureTemp(tHIH6130 Capteur)
{
    Capteur.StartMesure();
    wait_ms(50);
    Capteur.UpdateData();
    float temp=Capteur.getTemp()/0.04;
    return temp;
}

float mesureHumi(tHIH6130 Capteur)
{
    Capteur.StartMesure();
    wait_ms(50);
    Capteur.UpdateData();
    float humi=Capteur.getHumi()/0.025;
    return humi;
}
 
void canReader(void)
{
    
      
    if (CanPort.read(MessageRx))
    {
            led1 = !led1;
            threadA.signal_set(SIG_RX_CAN);
    }
    
} 
 

void thA() 
{
    while(true)
    {
        Thread::signal_wait(SIG_RX_CAN);    
        led2 = !led2;
        printf("RX FRAME ID = %X\n",MessageRx.id);
        
    }
}
 
void thB() 
{
    while (true) 
    {
    led1 = !led1;   
    printf("Envoi Temperature et Humidite \n");
    MessageTx.id=Id;
    CanPort.write(MessageTx);
    wait(3);   
    }
}



int main() 
{
    int temp=111;
    int humi=111;
    CanPort.frequency(20000);
    
    MessageTx.len=2;
    
    MessageTx.format = CANStandard;
    //MessageTx.format = CANExtended;
    
    MessageTx.type = CANData;
    //MessageTx.type = CANRemote;
    
    CanPort.attach(canReader,CAN::RxIrq);
        
    threadA.start(thA);
    threadB.start(thB);
    
    led1 = 0;
    printf("Start OK\n");
    
    while (true) 
        {
            if(flag==0)
            {
                temp=mesureTemp(Capteur);
                Id = 0x032;
                MessageTx.data[0]=temp/256;
                MessageTx.data[1]=temp%256;
            }
            else
            {
                humi=mesureHumi(Capteur);
                Id = 0x031;
                MessageTx.data[0]=humi/256;
                MessageTx.data[1]=humi%256;
            }
            flag=!flag;
        }
}
