// Application to:
//1. Click Button to measure and display temperature.
//2. Click again to stop measure 
//3. Repeat





#include "mbed.h"
#include "USBSerial.h"
#include "OT07_lib.h"
#include <ctype.h>                  // to test and map characters: https://www.tutorialspoint.com/c_standard_library/ctype_h.htm

#define PERIOD      10              // Logging period in seconds
#define CONVERT_T_DELAY 30 


#define BS          8       // ASCII Back Space
#define CR          13      // ASCII Carriage Return



//const char* settings_file = "/sd/settings.txt";
//const char* log_file = "/sd/MAX30208Log.csv";

//global variable

//******************** init Feather Boared Hardware ***********************

//MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);  

//microSD logging file system setup
//SDFileSystem sd(P0_5, P0_6, P0_4, P0_7, "sd");  // mosi, miso, sclk, cs

//SD card insertion detection pin
//DigitalIn SDDetect(P2_2, PullUp);           // 
//InterruptIn SDInsert(P2_2);                 // Need DigitalIn before InterruptIn: https://os.mbed.com/docs/mbed-os/v6.2/apis/interruptin.html 


// Virtual serial port over USB
USBSerial pc(0x0B6A, 0x0042, 0x0001, false);

// I2C setup
I2C i2c(P1_6,P1_7);             // P1_6 -> I2C_SDA,  P1_7-> I2C_SCL

//Timer setup
Ticker timer_1;                 // timer for blinking the blue LED: LED3

//bool tick_flag;                 // used for counting seconds
//bool log_flag = false;
bool led_toggle_flag = false;
bool button_flag = false;       // used for measure and display temperature, and stop doing it.
//bool sd_insert_flag = false;
//bool error_flag;
//int error_ticks;

//LED  blink setup
DigitalOut rLED(P2_4);      // LED1 = P2_4
DigitalOut gLED(P2_5);      // LED2 = P2_5
DigitalOut bLED(P2_6);      // LED3 = P2_6



//InterruptIn button(SW1);              // button on the FTHR board
InterruptIn button(P2_7);              // button on the PICO board

void LED_blink_callback(){ // LED Heart beat
    
    
    bLED = !bLED;                // toggle the LED3
    
//    led_toggle_flag = !led_toggle_flag;
//    
//    if(log_flag) //if logging
//    {
//        
//        if(led_toggle_flag)
//        {
//        //toggle red led
//        rLED = LED_ON;
//        }
//        else
//        {
//            rLED = LED_OFF;
//            gLED = LED_OFF;
//            bLED = LED_OFF;
//        } 
//    }
//    else if(error_flag) //if error (no sd card)
//    {
//        if(led_toggle_flag)
//        {
//        //toggle red led
//        rLED = LED_ON;
//        gLED = LED_ON;
//        }
//        else
//        {
//            rLED = LED_OFF;
//            gLED = LED_OFF;
//            bLED = LED_OFF;
//        }
//        error_ticks--; 
//        if(error_ticks <= 0)
//            error_flag = false;
//    }
//    else
//    {
//        if(led_toggle_flag)
//        {
//        //toggle teal leds
//        gLED = LED_ON;
//        bLED = LED_ON;
//        }
//        else
//        {
//            rLED = LED_OFF;
//            gLED = LED_OFF;
//            bLED = LED_OFF;
//        } 
//    }
//      
//    tick_flag = true;
} // end of void LED_blink_callback()

void btn_pressed() //button pressed isr
{
    button_flag = true;
    gLED = !gLED;
}

//void sd_insert() //sd_insert pressed isr
//{
//    sd_insert_flag = true;
//}


// *****************************************************************************
//            Define CRC-8 Table
// *****************************************************************************

static unsigned char crc_table[] = {
    0, 94,188,226, 97, 63,221,131,194,156,126, 32,163,253, 31, 65,
    157,195, 33,127,252,162, 64, 30, 95, 1,227,189, 62, 96,130,220,
    35,125,159,193, 66, 28,254,160,225,191, 93, 3,128,222, 60, 98,
    190,224, 2, 92,223,129, 99, 61,124, 34,192,158, 29, 67,161,255,
    70, 24,250,164, 39,121,155,197,132,218, 56,102,229,187, 89, 7,
    219,133,103, 57,186,228, 6, 88, 25, 71,165,251,120, 38,196,154,
    101, 59,217,135, 4, 90,184,230,167,249, 27, 69,198,152,122, 36,
    248,166, 68, 26,153,199, 37,123, 58,100,134,216, 91, 5,231,185,
    140,210, 48,110,237,179, 81, 15, 78, 16,242,172, 47,113,147,205,
    17, 79,173,243,112, 46,204,146,211,141,111, 49,178,236, 14, 80,
    175,241, 19, 77,206,144,114, 44,109, 51,209,143, 12, 82,176,238,
    50,108,142,208, 83, 13,239,177,240,174, 76, 18,145,207, 45,115,
    202,148,118, 40,171,245, 23, 73, 8, 86,180,234,105, 55,213,139,
    87, 9,235,181, 54,104,138,212,149,203, 41,119,244,170, 72, 22,
    233,183, 85, 11,136,214, 52,106, 43,117,151,201, 74, 20,246,168,
    116, 42,200,150, 21, 75,169,247,182,232, 10, 84,215,137,107, 53};
    
    
    
// -----------------------------------------------------------------------------
// Calculate the CRC8 of the byte value provided with the current total
// calc_crc8(unsigned char, unsigned char)  crc8 total, byte to add
// pass crc8 total = 0 to start new crc sum.

// Returns  new crc8 total
// -----------------------------------------------------------------------------

unsigned char calc_crc8(unsigned char crc8, unsigned char value){
        
    return crc_table[crc8 ^ value];
}


//******************************************************************************
//        main()
//******************************************************************************


int main()
{
    rLED = LED_OFF;
    gLED = LED_OFF;
    bLED = LED_OFF;
    
       
    // Application to:
    //1. Click Button to measure and display temperature.
    //2. Click again to stop measure 
    //3. Repeat
    
    
    pc.printf("Welcome tot the OT07 Test Program!\r\n");
    pc.printf("Press the button to start measurement.\r\n");
    pc.printf("Press one more time to stop.\r\n");
    
    //************* init ticker timer callbacks  ****************
    timer_1.attach(&LED_blink_callback, 2);        //LED3 toggles every 3 seconds
    
    //************* init button interrupts  ****************
    button.fall(&btn_pressed); 
    
    char data[5];             
    char i2c_add = 0xA0;
    TempResponse T;
    
    
    while (1) {
        
//        pc.printf("In loop.\r\n");
        
        
        if (button_flag) {
            pc.printf("The button is pressed.\r\n");        
            button_flag = false;
            
            // Read OT07 register            
            int result = OT07_read_register(&i2c, i2c_add,0xff,data,1);  
            if(result) {
                pc.printf("Read fail.\r\n");     
            } else {
                pc.printf("Success!\r\n"); 
                pc.printf("OT07 add[%02X] data[%02X]\r\n",0xff,data[0]);        // should be 0x30        
            } // end of if(result)    
            
            for (int i = 0; i < 3; i++) {
                convert_temperature(&i2c, i2c_add);  //send OW convert selected device
                wait_ms(CONVERT_T_DELAY);  //wait 20 ms for convert temperature to complete 
                T = get_temperature(&i2c, i2c_add);
                pc.printf("OT07  temperature[%.3f]  status[%d]\r\n", T.tempC, T.status);
            }
            
        } // end of if (button_flag) 
    
    }       // end of while (1)
    
} // end of main()
    
    
//int main()    
//{
//    OT07_struct OT07[4];            // structure that holds I2C address and ROM_ID  
//    char data[130];
//    int device_count = 0;       // number of OW devices found by search_rom() 
//    int i;
//    int j;
//    int k;
//    
//    
//    char device_id[ID_LENGTH];                   //8 byte rom id of current slected device 
//    char rom_id_list[MAX_DEVICES][ID_LENGTH];    //List of rom id for each device on OW bus 
//    
//    TempResponse T[MAX_DEVICES];  
//    
//    bool device_logged[MAX_DEVICES];
//    //initialize device_logged to all false;
//    for(int i = 0; i < MAX_DEVICES; i++)
//    {
//        device_logged[i] = false;
//    }
//    
//    // i/o variables
//    char rx_buff[128];              // comport input buffer
//    int rx_index;                   // rx_buffer pointer
//    char c;                         // command type character
//    int n;                          // argument count
//    int arg1;                       // argumnet 1
//    int arg2;                       // argument 2
//    int device;                     // device argument
//    int num_bytes;
//    
//    int time_count;
//    int log_interval = PERIOD;
//    int time_to_sample; 
//    
//    apply_settings_file(device_logged, log_interval);
//    
//    //************* init ticker timer callbacks  ****************
//    timer_1.attach(&LED_blink_callback,0.5);        //start ticker, once per  sec.      
//    
//    
//    i2c.frequency(400000);      //set I2C clock to 400kHz     
//    
//    rLED = LED_OFF;
//    gLED = LED_ON;
//    bLED = LED_ON;
//    
//    // ******************  search for all devices on bus  *****************
//
//    device_count = search_I2C_bus(OT07);
//    
//    rx_index = 0;               //character buffer index for input from PC
//    
//    button.fall(&btn_pressed);
//    SDInsert.fall(&sd_insert);
//    
//    sd.disk_initialize(); //initialize sd card
//     
//    while(1) {  // start main loop,  take data if logging, check for input, repeat   
//    
//    if(sd_insert_flag == true)
//    {
//        sd.disk_initialize();
//        sd_insert_flag = false;
//    }
//    
//    if(button_flag == true)
//    {
//        if(log_flag == false){  //start logging        
//        
//            if(SDDetect)//if SD card not detected
//            {
//                error_flag = true;
//                error_ticks = 6;
//                log_flag = false;
//            }
//            else
//            {
//                apply_settings_file(device_logged, log_interval);
//                
//                FILE *fp = fopen(log_file, "a");
//                if (fp != NULL) 
//                {
//                    fprintf(fp,"Device List\r\n");
//                    fprintf(fp,"Device Number,Address,Unique ID\r\n");
//                    for(j=0;j<device_count;j++)
//                    {
//                        if(device_logged[j])
//                        {
//                            fprintf(fp,"%d,0x%02X,0x",j, OT07[j].I2C_address);
//                            for(i=ID_LENGTH-1;i>=0;i--)
//                            {            
//                                fprintf(fp,"%02X",OT07[j].rom_id[i]); 
//                            }    
//                            fprintf(fp,"\r\n");
//                        }
//                    } 
//                    fprintf(fp, "Temperature Log\r\n");
//                    fprintf(fp, "Time (s)");
//                
//                    for(j=0;j<device_count;j++)
//                    {
//                        if(device_logged[j])
//                            fprintf(fp,",Device %d Temperature (C)",j);
//                    }
//                    fprintf(fp,"\r\n");
//                
//                    fclose(fp);  
//                }
//                
//                time_count = 0;
//                
//                time_to_sample = 0;                     // force sample at time = 0;
//                tick_flag = true;                       // force sample at time = 0;
//                log_flag = true;
//            }
//        }else{
//            log_flag = false;
//        }  
//        button_flag = false;  
//    }
//
//      while(tick_flag == false){ //check for input while waiting for next tick      
//      
// // ----------------------------------------------------------------------------
// //             test for charater input for USB com port
// // ----------------------------------------------------------------------------
//        
// //test if PC sent some charaters
//        while(pc.readable()){  //characters in buffer,  get them                               
//            rx_buff[rx_index] = pc.getc();
//            
//            if(rx_buff[rx_index] == CR){
//                rx_buff[++rx_index] = 0;
//                rx_index = -1;  // because i++ at end of while give i=0 on next loop 
//                device = 0; 
//                arg1 = 0;
//                arg2 = 0;
//                
//                n = sscanf(rx_buff, " %c %d %x %x", &c, & device, &arg1, &arg2);
//               //process input
//                if(n > 0){//got input so process it
//                    switch(c){
//                        case 'a':   
//                        case 'A':   
//                            break;
//                        case 'c':
//                        case 'C':
//                                    if(!SDDetect)
//                                        pc.printf("y\r\n");
//                                    else
//                                        pc.printf("n\r\n");
//                                    break;
//                        case 'd':
//                        case 'D':
//                                    if(n==1) // if no device number is given
//                                    {
//                                        //clear device_logged array
//                                        for(int i = 0; i < MAX_DEVICES; i++)
//                                        {
//                                            device_logged[i] = false;
//                                        }
//                                        
//                                        write_settings_file(log_interval, device_logged);
//                                    }
//                                    if(n == 2)
//                                    {
//                                        device_logged[device] = true;
//                                        write_settings_file(log_interval, device_logged);
//                                    }
//                            break;
//                        case 'f':   
//                        case 'F':   //f is for "flash" for microSD
//                                     if(!SDDetect)
//                                        pc.printf("y\r\n");
//                                    else
//                                        pc.printf("n\r\n");
//                            break;
//                        case 'g':   
//                        case 'G':   
//                                    if(n == 2)
//                                    {
//                                        //0 means get config, 1 means get log, 2 means clear log
//                                        bool fileExists = false;
//                                        if(device == 0)//get config
//                                        {
//                                            fileExists = print_settings_file();
//                                        }
//                                        if(device == 1)//get log
//                                        {
//                                            fileExists = print_log_file();
//                                        }
//                                        if(device == 2)//get log
//                                        {
//                                            clear_log_file();
//                                            fileExists = true;
//                                        }
//                                        if(!fileExists)
//                                        {
//                                            pc.printf("no_file\r\n");
//                                        }
//                                    }
//                                    // read all registers command 
//                                    //i.e. ("g 0 0" means readAll from device 0 "g 1 0" means readAll from device 1)
//                                    if(n == 3)
//                                    {
//                                        //device holds device number 0 means readAll command
//                                        OT07_read_register(OT07[device].I2C_address,0x00,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x00,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x01,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x01,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x04,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x04,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x05,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x05,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x06,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x06,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x07,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x07,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x08,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x08,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x09,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x09,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x0A,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x0A,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x0C,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x0C,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x10,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x10,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x11,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x11,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x12,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x12,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x13,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x13,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x14,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x14,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x20,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x20,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x21,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x21,data[0]);
//                                        //OT07_read_register(OT07[device].I2C_address,0x30,data,1); 
//                                        //pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x30,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x31,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x31,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x32,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x32,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x33,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x33,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x34,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x34,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x35,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x35,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0x36,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x36,data[0]);
//                                        //OT07_read_register(OT07[device].I2C_address,0x37,data,1); 
//                                        //pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0x37,data[0]);
//                                        OT07_read_register(OT07[device].I2C_address,0xFF,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,0xFF,data[0]);
//                                    }
//                            break;
//                        case 'i':
//                        case 'I':   //Set Logging sample intreval in seconds
//                        
//                                    log_interval = device;
//                                    if(log_interval < 1)log_interval = 1; 
//                                    if(log_interval > 60)log_interval = 60;  
//                                    write_settings_file(log_interval, device_logged);                               
//                                break;
//                        case 'l':   
//                        case 'L':     
//                        /*
//                                    // Toggle logging
//                        
//                                    if(log_flag == false){  //start logging   
//                                        if(SDDetect)//if SD card not detected
//                                        {
//                                            error_flag = true;
//                                            error_ticks = 6;
//                                            log_flag = false;
//                                        }
//                                        else
//                                        {
//                                            FILE *fp = fopen(log_file, "a");
//                                            if (fp != NULL) 
//                                            {
//                                                fprintf(fp, "Time(s)");
//                                            
//                                                for(j=0;j<device_count;j++)
//                                                {
//                                                    fprintf(fp,",Device %d Temperature (C)",j);
//                                                }
//                                                fprintf(fp,"\r\n");
//                                            
//                                                fclose(fp);  
//                                            }
//                                            
//                                            time_count = 0;
//                                            
//                                            time_to_sample = 0;                     // force sample at time = 0;
//                                            tick_flag = true;                       // force sample at time = 0;
//                                            log_flag = true;
//                                        }
//                                    }else{
//                                        //pc.printf("<stop logging>\r\n");
//                                        log_flag = false;
//                                    }*/
//                            break;
//                        case 'r':
//                        case 'R':   
//                                    //read register "r device radd.start radd.end"                                      
//                                    if(n==3){   //read single register from selected device
//                                        OT07_read_register(OT07[device].I2C_address,arg1,data,1); 
//                                        pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,arg1,data[0]);
//                                    }
//                                    if(n==4){   //read a range of regesters from selected device 
//                                        num_bytes = arg2-arg1 + 1;                  // calculate number of bytes to read
//                                        if (num_bytes < 1) num_bytes = 1;           // if arg2 <= arg 1 just read arg1 address.                                      
//                                            OT07_read_register(OT07[device].I2C_address,arg1,data,num_bytes); 
//                                        for(i=0;i<num_bytes;i++){
//                                            pc.printf("device[%02X] add[%02X] data[%02X]\r\n",device,arg1+i,data[i]);
//                                        }                                  
//                                    } 
//                                break;
//                       
//                        case 's':   
//                        case 'S':   
//                                    // ******************  search for I2C devices on bus  *****************
//                                    device_count = search_I2C_bus(OT07);
//                                    pc.printf("%d devices:\r\n", device_count);
//                                    for(j=0;j<device_count;j++){
//                                        pc.printf("device[%02X] addr[%02X] unique id[",j, OT07[j].I2C_address);
//                                        for(i=ID_LENGTH-1;i>=0;i--){            
//                                            pc.printf("%02X",OT07[j].rom_id[i]); 
//                                        }    
//                                        pc.printf("]\r\n");
//                                    }
//                                    
//                            break;
//                        
//                        case 'T':
//                        case 't':            
//                                
//                                if(n == 2){//get temperatures from selected device                                                            
//                                        
//                                    convert_temperature(OT07[device].I2C_address);  //send OW convert selected device
//                                    wait_ms(CONVERT_T_DELAY);  //wait 20 ms for convert temperature to complete 
//                                    T[device] = get_temperature(OT07[device].I2C_address);
//                                    pc.printf("device[%02X]  temperature[%.3f]  status[%d]\r\n",device,T[device].tempC, T[device].status);
//                                }
//                                
//                                if(n == 3){ // "t 1 3"  get temperature for devices 1 thru 3
//                                    //sprintf(str,"%x",arg1);     //convert arg1 input as hex to decimal  i.e. 0x10 becomes 10 dec
//                                    //sscanf(str,"%d",&arg1);
//                                   //IS THIS NEEDED? ^^^
//                                   
//                                    for(j=device;j<=arg1;j++){                                        
//                                        convert_temperature(OT07[j].I2C_address);  //send convert to all devices
//                                        wait_ms(CONVERT_T_DELAY);  //wait 20ms for convert temperature to complete
//                                        T[j] = get_temperature(OT07[j].I2C_address);
//                                    }
//                                    
//                                    for(j=device;j<=arg1;j++){                    
//                                        pc.printf("device[%02X]  temperature[%.3f]  status[%d]\r\n",j,T[j].tempC, T[j].status);
//                                    }  
//                                }
//                                
//                            break;
//                            
//                        case 'w':
//                        case 'W':   //write register "w device w.addr data"
//                                    
//                                    OT07_write_register(OT07[device].I2C_address,arg1, arg2); 
//                                    pc.printf("write -- device[%02X] add[%02X] data[%02X]\r\n",device,arg1,arg2);
//                                break;
//                        
//                        case 'x':   
//                        case 'X':   // experimental modes
//                            break;
//                            
//                                               
//                    }//end switch(c)
//                }//if(n>0)             
//            }//end if(CR)           
//            if(rx_buff[rx_index] == BS){//backspace received, back up buffer pointer                                
//                 if(rx_index>0)rx_index--;//remove last char from buffer if not at start.                 
//            }else rx_index++;                                      
//        }//end while(pc.redable()) 
//        wait_ms(100);     // slow down polling  
//
//      }// end (while tick == false)
//      tick_flag = false;                // set to false for next time
//             
//      // only reached when tick_flag = true otherwise stuck in pc.readable() loop
//      if(log_flag == true){                       
//            if(time_count >= time_to_sample){ //take next sample
//                time_to_sample += log_interval;   // calculate time for next sample
//                
//                for(j=0;j<device_count;j++){            
//                    convert_temperature(OT07[j].I2C_address);
//                    wait_ms(CONVERT_T_DELAY);  //wait 20ms for convert temperature to complete 
//                    T[j] = get_temperature(OT07[j].I2C_address); 
//                }
//                /////////////////////////////////////////////////////////////////////////////////////////////////
//
//                //open file for microSD logging
//                FILE *fp = fopen(log_file, "a");
//                if (fp != NULL) 
//                {
//                    //fprintf(fp, "\n");
//                    fprintf(fp, "%d",time_count);
//                    for(j=0;j<device_count;j++)
//                    {
//                        if(device_logged[j])
//                        {
//                            if(T[j].status == DEVICE_ACK)
//                                fprintf(fp,",%.3f",T[j].tempC);
//                            else
//                                fprintf(fp,",---.---");
//                        }
//                        
//                    }
//                    fprintf(fp,"\r\n");
//                
//                    fclose(fp);  
//                }
//            }// end if(time_count >= time_to_sample)        
//            time_count ++;                    // 
//            
//      }// end if(log_flag)
//      
//    }//end while(1)
//}
