
#include "mbed.h"
#include "OT07_lib.h"

// *****************************************************************************
//   OT07_write_register(char, char, char)  writes single byte to OT07
//                       char   I2C address
//                       char   OT07 register address
//                       char   data byte to be writen
//   returns                    0 on success ACK, 1 on NACK 
// *****************************************************************************

int OT07_write_register(I2C *i2c, char I2C_add, char reg_add, char byte){
    char data[2];               // char type ranges from 0 to 255 (8 bytes)
    int error;
    data[0] = reg_add;
    data[1] = byte;
    error = i2c->write(I2C_add,data,2);  
    //if(DEBUG)db.printf("wr[%02X %02X %d]\r\n", data[0], data[1], error);
    return error; 
    
}

/// ****************************************************************************
//   OT07_write_register(char, char, char *, int)  writes multiple bytes to OT07
//                       char   I2C address
//                       char   OT07 register address
//                       char * data vector of bytes to be written
//                       int    number of bytes to write
//   returns                    0 on success ACK, 1 on NACK 
// *****************************************************************************

int OT07_write_register(I2C *i2c, char I2C_add, char reg_add, char *bytes, int n){
    int i;   
    //set start address
    char data[16];
    int error;                          
    data[0] = reg_add; 
    for(i=1;i<=n;i++){                   
       data[i] = bytes[i-1];
    }
    error = i2c->write(I2C_add,data,n+1);  // send n bytes of data
  
    return error;      
}

// *****************************************************************************
//   OT07_read_register(char, char, char *, int)  writes single byte to OT07
//                       char   I2C address
//                       char   OT07 register address
//                       char * data vector for read bytes to be stored in 
//                       int    number of bytes to read
//   returns                    0 on success, 1 on fail 
// *****************************************************************************

int OT07_read_register(I2C *i2c, char I2C_add, char reg_add, char *bytes, int n){
    int error;
    error = i2c->write(I2C_add,&reg_add,1,1); 
    if(error)return error;   
    error = i2c->read(I2C_add,bytes,n);  
    //if(DEBUG)db.printf("rr e[%d]\r\n",error);
    return error; 
}

// *****************************************************************************
//   search_I2C_bus(OT07_struct *)  searches I2C address 0xA0, 0xA2, 0xA4 and 0xA6        
//                  OT07_struct *   structure array to holds I2C address and rom_ids
//   returns                        number of devices found
// *****************************************************************************

int search_I2C_bus(I2C *i2c, OT07_struct OT07[]){
    char data[16];
    char I2C_add;
    //char GPIO;
    int error;
    int device_count = 0;
    int i;
    int j;
    for(i = 0;i<4;i++){
        I2C_add = 0xA0 + i*2;
        error = OT07_read_register(i2c, I2C_add,0xff,data,1); 
        
        if(error == 0){
            if(data[0] == 0x30){ 
            
                OT07[device_count].I2C_address = I2C_add;
                
                OT07_read_register(i2c, I2C_add,OT07_ROM_ID,data,ID_LENGTH);
                for(j=ID_LENGTH-1;j>=0;j--){
                    OT07[device_count].rom_id[j] = data[j];
                     
                }
            device_count++;    
            }                       
        }

    }
    return device_count;
}

// *****************************************************************************
// convert_temperature(char)    sends convert command to OT07 device
//                     char     I2C address
// *****************************************************************************

void convert_temperature(I2C *i2c, char I2C_add){   // set convert bit to start conversion

    char data[2];  
    
    //read ADC_SETUP register 0x14
    OT07_read_register(i2c, I2C_add, OT07_ADC_SETUP,data,1);       

    //mask convert register value with 0x01 and write back register 0x14      
    OT07_write_register(i2c, I2C_add, OT07_ADC_SETUP, data[0]|0x01);
}

//******************************************************************************
// get_temperature(char)    read temperature from OT07 device FIFO register
//                 char     I2C address
// returns                  TempResponse tempC = temperature in oC 
//                          status = register read result
//******************************************************************************

TempResponse get_temperature(I2C *i2c, char I2C_add){
    char data[2];
    double T;
    int count;
    
    // Read temperature from FIFO, 2 bytes 
    int error = OT07_read_register(i2c, I2C_add,OT07_FIFO_DATA,data,2);     
    
    //calculate temperture from data     
    count = (int)(data[0]*256 + data[1]);
    if (count >= 32768)count = count - 65536;     // 2s comp
    T = (double)count*0.005; 
    
    TempResponse resp;
    resp.tempC = T;
    resp.status = error; // 1 for nack/error. 0 for ack/success
    return resp;  
}

// other functions

//void write_settings_file(int interval, bool device_logged[MAX_DEVICES])
//{
//    FILE *fp = fopen(settings_file, "w");
//    if (fp != NULL) 
//    {
//        fprintf(fp, "i %d\r\n", interval);
//
//        fprintf(fp, "d");
//
//        for(int i = 0; i < MAX_DEVICES; i++)
//        {
//            if(device_logged[i] == true)
//            {
//                fprintf(fp," %d", i);
//            }
//        }
//        fprintf(fp,"\r\n");
//
//        fclose(fp);  
//    }
//    return;
//}

//void clear_log_file()
//{
//    FILE *fp = fopen(log_file, "w");
//    if (fp != NULL) 
//    {
//        fclose(fp);  
//    }
//    return;
//}

//bool print_settings_file()
//{
//    FILE *fp = fopen(settings_file, "r");
//    if (fp != NULL) 
//    {
//        pc.printf("*\r\n");
//        
//        // Read contents from file
//        char c = fgetc(fp);
//        
//        while (!feof(fp))
//        {
//            pc.printf("%c", c);
//            c = fgetc(fp);
//        }
//        
//        pc.printf("*\r\n");
//        
//        fclose(fp);  
//    }
//    else
//    {
//        return false;
//    }
//    return true;
//}

//bool print_log_file()
//{
//    FILE *fp = fopen(log_file, "r");
//    if (fp != NULL) 
//    {
//        pc.printf("*\r\n");
//
//        // Read contents from file
//        char c = fgetc(fp);
//        while (!feof(fp))
//        {
//            pc.printf("%c", c);
//            c = fgetc(fp);
//        }
//
//        pc.printf("*\r\n");
//
//        fclose(fp);  
//    }
//    else
//    {
//        return false;
//    }
//    return true;
//}

//int getline(char **lineptr, int *n, FILE *stream) {
//    char *bufptr = NULL;
//    char *p = bufptr;
//    size_t size;
//    int c;
//
//    if (lineptr == NULL) {
//        return -1;
//    }
//    if (stream == NULL) {
//        return -1;
//    }
//    if (n == NULL) {
//        return -1;
//    }
//    bufptr = *lineptr;
//    size = *n;
//
//    c = fgetc(stream);
//    if (c == EOF) {
//        return -1;
//    }
//    if (bufptr == NULL) {
//        bufptr = (char *)malloc(128);
//        if (bufptr == NULL) {
//            return -1;
//        }
//        size = 128;
//    }
//    p = bufptr;
//    while(c != EOF) {
//        if ((p - bufptr) > (size - 1)) {
//            size = size + 128;
//            bufptr = (char *)realloc(bufptr, size);
//            if (bufptr == NULL) {
//                return -1;
//            }
//        }
//        *p++ = c;
//        if (c == '\n') {
//            break;
//        }
//        c = fgetc(stream);
//    }
//
//    *p++ = '\0';
//    *lineptr = bufptr;
//    *n = size;
//
//    return p - bufptr - 1;
//}
//
//bool print_settings_file_2()
//{
//    char * line = NULL;
//    int len = 0;
//    
//    FILE *fp = fopen(settings_file, "r");
//    if (fp != NULL) 
//    {
//        pc.printf("*\r\n");
//        
//        // Read contents from file
//        while ((getline(&line, &len, fp)) != -1) 
//        {
//            pc.printf("%s", line);
//        }
//        pc.printf("*\r\n");
//        
//        fclose(fp);  
//    }
//    else
//    {
//        return false;
//    }
//    return true;
//}
//
////returns true if settings file exists and is in the proper format
//bool apply_settings_file(bool (&logged_devices)[MAX_DEVICES], int& interval)
//{
//    
//    char * line = NULL;
//    int len = 0;
//    int line_number = 0;
//    
//
//    FILE *fp = fopen("/sd/settings.txt", "r");
//    if (fp != NULL) 
//    {
//
//        //initialize devices to all false;
//        for(int i = 0; i < MAX_DEVICES; i++)
//        {
//            logged_devices[i] = false;
//        }
//
//        // Read contents from file
//        while ((getline(&line, &len, fp)) != -1) 
//        {
//            line_number++;
//
//            char i = 0;
//            char c = line[i];
//            while(c != '\0')
//            {
//                int number;
//                int n;
//                sscanf((line+i), "%d%n", &number, &n);
//                if(isdigit(c))
//                {
//                    if(line_number == 1)
//                    {
//                        interval = number;
//                    }
//                    else if(line_number == 2)
//                    {
//                        logged_devices[number] = true;
//                    }
//                    if(n > 1)
//                        i = i + (n - 1);
//                }
//                i++;
//                c = line[i];
//            }
//        }
//
//        fclose(fp);  
//    }
//    else
//    {
//        return false;
//    }
//
//    return true;
//    
//}