#include "mbed.h"

//MAX44009 Registers
#define MAX44009_INT_STATUS     0x00    // MAX44009 interrupt status regiter
#define MAX44009_INT_EN         0x01    // MAX44009 Interrupt Enable
#define MAX44009_CONFIG         0x02    // MAX44009 Configuration Register
#define MAX44009_LUX_HI         0x03    // MAX44009 Lux High Byte
#define MAX44009_LUX_LO         0x04    // MAX44009 Lux Low Byte
#define MAX44009_THR_HI         0x05    // MAX44009 Upper Threshold High Byte
#define MAX44009_THR_LO         0x06    // MAX44009 Lower Threshold High Byte
#define MAX44009_THR_TM         0x07    // MAX44009 Threshold Timer

#define DEVICE_ACK      0
#define DEVICE_NACK     1
#define DEVICE_BAD_RESP 2

#define MAX_DEVICES 64      // Maximum number of rom devices allowed
#define ID_LENGTH   6       // Rom ID length in bytes

struct MAX44009_struct {
    char rom_id[ID_LENGTH];     // device ROM ID
    char I2C_address;           // I2C addess, based on GPIO0 and GPIO1 at power up
                                // Why char?
}; 

struct LuxResponse {
    double luxValue;     // Light level in lux 
    int status;       // Status of Lux read. 0 for success, 1 for error
};

// *****************************************************************************
//   MAX44009_write_register(char, char, char)  writes single byte to MAX44009
//                       char   I2C address
//                       char   MAX44009 register address
//                       char   data byte to be writen
//   returns                    0 on success ACK, 1 on NACK 
// *****************************************************************************
int MAX44009_write_register(I2C *i2c, char I2C_add, char reg_add, char byte);

/// ****************************************************************************
//   MAX44009_write_register(char, char, char *, int)  writes multiple bytes to MAX44009
//                       char   I2C address
//                       char   MAX44009 register address
//                       char * data vector of bytes to be written
//                       int    number of bytes to write
//   returns                    0 on success ACK, 1 on NACK 
// *****************************************************************************
int MAX44009_write_register(I2C *i2c, char I2C_add, char reg_add, char *bytes, int n);

// *****************************************************************************
//   MAX44009_read_register(char, char, char *, int)  reads single byte from MAX44009
//                       char   I2C address
//                       char   MAX44009 register address
//                       char * data vector for read bytes to be stored in 
//   returns                    0 on success, 1 on fail 
// *****************************************************************************
int MAX44009_read_register(I2C *i2c, char I2C_add, char reg_add, char *bytes);

// *****************************************************************************
//   MAX44009_read_lux_register(char, char, char *, int)  reads lux value bytes from MAX44009
//                       char   I2C address
//                       char   MAX44009 register address
//                       char * data vector for read bytes to be stored in 
//   returns                    0 on success, 1 on fail 
// *****************************************************************************
int MAX44009_read_lux_register(I2C *i2c, char I2C_add, char reg_add, char *bytes);

// *****************************************************************************
// convert_temperature(char)    sends convert command to MAX44009 device
//                     char     I2C address
// *****************************************************************************
//void convert_temperature(I2C *i2c, char I2C_add);

//******************************************************************************
// get_luxvalue(char)       read lux value from MAX44009 device register
//                 char     I2C address
// returns                  LuxResponse luxValue = light intensity in lux 
//                          status = register read result
//******************************************************************************
LuxResponse get_luxvalue(I2C *i2c, char I2C_add);

double calc_lux(char *data);