#include "mbed.h"

// Low Power Mode
#include "lp.h"
#include "mxc_config.h"
#include "lp.h"
#include "rtc.h"
#define LP1_WakeTime    3 //seconds

/***************************************************************************
 * LEDs Instantiation
 **************************************************************************/
//DigitalOut gLED(LED2);          // green LED
//DigitalOut rLED(LED1);          // red LED
//DigitalOut bLED(LED3);          // blue LED


// *****************************************************************************
void RTC_Setup()
{
    rtc_cfg_t RTCconfig;

//    RTCconfig.compareCount[0] = 3;//3 second timer          
    RTCconfig.compareCount[1] = LP1_WakeTime;      //3 second timer
    RTCconfig.prescaler = RTC_PRESCALE_DIV_2_12; //1Hz clock
    RTCconfig.prescalerMask = RTC_PRESCALE_DIV_2_12;//used for prescaler compare
    RTCconfig.snoozeCount = 0;
    RTCconfig.snoozeMode = RTC_SNOOZE_DISABLE;

    RTC_Init(&RTCconfig);

    RTC_Start();
}

int main() {
 
    // Set all LEDs off
//    gLED = LED_OFF;
//    rLED = LED_OFF;
//    bLED = LED_OFF;
    
    //configure RTC and start
    RTC_Setup();

    while (1) {
        
        // Set all LEDs off
//        gLED = LED_OFF;
//        rLED = LED_OFF;
//        bLED = LED_OFF;
        
    
        /***************************************************************************
        * LP1 Experiment
        **************************************************************************/
        //Clear existing wake-up config
        LP_ClearWakeUpConfig();

        //Clear any event flags
        LP_ClearWakeUpFlags();

        //configure wake-up on RTC compare 1
        LP_ConfigRTCWakeUp(0, 1, 0, 0);


        //set RTC compare 1 value
        uint32_t cmp = RTC_GetCount() + LP1_WakeTime;
        RTC_SetCompare(1,cmp);
        RTC_ClearFlags(MXC_F_RTC_FLAGS_COMP1);

        //global disable interrupt
        __disable_irq();

        LP_EnterLP1();

        //global enable interrupt
        __enable_irq();
        
        // LP1 Wakes up
//        gLED = LED_ON;
        wait(1);

    } // end of while(1) loop
        
}  // end of main()