#ifndef PICOCOMMANDS_H
#define PICOCOMMANDS_H

/// <summary>
/// PICO USB HID supported commands (Report ID byte)
/// </summary>
enum UsbHidReportID
{
    GenericHID = 0x00
};

enum UsbHidOpCode
{
    GetEmbApp = 0x01,
    SetEmbApp = 0x02,

    I2CGet = 0x10,
    I2CSetCfg = 0x11,
    I2CWriteReg = 0x12,
    I2CReadReg = 0x13,
    I2CReadNoReg = 0x14,

    SpiGet = 0x20,
    SpiSet = 0x21,
    SpiWrite = 0x22,

    GpioGet = 0x30,
    GpioSetCfg = 0x31,
    GpioWrite = 0x32,
    GpioRead = 0x33,
    GpioIntFuncState = 0x34,
    GpioIntNotify = 0x35,

    PwmSetRaw = 0x40,
    PwmSetCfgRaw = 0x41,
};

/// <summary>
/// PICO USB HID General Get/Set opcodes
/// </summary>
enum UsbHidGetSet
{
    VerNum = 0x00,
    VerStr = 0x01,
    BoardID = 0x02,
    ProdIDStr = 0x03,
};

/// <summary>
/// PICO USB HID SPI Get/Set opcodes
/// </summary>
enum UsbHidSpi
{
    SetCfg = 0x00,
    GetCfg = 0x00,

    GetBusSpeedAll = 0x01,
    GetBusSpeedCur = 0x02,
    SetChipSelect = 0x03,
};

/// <summary>
/// PICO Supported Ports
/// </summary>
enum GpioPortID
{
    GpioA = 0,
    GpioB = 1,
    GpioC = 2,
};

/// <summary>
/// PICO Supported Pin IDs
/// </summary>
enum GpioPinID
{
    PinID0 = 0,
    PinID1 = 1,
    PinID2 = 2,
    PinID3 = 3,
    PinID4 = 4,
    PinID5 = 5,
    PinID6 = 6,
    PinID7 = 7,
    PinID8 = 8,
    PinID9 = 9,
    PinID10 = 10,
    PinID11 = 11,
    PinID12 = 12,
    PinID13 = 13,
    PinID14 = 14,
    PinID15 = 15,
};

/// <summary>
/// PICO Supported Pin modes
/// </summary>
enum GpioPinMode
{
    InputFloating = 0,
    InputPullup = 1,
    InputPulldown = 2,
    OutputOpenDrain = 3,
    OutputPushpull = 4
};

/// <summary>
/// PICO Supported Interrupt Functional States
/// </summary>
enum GpioIntFuncState
{
    Disable = 0,
    Enable = 1
};

/// <summary>
/// PICO Supported Pin States
/// </summary>
enum GpioPinState
{
    Low = 0,
    High = 1
};

enum CmdStatus
{
    Success = 0x00,
    Failure = 0x01,

    I2CBusy = 0x10,
    I2CResourceError = 0x11,
    I2CNotSupported = 0x12,
    I2CUnknown = 0x13,
    I2CMrmsErr = 0x14,
    I2CMtmsErr = 0x15,
    I2CMbtErr = 0x16
};

/// <summary>
/// PICO Supported Hardware Blocks
/// </summary>
enum HardwareBlockID
{
    One = 1,
    Two = 2
};

/// <summary>
/// PICO Firmware Version
/// </summary>
struct FWVersion
{
    uint8_t Major;
    uint8_t Minor;
    uint8_t Inc;
};

#endif