
#include "mbed.h"
#include "MAX44009_lib.h"

// *****************************************************************************
//   MAX44009_write_register(char, char, char)  writes single byte to MAX44009
//                       char   I2C address
//                       char   MAX44009 register address
//                       char   data byte to be writen
//   returns                    0 on success ACK, 1 on NACK 
// *****************************************************************************

int MAX44009_write_register(I2C *i2c, char I2C_add, char reg_add, char byte){
    char data[2];               // char type ranges from 0 to 255 (8 bytes)
    int error;
    data[0] = reg_add;
    data[1] = byte;
    error = i2c->write(I2C_add,data,2);  // why send 2 bytes?
    //if(DEBUG)db.printf("wr[%02X %02X %d]\r\n", data[0], data[1], error);
    return error; 
    
}

/// ****************************************************************************
//   MAX44009_write_register(char, char, char *, int)  writes multiple bytes to MAX44009
//                       char   I2C address
//                       char   MAX44009 register address
//                       char * data vector of bytes to be written
//                       int    number of bytes to write
//   returns                    0 on success ACK, 1 on NACK 
// *****************************************************************************

int MAX44009_write_register(I2C *i2c, char I2C_add, char reg_add, char *bytes, int n){
    int i;   
    //set start address
    char data[16];
    int error;                          
    data[0] = reg_add; 
    for(i=1;i<=n;i++){                   
       data[i] = bytes[i-1];
    }
    error = i2c->write(I2C_add,data,n+1);  // send n bytes of data
  
    return error;      
}

// *****************************************************************************
//   MAX44009_read_register(char, char, char *)  reads single byte from MAX44009
//                       char   I2C address
//                       char   MAX44009 register address
//                       char * data vector for read bytes to be stored in 
//   returns                    0 on success, 1 on fail 
// *****************************************************************************

int MAX44009_read_register(I2C *i2c, char I2C_add, char reg_add, char *bytes){
    int error;
    error = i2c->write(I2C_add,&reg_add,1,1); 
    if(error)return error;   
    error = i2c->read(I2C_add,bytes,1);  
    //if(DEBUG)db.printf("rr e[%d]\r\n",error);
    return error; 
}


// *****************************************************************************
//   MAX44009_read_lux_register(char, char, char *, int)  reads lux value bytes from MAX44009
//                       char   I2C address
//                       char   MAX44009 register address
//                       char * data vector for read bytes to be stored in 
//   returns                    0 on success, 1 on fail 
// *****************************************************************************

int MAX44009_read_lux_register(I2C *i2c, char I2C_add, char reg_add, char *bytes){
    int error;
    
    error = i2c->write(I2C_add, &reg_add, 1, 1); 
    if(error)return error;   
    error = i2c->read(I2C_add, bytes, 1, true);
    if(error)return error; 
    
    reg_add += 1;       // increment register address
    error = i2c->write(I2C_add, &reg_add, 1, 1); //?
    if(error)return error;   
    error = i2c->read(I2C_add, bytes + 1, 1);       // bytes + 1; &bytes[1]
      
    //if(DEBUG)db.printf("rr e[%d]\r\n",error);
    return error; 
}


// *****************************************************************************
// convert_temperature(char)    sends convert command to MAX44009 device
//                     char     I2C address
// *****************************************************************************

//void convert_temperature(I2C *i2c, char I2C_add){   // set convert bit to start conversion
//
//    char data[2];  
//    
//    //read ADC_SETUP register 0x14
//    MAX44009_read_register(i2c, I2C_add, MAX44009_ADC_SETUP,data,1);       
//
//    //mask convert register value with 0x01 and write back register 0x14      
//    MAX44009_write_register(i2c, I2C_add, MAX44009_ADC_SETUP, data[0]|0x01);
//}

//******************************************************************************
// get_luxvalue(char)       read lux value from MAX44009 device register
//                 char     I2C address
// returns                  LuxResponse luxValue = light intensity in lux 
//                          status = register read result
//******************************************************************************

LuxResponse get_luxvalue(I2C *i2c, char I2C_add){
    char data[2];       // 2 bytes of raw Lux Register 
    double lux;
//    int count;
    
    // Read lux value, 2 bytes 
    int error = MAX44009_read_lux_register(i2c, I2C_add, MAX44009_LUX_HI, data);     
    
    //calculate lux from data     
//    count = (int)(data[0]*256 + data[1]);
//    if (count >= 32768)count = count - 65536;     // 2s comp
//    T = (double)count*0.005; 
    
    int exponent;
    int mantissa;
    exponent = int(data[0] >> 4);
    mantissa = int(data[0] << 4) + int(data[1]);
    lux = 0.045 * mantissa * pow((double)2, exponent);
    
    
    LuxResponse resp;
    resp.luxValue = lux;
    resp.status = error; // 1 for nack/error. 0 for ack/success
    return resp;  
}

double calc_lux(char *data) {
    
    // data is an array of size 2
    
    int exponent = int(data[0] >> 4);
    int mantissa = (int)((data[0] << 4) & 0xF0) + (int)(data[1]);
    double lux = 0.045 * mantissa * pow((double) 2, exponent);
    
    return lux;
    
}