#include "mbed.h"

//OT07 Registers
#define OT07_STATUS         0x00    // OT07 status regiter
#define OT07_INT_EN         0x01    // OT07 Interrupt Enable
#define OT07_FIFO_W         0x04    // OT07 FIFO Write Pointer
#define OT07_FIFO_R         0x05    // OT07 FIFO Read Pointer
#define OT07_FIFO_OF        0x06    // OT07 FIFO Overflow Counter
#define OT07_FIFO_COUNT     0x07    // OT07 FIFO Data Count
#define OT07_FIFO_DATA      0x08    // OT07 FIFO Data
#define OT07_FIFO_CNFG1     0x09    // OT07 FIFO Configuration 1 (FIFO_A_FULL)
#define OT07_FIFO_CNFG2     0x0A    // OT07 FIFO Configuration 2
#define OT07_SYS            0x0C    // OT07 System Configuration
#define OT07_ALARM_HIGH_MSB 0x10    // OT07 Alarm High MSB
#define OT07_ALARM_HIGH_LSB 0x11    // OT07 Alarm High LSB
#define OT07_ALARM_LOW_MSB  0x12    // OT07 Alarm Low MSB
#define OT07_ALARM_LOW_LSB  0x13    // OT07 Alarm LOW LSB
#define OT07_ADC_SETUP      0x14    // OT07 Temp Seneor Setup (ADC_RES[7:6]) & Convert Temperature [0]
#define OT07_GPIO_SETUP     0x20    // OT07 GPIO Setup,  sets GPIO modes
#define OT07_GPIO_CTRL      0x21    // OT07 GPIO control
#define OT07_ROM_ID         0x31    // OT07 ROM_ID address of LSB?

#define DEVICE_ACK      0
#define DEVICE_NACK     1
#define DEVICE_BAD_RESP 2

#define MAX_DEVICES 64      // Maximum number of rom devices allowed
#define ID_LENGTH   6       // Rom ID length in bytes

struct OT07_struct {
    char rom_id[ID_LENGTH];     // device ROM ID
    char I2C_address;           // I2C addess, based on GPIO0 and GPIO1 at power up
                                // Why char?
}; 

struct TempResponse {
    double tempC;     // Temperature in °C 
    int status;       // Status of Temperature read. 0 for success, 1 for error
};

// *****************************************************************************
//   OT07_write_register(char, char, char)  writes single byte to OT07
//                       char   I2C address
//                       char   OT07 register address
//                       char   data byte to be writen
//   returns                    0 on success ACK, 1 on NACK 
// *****************************************************************************
int OT07_write_register(I2C *i2c, char I2C_add, char reg_add, char byte);

/// ****************************************************************************
//   OT07_write_register(char, char, char *, int)  writes multiple bytes to OT07
//                       char   I2C address
//                       char   OT07 register address
//                       char * data vector of bytes to be written
//                       int    number of bytes to write
//   returns                    0 on success ACK, 1 on NACK 
// *****************************************************************************
int OT07_write_register(I2C *i2c, char I2C_add, char reg_add, char *bytes, int n);

// *****************************************************************************
//   OT07_read_register(char, char, char *, int)  writes single byte to OT07
//                       char   I2C address
//                       char   OT07 register address
//                       char * data vector for read bytes to be stored in 
//                       int    number of bytes to read
//   returns                    0 on success, 1 on fail 
// *****************************************************************************
int OT07_read_register(I2C *i2c, char I2C_add, char reg_add, char *bytes, int n);

// *****************************************************************************
// convert_temperature(char)    sends convert command to OT07 device
//                     char     I2C address
// *****************************************************************************
void convert_temperature(I2C *i2c, char I2C_add);

//******************************************************************************
// get_temperature(char)    read temperature from OT07 device FIFO register
//                 char     I2C address
// returns                  TempResponse tempC = temperature in oC 
//                          status = register read result
//******************************************************************************
TempResponse get_temperature(I2C *i2c, char I2C_add);

double calc_temperature(char *data);