#include "mbed.h"

//AO19 Registers
#define AO19_DEVICE_ID      0x00    // AO19 Chip ID
#define AO19_BB_CFG0        0x01    // AO19 Buck Boost Configure
#define AO19_BB_VSET        0x02    // AO19 Buck Boost Voltage Set
#define AO19_BB_ISET        0x03    // AO19 Buck Boost Current Set
#define AO19_BB_CFG1        0x04    // AO19 Buck Boost Configure 1
#define AO19_STATUS         0x05    // AO19 Status Register
#define AO19_INT            0x06    // AO19 Interrupt
#define AO19_MSK            0x07    // AO19 Mask
#define AO19_LOCK_MSK       0x50    // AO19 Lock Mask
#define AO19_PASSWD         0x51    // AO19 Password

#define DEVICE_ACK      0
#define DEVICE_NACK     1
#define DEVICE_BAD_RESP 2

#define MAX_DEVICES 64      // Maximum number of rom devices allowed
#define ID_LENGTH   6       // Rom ID length in bytes

struct AO19_struct {
    char rom_id[ID_LENGTH];     // device ROM ID
    char I2C_address;           // I2C addess, based on GPIO0 and GPIO1 at power up
                                // Why char?
}; 

// *****************************************************************************
//   AO19_write_register(char, char, char)  writes single byte to AO19
//                       char   I2C address
//                       char   AO19 register address
//                       char   data byte to be writen
//   returns                    0 on success ACK, 1 on NACK 
// *****************************************************************************
int AO19_write_register(I2C *i2c, char I2C_add, char reg_add, char byte);

/// ****************************************************************************
//   AO19_write_register(char, char, char *, int)  writes multiple bytes to AO19
//                       char   I2C address
//                       char   AO19 register address
//                       char * data vector of bytes to be written
//                       int    number of bytes to write
//   returns                    0 on success ACK, 1 on NACK 
// *****************************************************************************
int AO19_write_register(I2C *i2c, char I2C_add, char reg_add, char *bytes, int n);

// *****************************************************************************
//   AO19_read_register(char, char, char *)  reads single byte from AO19
//                       char   I2C address
//                       char   AO19 register address
//                       char * data vector for read bytes to be stored in 
//   returns                    0 on success, 1 on fail 
// *****************************************************************************
int AO19_read_register(I2C *i2c, char I2C_add, char reg_add, char *bytes);

// *****************************************************************************
//   AO19_read_register(char, char, char *, int)  reads byte(s) from AO19
//                       char   I2C address
//                       char   OT07 register address
//                       char * data vector for read bytes to be stored in 
//                       int    number of bytes to read
//   returns                    0 on success, 1 on fail 
// *****************************************************************************
int AO19_read_register(I2C *i2c, char I2C_add, char reg_add, char *bytes, int n);
