
#include "mbed.h"
#include "AO19_lib.h"

// *****************************************************************************
//   AO19_write_register(char, char, char)  writes single byte to AO19
//                       char   I2C address
//                       char   AO19 register address
//                       char   data byte to be writen
//   returns                    0 on success ACK, 1 on NACK 
// *****************************************************************************

int AO19_write_register(I2C *i2c, char I2C_add, char reg_add, char byte){
    char data[2];               // char type ranges from 0 to 255 (8 bytes)
    int error;
    data[0] = reg_add;
    data[1] = byte;
    error = i2c->write(I2C_add,data,2);  
    //if(DEBUG)db.printf("wr[%02X %02X %d]\r\n", data[0], data[1], error);
    return error; 
    
}

/// ****************************************************************************
//   AO19_write_register(char, char, char *, int)  writes multiple bytes to AO19
//                       char   I2C address
//                       char   AO19 register address
//                       char * data vector of bytes to be written
//                       int    number of bytes to write
//   returns                    0 on success ACK, 1 on NACK 
// *****************************************************************************

int AO19_write_register(I2C *i2c, char I2C_add, char reg_add, char *bytes, int n){
    int i;   
    //set start address
    char data[16];
    int error;                          
    data[0] = reg_add; 
    for(i=1;i<=n;i++){                   
       data[i] = bytes[i-1];
    }
    error = i2c->write(I2C_add,data,n+1);  // send n bytes of data
  
    return error;      
}

// *****************************************************************************
//   AO19_read_register(char, char, char *)  reads single byte from AO19
//                       char   I2C address
//                       char   AO19 register address
//                       char * data vector for read bytes to be stored in 
//   returns                    0 on success, 1 on fail 
// *****************************************************************************

int AO19_read_register(I2C *i2c, char I2C_add, char reg_add, char *bytes){
    int error;
    error = i2c->write(I2C_add,&reg_add,1,1); 
    if(error)return error;   
    error = i2c->read(I2C_add,bytes,1);  
    //if(DEBUG)db.printf("rr e[%d]\r\n",error);
    return error; 
}

// *****************************************************************************
//   AO19_read_register(char, char, char *, int)  reads byte(s) from AO19
//                       char   I2C address
//                       char   OT07 register address
//                       char * data vector for read bytes to be stored in 
//                       int    number of bytes to read
//   returns                    0 on success, 1 on fail 
// *****************************************************************************

int AO19_read_register(I2C *i2c, char I2C_add, char reg_add, char *bytes, int n){
    int error;
    error = i2c->write(I2C_add,&reg_add,1,1); 
    if(error)return error;   
    error = i2c->read(I2C_add,bytes,n);  
    //if(DEBUG)db.printf("rr e[%d]\r\n",error);
    return error; 
}