/*******************************************************************************
* Copyright (C) Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

#include "ForwardErrCorr.h"

Translator::Translator(char *SymmetricKey, char *TransTable): 
m_SymmetricKey(SymmetricKey),m_TransTable(TransTable)
{
}

//******************************************************************************
Translator::~Translator(void){
}

//******************************************************************************
uint32_t Translator::Decrypt(char *tes, uint16_t *Output){
    int8_t ValOut,ValIn;
    int key = 0;
    Output[0] = 0;
    printf("Recieved Data -> Decrypted Data:\r\n");
    for(int i = 2;i<10;i++){
        ValIn = tes[i];
        ValIn = ValIn ^ m_SymmetricKey[key];      //Unencrypt data
        printf("%c -> %i\r\n",ValIn,tes[i]);
        key++;
        ValOut = 5;
        for (int j=0;j<4;j++){
            if (ValIn == m_TransTable[j]){
                ValOut = j;
            }
        }
        if (ValOut == 5){
            ValOut = ChkHam(ValIn);    
        }
        if (ValOut == 4){
            printf("Transmission error -- Hamming Distance Collision\r\n");
            return (1);
        }
        Output[0] = (Output[0] << 2) + ValOut;
        printf("Output: %d\r\n",Output[0]);
    }
    return(0);
}

//******************************************************************************
int Translator::ChkHam(char ChkVal){
    char trial = ChkVal & 0x1F;
    bool dupe = 0; 
    int index, temp;
    int min = 5;
    for (int k = 0; k<4;k++){
        temp = HamDist(trial,m_TransTable[k]);
        if (temp == 1){
            return (k);
        }
        else if (temp < min){
            min = temp;
            index = k;
            dupe = 0;
        }
        else if (temp == min){
            dupe = 1;
        }
    }
    if (dupe == 1){
        return(4);
    }
    else{
        return (index);
    }
}

//******************************************************************************
int Translator::HamDist(char ChkVal, char TableVal){
    int count=0;
    char tes1,tes2;
    for (int j =0;j<5;j++){
        tes1 = ChkVal >> j;
        tes2 = TableVal >> j;
        char temp = tes1 ^ tes2;
        count += temp&1;
    }
    return (count);
}

//******************************************************************************
uint32_t Translator::Encrypt(uint16_t tempData,char *EncryptedData){
    char data;
    int z=0;
    printf("FEC Encoded Data:\r\n");
    for (int i=14;i>=0;i-=2){
        data = ((tempData >> i)&0x03);
        data = m_TransTable[data];
        printf("%d  ",data);
        data = (data ^ m_SymmetricKey[z]);
        EncryptedData[z]=data;
        z++;
    }
    printf("\r\n");
    return(0);
}

//******************************************************************************
uint32_t Translator::Encrypt(char tempData, char *EncryptedData){
    char data;
    int z =0;
    for (int i=6;i>=0;i-=2){
        data = ((tempData >> i)&0x03);
        data = m_TransTable[data];
        data = (data ^ m_SymmetricKey[z]);
        EncryptedData[z] = data;
        z++;
    }
    return(0);
}
