/**********************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
**********************************************************************/

#include "mbed.h"
#include "max32630fthr.h"
#include "Adafruit_SSD1306.h"
#include "USBSerial.h"
#include "bmi160.h"


MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

I2C i2c(P3_4, P3_5); // SDA, SCL

// Hardware serial port over DAPLink
Serial daplink(P2_1, P2_0);

// Virtual serial port over USB
USBSerial microUSB;

DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);
 

DigitalIn aButton(P5_3, PullUp);
DigitalIn bButton(P3_3, PullUp);
DigitalIn cButton(P3_2, PullUp);

/* Analog inputs 0 and 1 have internal dividers to allow measuring 5V signals  
 * The dividers are selected by using inputs AIN_5 and AIN_5 respectively.
 * The full scale range for AIN0-3 is 1.2V
 * The full scale range for AIN4-5 is 6.0V
 */
AnalogIn ain0(AIN_4); 
AnalogIn ain1(AIN_5); 
AnalogIn ain2(AIN_2); 
AnalogIn ain3(AIN_3);
// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)


Timer t; 
Timer sense_t;

//*****************************************************************************

void dumpImuRegisters(BMI160 &imu);
void printRegister(BMI160 &imu, BMI160::Registers reg);
void printBlock(BMI160 &imu, BMI160::Registers startReg, BMI160::Registers stopReg);



void dumpImuRegisters(BMI160 &imu)
{
    printRegister(imu, BMI160::CHIP_ID);
    printBlock(imu, BMI160::ERR_REG,BMI160::FIFO_DATA);
    printBlock(imu, BMI160::ACC_CONF, BMI160::FIFO_CONFIG_1);
    printBlock(imu, BMI160::MAG_IF_0, BMI160::SELF_TEST);
    printBlock(imu, BMI160::NV_CONF, BMI160::STEP_CONF_1);
    printRegister(imu, BMI160::CMD);
    printf("\n");
}


//*****************************************************************************
void printRegister(BMI160 &imu, BMI160::Registers reg)
{
    uint8_t data;
    if(imu.readRegister(reg, &data) == BMI160::RTN_NO_ERROR)
    {
        printf("IMU Register 0x%02x = 0x%02x\n", reg, data);
    }
    else
    {
        printf("Failed to read register\n");
    }
}


//*****************************************************************************
void printBlock(BMI160 &imu, BMI160::Registers startReg, BMI160::Registers stopReg)
{
    uint8_t numBytes = ((stopReg - startReg) + 1);
    uint8_t buff[numBytes];
    uint8_t offset = static_cast<uint8_t>(startReg);
    
    if(imu.readBlock(startReg, stopReg, buff) == BMI160::RTN_NO_ERROR)
    {
        for(uint8_t idx = offset; idx < (numBytes + offset); idx++)
        {
            printf("IMU Register 0x%02x = 0x%02x\n", idx, buff[idx - offset]);
        }
    }
    else
    {
        printf("Failed to read block\n");
    }
}


int main()
{
    int c;
    c = ' ';

    daplink.printf("daplink serial port\r\n");
    microUSB.printf("micro USB serial port\r\n");
    rLED = LED_ON;
    gLED = LED_ON;
    bLED = LED_OFF;


    Thread::wait(50);  // Give the supplies time to settle before initializing the display
    Adafruit_SSD1306_I2c featherOLED(i2c);  
   // featherOLED.printf("%ux%u OLED Display\r\n", featherOLED.width(), featherOLED.height());
    featherOLED.printf("HelloWorld \r");
    featherOLED.display();
    wait (3.0); 
    //=====================================================
    
    I2C i2cBus(P5_7, P6_0);
    i2cBus.frequency(400000);
    BMI160_I2C imu(i2cBus, BMI160_I2C::I2C_ADRS_SDO_LO);
    
    uint32_t failures = 0;
    
    if(imu.setSensorPowerMode(BMI160::GYRO, BMI160::NORMAL) != BMI160::RTN_NO_ERROR)
    {
        printf("Failed to set gyroscope power mode\n");
        failures++;
    }
    wait_ms(100);
    
    if(imu.setSensorPowerMode(BMI160::ACC, BMI160::NORMAL) != BMI160::RTN_NO_ERROR)
    {
        printf("Failed to set accelerometer power mode\n");
        failures++;
    }
    wait_ms(100);
    
    
    BMI160::AccConfig accConfig;
    //example of using getSensorConfig
    if(imu.getSensorConfig(accConfig) == BMI160::RTN_NO_ERROR)
    {
        printf("ACC Range = %d\n", accConfig.range);
        printf("ACC UnderSampling = %d\n", accConfig.us);
        printf("ACC BandWidthParam = %d\n", accConfig.bwp);
        printf("ACC OutputDataRate = %d\n\n", accConfig.odr);
    }
    else
    {
        printf("Failed to get accelerometer configuration\n");
        failures++;
    }
    
    //example of setting user defined configuration
    accConfig.range = BMI160::SENS_4G;
    accConfig.us = BMI160::ACC_US_OFF;
    accConfig.bwp = BMI160::ACC_BWP_2;
    accConfig.odr = BMI160::ACC_ODR_8;
    if(imu.setSensorConfig(accConfig) == BMI160::RTN_NO_ERROR)
    {
       // printf("ACC Range = %d\n", accConfig.range);
       // printf("ACC UnderSampling = %d\n", accConfig.us);
      //  printf("ACC BandWidthParam = %d\n", accConfig.bwp);
       // printf("ACC OutputDataRate = %d\n\n", accConfig.odr);
    }
    else
    {
        printf("Failed to set accelerometer configuration\n");
        failures++;
    }
    
    BMI160::GyroConfig gyroConfig;
    if(imu.getSensorConfig(gyroConfig) == BMI160::RTN_NO_ERROR)
    {
        printf("GYRO Range = %d\n", gyroConfig.range);
        printf("GYRO BandWidthParam = %d\n", gyroConfig.bwp);
        printf("GYRO OutputDataRate = %d\n\n", gyroConfig.odr);
    }
    else
    {
        printf("Failed to get gyroscope configuration\n");
        failures++;
    }
    
    wait(1.0);
    printf("\033[H");  //home
    printf("\033[0J");  //erase from cursor to end of screen
    
    
    //==========================================
    
    if(imu.setSensorPowerMode(BMI160::GYRO, BMI160::NORMAL) != BMI160::RTN_NO_ERROR)
    {
        printf("Failed to set gyroscope power mode\n");
        failures++;
    }
    wait_ms(100);
    
    if(imu.setSensorPowerMode(BMI160::ACC, BMI160::NORMAL) != BMI160::RTN_NO_ERROR)
    {
        printf("Failed to set accelerometer power mode\n");
        failures++;
    }
    wait_ms(100);
    

    while(1) {
        Thread::wait(250);
        if (microUSB.readable()) {
            c = microUSB.getc();
            microUSB.putc(c);
            daplink.putc(c);
        }
        if (daplink.readable()) {
            c = daplink.getc();
            microUSB.putc(c);
            daplink.putc(c);
        }
        
        int high =1; 
        int low =0; 
        DigitalOut trigger (P5_2);
        trigger = 1;
        wait_us(10);
        trigger = 0; 
        
        gLED = LED_OFF;
        
        DigitalIn echo(P5_1); 
        
        printf("Starting ultrasensor:");
        
        while(echo == 1) // edge signal = 1
        {   
            sense_t.start(); 
            gLED = LED_ON;
            if(echo == 0) {
                break;
                }
                
        }
            sense_t.stop();
            gLED = LED_OFF;
            printf("Ultrasensor sensor duration %f seconds\n", sense_t.read()); 
            
        //if (echo == 1) 
        //{
          //  DigitalOut gLED(LED2, LED_ON);
          //  wait(1);
            //gLED = LED_OFF;
       // }
        
        //*************************testing timeer *******************************************
        
        t.start();
        printf("Hello World!\n");
        t.stop();
        printf("The time taken was %f seconds\n", t.read());
        
        
        
        // **********************************************************************************

        
        
        
        float imuTemperature; 
        BMI160::SensorData accData;
        BMI160::SensorData gyroData;
        BMI160::SensorTime sensorTime;
        
        imu.getGyroAccXYZandSensorTime(accData, gyroData, sensorTime, accConfig.range, gyroConfig.range);
        imu.getTemperature(&imuTemperature);
        
        
        rLED = aButton;
        gLED = bButton;
        bLED = cButton;
        featherOLED.clearDisplay();
        featherOLED.setTextCursor(0,0);
        featherOLED.printf("SensorTemp = %s%5.3f\n", "\033", imuTemperature);
        featherOLED.printf("X%s%4.1f ", "\033", gyroData.xAxis.scaled);
        featherOLED.printf("Y%s%4.1f ", "\033", gyroData.yAxis.scaled);
        featherOLED.printf("Z%s%4.1f\n", "\033", gyroData.zAxis.scaled);
        //printf("GYRO yAxis = %s%5.1f\n", "\033[K", gyroData.yAxis.scaled);
       // printf("GYRO zAxis = %s%5.1f\n", "\033[K", gyroData.zAxis.scaled);
        //featherOLED.printf("MAX32630FTHR OLED\n");
        featherOLED.printf("AIN0/1: %1.2f, %1.2f\n", (6.0f * ain0), (6.0f * ain1) );  // analog inputs 0,1
       // featherOLED.printf("AIN2/3: %1.2f, %1.2f\n", (1.2f * ain2), (1.2f * ain3) );  // analog inputs 2,3
      //  featherOLED.printf("UART:%c  A:%d  B:%d  C:%d\n", c, aButton.read(), bButton.read(), cButton.read());  // UART and Buttons
        featherOLED.display();

    }
}

