/*
 *
 *  config.h Virgo v3 PCB AV22032015
 *
 */
 
#ifndef VirgoConfig_H
#define VirgoConfig_H

//** General Functions ****************************************************************************
#define PC_BAUDRATE 921600

//-------------------------------------------------------------------------------------------------

//** Function exectution rates ********************************************************************
#define Hearbeat_RateHz 1 //hearbeat loop run rate in Hz
#define Hearbeat_RateMS (1000/Hearbeat_RateHz) //hearbeat loop run rate in ms

#define imu_UpdateRateHz 110 // imu update rate in Hz
#define imu_UpdatePeriodMS (1000/imu_UpdateRateHz) // imu update rate in ms

#define motorControl_UpdateRateHz 50// 200 // motorControl update rate in Hz
#define motorControl_UpdatePeriodMS (1000/motorControl_UpdateRateHz) // motorControl update rate in ms

#define odometry_UpdateRateHz 125 //odometry update rate in Hz
#define odometry_UpdatePeriodMS (1000/odometry_UpdateRateHz) //odometry update rate in ms

#define PrintLoop_RateHz 10 //print loop run rate in Hz
#define PrintLoop_PeriodMS (1000/PrintLoop_RateHz) //print loop run rate in ms

#define PurePursuit_UpdateRateHz 20//Pure pursuit update run rate in Hz
#define PurePursuit_UpdatePeriodMS (1000/PurePursuit_UpdateRateHz)//Pure pursuit update run rate in ms

#define WaypointCmd_UpdateRateHz 10 //waypoint commander run rate in Hz
#define WaypointCmd_UpdatePeriodMS (1000/WaypointCmd_UpdateRateHz) //waypoint commander run rate in ms

#define CommLoop_UpdateRateHz 100 //Communications loop run rate in Hz
#define CommLoop_UpdatePeriodMS (1000/CommLoop_UpdateRateHz) //Communications loop run rate in ms

#define CommPump_UpdateRateHz 500 //nRF network communications pump run rate in Hz
#define CommPump_UpdatePeriodMS (1000/CommPump_UpdateRateHz) //nRF network communications pump run rate in ms

//#define nRfDefault_uploadRateMS 200 //default upload rate in ms for nRF wireless comm

#define camera_cycleMinutes 15 //default camera switch on frequency in minutes
#define camera_CaptureTimeS 30 //default camera capture time in seconds

#define DataRecorder_RateHz 100 //data recorder loop run rate in Hz
#define DataRecorder_PeriodMS (1000/DataRecorder_RateHz) //data recorder loop run rate in ms
//-------------------------------------------------------------------------------------------------


//** Drivetrain ********************************************************************************
//** Motor **
#define PWMfreq_khz 20

#define PIDFf_kP    0.50
#define PIDFf_kI    1.50
#define PIDFf_kD    0.20
#define PIDFf_kFf   2.50

#define PIDFf_lim_P    0.05
#define PIDFf_lim_I    0.30
#define PIDFf_lim_D    0.05
#define PIDFf_lim_Ff   0.60

#define PIDFf_range_min     -1.0
#define PIDFf_range_max     1.0

#define pid_MWindowSize 10

//#define motor_LimitRPM_min  -100.0
//#define motor_LimitRPM_max  300.0

//#define motor_Acc_limit     200.0
//-------------

//** Encoder **
#define encoder_resolution 408.168 // Number of counts per revolution
#define encoder_MWindowSize 10
//-------------
//-------------------------------------------------------------------------------------------------



//** Localization *********************************************************************************
//** IMU **
#define Pose_MWindowSize 10
#define GyroAcc_MWindowSize 10

//* MPU6050 *
#define MPU6050_StabilizationReadings 10 //number of non deviating data points to determine if imu has stabilized
#define IMU_FIFO_RATE_DIVIDER 0x01 // FIFO rate = 200Hz / (1 + this value), range 0x00 to 0x09. Here, 0x01 implies 100Hz.
#define IMU_SAMPLE_RATE_DIVIDER 1 // Sample rate = 1kHz / (1 + this value), Here, 1 implies 500Hz.
#define MPU6050_GYRO_FS MPU6050_GYRO_FS_2000 // measuring range of gyroscope (±n deg/s)
#define MPU6050_ACCEL_FS MPU6050_ACCEL_FS_2 // measuring range of acceleration sensor (±n g)
//*   **   *

//* BNO055 *
#define BNO055_StabilizationReadings 200 //number of non deviating data points to determine if imu has stabilized

//*   **   *

//* Localization *
#define wheel_dia 60 //wheel dia in mm * effective hypocyclic gear ratio
#define track_width 165 // in mm


//-------------------------------------------------------------------------------------------------


//** PurePursuit controller *************************************************************************
#define track_width 165 //track width in mm
#define driveTrain_minV 10//175 //min velocity of individual drive in mm/s
#define driveTrain_maxV 700//235 //max velocity of individual drive in mm/s

//-------------------------------------------------------------------------------------------------

//** Communications *******************************************************************************
#define virgo3_robot_address 01 //address of this robot node
#define virgo3_network_channel 68 //communications channel number

//-------------------------------------------------------------------------------------------------


//** Attitude Controller **************************************************************************
#define wheelV_MWindowSize 25 //wheel velocity moving window filter size, customized for Pitch controller

//** HansonController **


//** PID pitch controller **
// This PID controller adds/subtracts a percentage of command velocity based on the variations of
// the pitch angle while controlling the pitch angle to a setpoint angle.

#define AttPIDFf_kP    9.00
#define AttPIDFf_kI    1.00
#define AttPIDFf_kD    0.10
#define AttPIDFf_kFf   0.00

#define AttPIDFf_lim_P  0.6
#define AttPIDFf_lim_I  0.1
#define AttPIDFf_lim_D  0.3
#define AttPIDFf_lim_Ff 0.0

#define AttPIDFf_range_min  -1.0
#define AttPIDFf_range_max   1.0


//-------------------------------------------------------------------------------------------------

//** Data Recorder ********************************************************************************
#define max_coloumns 16
//#define max_rows 1200
#define max_rows 120
#define max_RAM 16*1024 //max permissible ram usage in kB

//-------------------------------------------------------------------------------------------------


#endif /* VirgoConfig_H */