#ifndef purePursuit_H
#define purePursuit_H

#include "mbed.h"
#include "generalFunctions.h"
#include "config.h"

class purePursuit
{
public:

    purePursuit();

    /// generate velocity (mm/s) and omega (rad/s) for diff drive to track
    void GenVW(float* purePursuit_velocity, float* purePursuit_omega,
               float target_waypoint[2], float target_velocity,
               float current_position[2], float current_heading);

    /// generate velocity (mm/s), gamma (rad) and omega (rad/s) for non-linear controller to track
    void GenVGW(float* purePursuit_velocity, float* purePursuit_gamma, float* purePursuit_omega,
                float target_waypoint[2], float target_velocity,
                float current_position[2], float current_heading);

    float robotFrame_targetDistance;
    float purePursuit_headingE;
    float purePursuit_ld;
    float purePursuit_r;

private:
    static float const ld_min = 200.0; //min purepursuit lookahead distance
    static float const ld_max = 2000.0; //max purepursuit lookahead distance
    static float const trackingLimit = 50.0; //purepursuit will track only until the target distance is greater than this limit

    static float const drive_minV = driveTrain_minV;
    static float const drive_maxV = driveTrain_maxV;

    static float const purePursuit_omega_limit = DEG_TO_RAD(90);

    float robotFrame_targetPos[2];

};


#endif