#ifndef pidControl_H
#define pidControl_H

#include "mbed.h"
#include "generalFunctions.h"
#include "config.h"

class pidControl
{    
public:
    pidControl();
    void setGains(float kP,float kI, float kD, float kFf);
    void setTermLimits(float P_min, float P_max, float I_min, float I_max, float D_min, float D_max, float Ff_min, float Ff_max);
    void setOutputRange(float outMin, float outMax);
    float calcOutput(float setPoint, float feedback, float servoTime);
    float processAcc(float setPoint, float targetAcc, float servoTime);
                    
    float PIDFf_terms[4];    
    float Summ_term;                    
                           
private:
    float PIDFf_gains[4];
    float PIDFf_limits[4][2];
    float output_limits[2];
    
    float controlError[2];       
    
    float prevSetPoint; //for acceleration
    float compensatedSetPoint;
    
    //float PIDFf_terms[4];    
    //float Summ_term;
};


#endif