 /*
 * Copyright (C) 2016 Akash Vibhute <akash.roboticist@gmail.com>
 * 
 * Header to link all global extern variables, functions referenced in different functions
 *
 *
 * Initial Release: May/05/2016
 *
 */
 
/**
 * @file globalExterns.h
 *
 * Header to link all global extern variables, functions referenced in different functions
 */
 
#ifndef globalExterns_H
#define globalExterns_H

#include "main.h"

/**
 * Linked variables from main.cpp
 *
 */
 
//** Drivetrain **
extern odometer odometry;  //odometer function
extern float rpm_cmd[2]; //drive motor rpm command
extern float rpm_compensated[2]; //rpm command compensated by acc limit
extern float targetAcceleration; //RPM/s acceleration
extern float pwm_cmd[2]; //drive motor pwm command 
//-------------

//** Localization **
extern IMU_BNO055 imu; //Bosch BNO055 IMU wrapper class. For Invensense IMU use IMU_MPU6050 imu;    //MPU9150 / MPU6050 wrapper class
extern float imuTime;
extern Localization localization;  //localization function
//-------------

//-------------

//** Power Monitor **
//extern BattGuage battery; //Battery fuel gauge wrapper
//-------------

//** Trajectory tracking **
extern uint8_t totalWaypoints;
extern int16_t waypoints_set[][4];
extern float waypointZone; //diameter around desired waypoint, if robot reaches within that zone then waypoint is reached.
extern uint8_t waypointReached_flag; //indicates if the desired waypoint has been reached
extern uint8_t waypointSetFinish_flag; //indicates if the desired waypoint set is over and the robot needs to stop.
extern float target_waypoint[2]; //coordinates in millimeters for pure-pursuit's use. initialize with 0,0 this is necessary to prevent comparison to a garbage value
extern float target_velocity; //target velocity in mm/s
extern float distanceToWaypoint; //distance from robot to waypoint
extern uint8_t waypoint_index;
extern uint8_t go_cmd; //make robot run a waypoint set
//-------------

//** Camera **
extern uint8_t cameraFlag; //flag to enable camera: 0 - off, 1 - frequency controlled, 2 - permanantly on
//-------------

//** Robot data recorder **
//extern RDR virgoRDR;
extern uint8_t recordFlag; //flag to enable / disable recording: 0 - off, 1 - frequency controlled
//-------------



#endif