#include "odometer.h"

odometer::odometer():encLeft(enc_LA, enc_LB, NC, encoder_resolution, QEI::X4_ENCODING), encRight(enc_RB, enc_RA, NC, encoder_resolution, QEI::X4_ENCODING)
{
    
}

void odometer::init()
{
    uint16_t movWindow_size = encoder_MWindowSize;
    
    
    movWindow_index=0;
    if(movWindow_size <= movWindow_lenMax) movWindow_len = movWindow_size;
    else movWindow_len=movWindow_lenMax;

    for(int i=0; i<movWindow_len; i++) {
        rpmWindow_left[i]=0;
        rpmWindow_right[i]=0;
    }
    
    
    encRes = 4.0 * (float)encoder_resolution;
    enc_timer.start();
}

void odometer::update()
{
    timer_s = enc_timer.read();
    enc_timer.reset();
    
    pulse_counter[0][1] = encLeft.getPulses();
    pulse_counter[1][1] = encRight.getPulses();
    
    filtered_reading[0][0] = pulse_counter[0][1]/encRes;
    filtered_reading[1][0] = pulse_counter[1][1]/encRes;
    
    rpmWindow_left[movWindow_index] = (pulse_counter[0][1] - pulse_counter[0][0])/(encRes * timer_s / 60);
    rpmWindow_right[movWindow_index] = (pulse_counter[1][1] - pulse_counter[1][0])/(encRes * timer_s / 60);
    
    filtered_reading[0][1] = generalFunctions::moving_window(rpmWindow_left, movWindow_len);
    filtered_reading[1][1] = generalFunctions::moving_window(rpmWindow_right, movWindow_len);
    
    pulse_counter[0][0] = pulse_counter[0][1];
    pulse_counter[1][0] = pulse_counter[1][1];
    
    movWindow_index++;
    if(movWindow_index >= movWindow_len) movWindow_index=0;
    
    rpm[0] = filtered_reading[0][1];
    rpm[1] = filtered_reading[1][1];
    
    revolutions[0] = filtered_reading[0][0];
    revolutions[1] = filtered_reading[1][0];
}

/*
void odometer::getRPM(float *rpm[2])
{
    *rpm[0] = filtered_reading[0][1];
    *rpm[1] = filtered_reading[1][1];
}

void odometer::getRevolutions(float *revolutions[2])
{
    *revolutions[0] = filtered_reading[0][0];
    *revolutions[1] = filtered_reading[1][0];
}
*/