void visualizar();

#include "mbed.h"
#define buffer_length 2000

Ticker tMuestrear;
Ticker tVisualizar;
#include "TextLCD.h"


InterruptIn button(PC_13); 

TextLCD lcd(D8, D9, D2, D3, D4, D5, TextLCD::LCD16x2); // rs, e, d4-d7
Serial pc(USBTX, USBRX); // tx, rx 

Serial bluetooth(PC_0, PC_1); 

AnalogIn adc_in(A0); 
AnalogIn adc_in_in(A2); 
AnalogIn adc_in_dos(A1);

void muestrear();
void visualizar();
int flag=0;
int contador=0;
int contador_boton=0;
bool buffer_activo=0;
struct buffer {
    int16_t vA[buffer_length];
    int16_t iA[buffer_length];
    int16_t vB[buffer_length];
    int16_t iB[buffer_length];
};
buffer buffers;
struct estr_medidas
{
    float vrms;
    float irms;
    float pot_activa;
    float pot_reactiva;
    float pot_aparente;
    float en_consumida;
    float fact_potencia;
};
estr_medidas medidas;
void procesado(int16_t *datosV, int16_t *datosI, int longi, estr_medidas *medidas)
{
    int64_t b=0.0;
    int64_t c=0;
    int64_t d=0;
 for(int j=0;j<longi;j++)
 {
    b = b + datosV[j]*datosV[j]; 
    c = c + datosI[j]*datosI[j]; 
    d = d + datosV[j]*datosI[j]; 
 }


 medidas->vrms=0.01275509675*sqrt(((float)b)/longi);
 medidas->irms=0.0004536585089*sqrt(((float)c)/longi);
 medidas->pot_activa=(5.786458173e-6*d)/longi;
 medidas->pot_aparente=medidas->vrms*medidas->irms;
 medidas->pot_reactiva=sqrt((medidas->pot_aparente*medidas->pot_aparente)-(medidas->pot_activa*medidas->pot_activa));
 medidas->fact_potencia=((float)medidas->pot_activa)/medidas->pot_aparente;
 medidas->en_consumida+=0.001*medidas->pot_activa*longi;


}
void flip() {
 contador_boton++;
 if (contador_boton==8)
 {
 contador_boton=0;
 }
}
int main()
{
    pc.baud(115200);
    bluetooth.baud(9600); 
    tMuestrear.attach_us(&muestrear, 200);
    tVisualizar.attach(&visualizar, 1);
    button.rise(&flip); 
    while(1) {
        if(flag==1) {

            flag=0;

            if(buffer_activo) {

                procesado((int16_t *) buffers.vA, (int16_t *)buffers.iA, buffer_length, &medidas);

            } else {
                procesado((int16_t *)buffers.vB,(int16_t *)buffers.iB, buffer_length, &medidas);

 }


 }

 }
 }
void muestrear()
{
    int16_t datov=(int16_t)(adc_in.read_u16()^0x8000);
    int16_t datoi=(int16_t)(adc_in_in.read_u16()^0x8000);
    int16_t continua=(int16_t)(adc_in_dos.read_u16()^0x8000);
    if (buffer_activo==0) {
        buffers.vA[contador]=datov-continua;
        buffers.iA[contador]=datoi-continua;

    } else {
        buffers.vB[contador]=datov-continua;
        buffers.iB[contador]=datoi-continua;

    }
    contador++;
    if(contador==buffer_length) {
 //pc.printf("2");
        contador=0;
        flag=1;
        buffer_activo=!buffer_activo;
 }
}
void visualizar(){


    pc.printf("**** El valor Vrms es %f ****\n",medidas.vrms);
    pc.printf("**** El valor Irms es %f ****\n",medidas.irms);
    pc.printf("**** La potencia activa es %f ****\n",medidas.pot_activa);
    pc.printf("**** La potencia reactiva es %f ****\n",medidas.pot_reactiva);
    pc.printf("**** La potencia aparente es %f ****\n",medidas.pot_aparente);
    pc.printf("**** La energia consumida es %f ****\n",medidas.en_consumida);
    pc.printf("**** El factor de potencia es es %f ****\n\n",medidas.fact_potencia);

    switch (contador_boton){
        case 1:

            lcd.cls();
            lcd.printf("Vrms:\n%3.4f V\n", medidas.vrms);
        break;

        case 2:

            lcd.cls();
            lcd.printf("Irms:\n%3.2f A\n", medidas.irms);
        break;

        case 3:

            lcd.cls();
            lcd.printf("Pot activa\n%3.2f W\n", medidas.pot_activa);
        break;
        
        case 4:

            lcd.cls();
            lcd.printf("Pot reactiva\n%3.2f VAr\n", medidas.pot_reactiva);
        break;

        case 5:

            lcd.cls();
            lcd.printf("Pot aparente\n%3.2f VA\n", medidas.pot_aparente);
        break;
        
        case 6:

            lcd.cls();
            lcd.printf("En consumida\n%3.2f kW\n", medidas.en_consumida);
        break;
        
        case 7:

            lcd.cls();
            lcd.printf("Fact potencia\n%3.2f\n", medidas.fact_potencia);
        break;
        default:
            lcd.cls();
            lcd.printf("Pulsar boton");
    }
    bluetooth.printf("%3.2f|%3.2f|%3.2f|%3.2f|%3.2f|%3.2f|%3.2f|\n",medidas.vrms,
 medidas.irms,medidas.pot_activa,medidas.pot_reactiva,
 medidas.pot_aparente,medidas.en_consumida,medidas.fact_potencia);
}
