#ifndef MOTORCONTROL_H
#define MOTORCONTROL_H

#include "mbed.h"
#include "QEI.h"

#define UPDATE_FREQ 20000.0f //Hz

struct motorController
{
    volatile float LSpeed;
    volatile float RSpeed;
    volatile int LPrevPulses;
    volatile int RPrevPulses;
    
    float Rkp;
    float Lkp;
    float Rki;
    float Lki;
    float Rkd;
    float Lkd;
    
    
    volatile float rightControlSignal;
    volatile float leftControlSignal;
    
    volatile float error;
    
    volatile float leftErrorIntegral;
    volatile float rightErrorIntegral;
};

void updateMotorController(QEI* encoderR, QEI* encoderL, motorController* mc)
{
   int RPulses = encoderR->getPulses();
   int LPulses = encoderL->getPulses();
   mc->LSpeed = ((float)(LPulses - mc->LPrevPulses)) * UPDATE_FREQ;
   mc->RSpeed = ((float)(RPulses - mc->RPrevPulses)) * UPDATE_FREQ;
   
   mc->error = (float)RPulses + (float)LPulses;
   
   mc->LPrevPulses = LPulses;
   mc->RPrevPulses = RPulses;
   mc->rightErrorIntegral += mc->error;
   mc->leftErrorIntegral += mc->error;
   
   mc->rightControlSignal = mc->Rkp * mc->error + mc->Rki * mc->rightErrorIntegral  + mc->Rkd * mc->RSpeed;
}

void setPIDConstants(motorController* mc, float Rkp, float Lkp, float Rki, float Lki, float Rkd, float Lkd)
{
    mc->Rkp = Rkp;
    mc->Lkp = Lkp;
    mc->Rki = Rki;
    mc->Lki = Lki;
    mc->Rkd = Rkd;
    mc->Lkd = Lkd;
}

void resetMotorController(motorController* mc)
{
    mc->LSpeed = 0;
    mc->RSpeed = 0;
    mc->LPrevPulses = 0;
    mc->RPrevPulses = 0;
    mc->leftControlSignal = 0;
    mc->rightControlSignal = 0;
    mc->error = 0;
}
#endif