#define DEBUG

#include "mbed.h"
#include "pin.h"
#include "QEI.h"
#include "motorControl.h"
#include "globals.h"
#include <cmath>

// IRs - emitter
DigitalOut IR_Right(IR_R_PIN);
DigitalOut IR_Right_Diagonal(IR_DR_PIN);
DigitalOut IR_Right_Front(IR_FR_PIN);

DigitalOut IR_Left(IR_L_PIN);
DigitalOut IR_Left_Diagonal(IR_DL_PIN);
DigitalOut IR_Left_Front(IR_FL_PIN);

//Phototransistors -- receiver 
AnalogIn   PT_Right(PT_R_PIN);
AnalogIn   PT_Right_Diagonal (PT_DR_PIN);
AnalogIn   PT_Right_Front(PT_FR_PIN);

AnalogIn   PT_Left(PT_L_PIN);
AnalogIn   PT_Left_Diagonal (PT_DL_PIN);
AnalogIn   PT_Left_Front(PT_FL_PIN);


//Motors
PwmOut Motor_R_Fwd(MTR_R_FWD_PIN);
PwmOut Motor_R_Rev(MTR_R_REV_PIN);
PwmOut Motor_L_Fwd(MTR_L_FWD_PIN);
PwmOut Motor_L_Rev(MTR_L_REV_PIN);

Serial serial(TX_PIN, RX_PIN);

QEI encoderL(L_ENC_A_PIN, L_ENC_B_PIN, NC, PPREV);
QEI encoderR(R_ENC_A_PIN, R_ENC_B_PIN, NC, PPREV);

motorController mc;

Ticker IRTimer;
Ticker PIDTimer;

float delay = .05; // 50 ms

volatile float left;
volatile float dleft;
volatile float dright;
volatile float right;

float IR_Right_val, IR_Right_Diagonal_val,IR_Left_val,IR_Left_Diagonal_val;

void getSensorValues()
{
    IR_Right=1;
    IR_Right_val=PT_Right.read();
    IR_Right=0;
    
    IR_Right_Diagonal=1;
    IR_Right_Diagonal_val=PT_Right_Diagonal.read();
    IR_Right_Diagonal=0;

    
    IR_Left=1;
    IR_Left_val=PT_Left.read();
    IR_Left=0;
    
    IR_Left_Diagonal=1;
    IR_Left_Diagonal_val=PT_Left_Diagonal.read();
    IR_Left_Diagonal=0;

}

float debugVar = 0.0f;

void PID_LeftIR()
{
    static float integralError = 0;
    static float prevError = 0;
    
    float error = PID_LEFT_IR_SETPOINT - IR_Left_val;
    float dError = error - prevError;
    
    float pidAdjust = (kp_LIR * error + ki_LIR * integralError + kd_LIR * error);
    pidAdjust = pidAdjust > 0.0f ? pidAdjust : pidAdjust / 5;
    
    Motor_R_Fwd = BASE_MOTOR_SPEED + pidAdjust;
    Motor_L_Fwd = BASE_MOTOR_SPEED - pidAdjust;
    
    debugVar = kp_LIR * pidAdjust;
    
    integralError += error;
    prevError = error;
}

void BangBang_LeftIR()
{
    static float integralError = 0;
    static float prevError = 0;
    
    float error = PID_LEFT_IR_SETPOINT - IR_Left_val;
    float dError = error - prevError;
    
    float dir = error > 0.0f ? 1.0 : -1.6;
    
    Motor_R_Fwd = BASE_MOTOR_SPEED + dir * 0.01f;
    Motor_L_Fwd = BASE_MOTOR_SPEED - dir * 0.01f;
    
    debugVar = dir;
    
    integralError += error;
    prevError = error;
}

void PID_RightIR()
{
    static float R_integralError = 0;
    static float R_prevError = 0;
    
    float error = PID_RIGHT_IR_SETPOINT - IR_Right_val;
    float dError = error - R_prevError;
    
    
    Motor_R_Fwd = BASE_MOTOR_SPEED - (kp_RIR * error + kd_RIR * dError);
    Motor_L_Fwd = BASE_MOTOR_SPEED + (kp_RIR * error + kd_RIR * dError);
    
    R_integralError += error;
    R_prevError = error;
}
/////////////////////////
/////TODO
/////////////////////////
/*
Tune backupToCenter, IsFrontWall and PID_LeftIR constants
Create PID_RightIR, turning functions
*/
void backupToCenter()
{
    while(IR_Left_Diagonal_val > 0.4)
    {
        Motor_R_Rev = 0.1f;
        Motor_L_Rev = 0.1f;
    }
    Motor_R_Rev = 0.0f;
    Motor_L_Rev = 0.0f;   
    
}


bool IsFrontWall()
{
    if(IR_Left_Diagonal_val > 0.3 && IR_Right_Diagonal_val > 0.3)
    {
        return true;
    }
    else return false;
}

bool ifLeftDiagOpening() {
}

void turnRight(){

    int tolerance = 20; // by how many encoder counts can it be off by?
    int threshold = 577;
    float kp = 0.005;
    
    int initCountL = encoderL.getPulses();
    int initCountR = encoderR.getPulses();
    int countL = 0;
    int countR = 0;

    int errorL = threshold - countL;
    int errorR = threshold - countR;
    
    while(errorL > tolerance && errorR > tolerance){
        // turn PID

        Motor_L_Rev = 0.0f;
        Motor_R_Fwd = 0.0f;
        
        float targetSpeed = 0.2f + kp*errorL;
        
        if(Motor_R_Rev.read() < targetSpeed && Motor_L_Fwd.read() < targetSpeed)
        {
            Motor_R_Rev = Motor_R_Rev.read() + 0.1f;
            Motor_L_Fwd = Motor_L_Fwd.read() + 0.07f;
        }
        else if(Motor_R_Rev.read() > targetSpeed && Motor_L_Fwd.read() > targetSpeed)
        {
            Motor_R_Rev = Motor_R_Rev.read() - 0.07f;
            Motor_L_Fwd = Motor_L_Fwd.read() - 0.1f;
        }
        else
        {
            Motor_R_Rev = Motor_R_Rev.read();
            Motor_L_Fwd = Motor_L_Fwd.read();
        }
        
        countL = encoderL.getPulses() - initCountL;
        countR = encoderR.getPulses() - initCountR;

        errorL = threshold - countL;
        errorR = threshold - countR;

        wait_us(100);
    }

    Motor_R_Fwd = 0.2f;
    Motor_R_Rev = 0.0f;
    Motor_L_Rev = 0.50f;
    Motor_L_Fwd = 0.0f;  
    wait(.05);
    Motor_R_Fwd = 0.0f;
    Motor_R_Rev = 0.0f;
    Motor_L_Rev = 0.0f;
    Motor_L_Fwd = 0.0f;  
    
    return;
}
    

int main()
{
    wait(5.0f);
    encoderL.reset();
    encoderR.reset();

    IRTimer.attach_us(&getSensorValues, 100);
    //PIDTimer.attach_us(&PID_LeftIR, 100);

    while (1)
    {
        #ifdef DEBUG
        serial.printf("%f\n", debugVar);
        //serial.printf("Right:%f, Left:%f, RightDia: %f, LeftDiag: %f\r\n", IR_Right_val, IR_Left_val, IR_Right_Diagonal_val, IR_Left_Diagonal_val);
        #endif

        BangBang_LeftIR();
        if(IsFrontWall())
        {
            Motor_R_Fwd = 0.0f;
            Motor_L_Fwd = 0.0f;
            backupToCenter();  
            turnRight(); 
        }
        
        wait(delay);
    }
}