#include "mbed.h"
#include "QEI.h"
#include "basics.h"
Ticker Systicker;
Serial pc(PA_11, PA_12); // setting up RX TX

DigitalOut led_red(PB_12);
DigitalOut led_blue(PB_13);

AnalogIn   LMR(PC_5);
DigitalOut LME(PC_7);
AnalogIn   ULR(PC_4);
DigitalOut ULE(PB_0);
AnalogIn   URR(PC_1);
DigitalOut URE(PB_1);
AnalogIn   RMR(PC_0);
DigitalOut RME(PC_6);

PwmOut Motor_LF(PA_6);
PwmOut Motor_LB(PA_7);
PwmOut Motor_RF(PB_6);
PwmOut Motor_RB(PB_7);

QEI MLEncoder (PA_0, PA_1, NC, 12); //left encoder
QEI MREncoder (PA_3, PA_2, NC, 12); //right encoder
//general
double speed = 0.09;
double speed_right = speed * 0.860;
double pulsePerInch = 700;
bool PID_enable=false;

//encoders
double encode1, encode2;
double ML_pulse, MR_pulse, MR_prev_pulse, ML_prev_pulse;
double encoderDif, integral=0;
double P_value = 0.000000001838;
double I_value = 0.0000;

//IRs
double leftIR, rightIR, upperRIR, upperLIR;
double kp_IR=0.000005;
double IR_dif, IR_intgral;

//Flags
bool stuck_flag = 0;

void systick() // PID
{
    MR_prev_pulse = MR_pulse;
    ML_prev_pulse = ML_pulse;
    ML_pulse = abs(MLEncoder.getPulses());
    MR_pulse = (abs(MREncoder.getPulses())/1.125);
    //MR_pulse = abs(MREncoder.getPulses());

    if ((abs(ML_pulse - ML_prev_pulse) < 1000) &&(abs(MR_pulse - MR_prev_pulse ) < 1000)) {
        stuck_flag = 1;
    }


    if (!PID_enable) return;
    if (IR_dif > -0.20 && IR_dif < 0.20) {
        Motor_LF = speed;
        Motor_RF = speed_right;
    } else {
        Motor_LF = Motor_LF + kp_IR* IR_dif;
        Motor_RF = Motor_RF - kp_IR* IR_dif ;
    }


}
////////////////////////////////////////////////////////////////////////////
///////////////////// STOP AND GO ////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
void proceed()
{
    PID_enable = true;
    Motor_LF = speed;
    Motor_LB = 0;
    Motor_RF = speed_right;
    Motor_RB = 0;
}
void all_motor_off()
{
    Motor_LF = 0;
    Motor_LB = 0;
    Motor_RF = 0;
    Motor_RB = 0;
}
void stop()
{
    PID_enable = false;
    led_red = 1;

    Motor_LF =0;
    Motor_LB =speed;
    Motor_RF =0;
    Motor_RB =speed_right;
    wait (0.03);
    all_motor_off();
    wait (0.02);

}
void travelNCell(double N )
{
    MLEncoder.reset();
    MREncoder.reset();

    while (MLEncoder.getPulses() < N*3000 && MREncoder.getPulses() < N*3000 ) {
        Motor_LF = speed;
        Motor_LB = 0;
        Motor_RF = speed_right;
        Motor_RB =0;
    }
}

////////////////////////////////////////////////////////////////////////////
/////////////////////TURNING ////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

void turnLeft()
{
    PID_enable = false;
    MLEncoder.reset();
    MREncoder.reset();

    while (MREncoder.getPulses() < 520 ) {
        Motor_LF = 0;
        Motor_LB = speed;
        Motor_RF = speed_right;
        Motor_RB = 0;
    }

    all_motor_off();
    // wait (0.5);
    PID_enable = true;
}
void turnRight(double N = 1) // in case if want to turn 180, pass in N = 2.5
{
    PID_enable = false;
    MLEncoder.reset();
    MREncoder.reset();

    while (MLEncoder.getPulses() < 650 * N ) {
        Motor_LF = speed;
        Motor_LB = 0;
        Motor_RF = 0;
        Motor_RB = speed;

    }
    all_motor_off();
    wait (0.5);
    PID_enable = true;
    proceed();
}

////////////////////////////////////////////////////////////////////////////
///////////////////// SENSORS ////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
void getEncoderValue()
{
    ML_pulse = abs(MLEncoder.getPulses());
    MR_pulse = (abs(MREncoder.getPulses())/1.125); // Right encoder is 1.125 time faster
    encoderDif = abs (ML_pulse - MR_pulse);
    // pc.printf ("\n%f\t%f", ML_pulse,MR_pulse);
    //pc.printf("\n%f",(ML_pulse - MR_pulse));
    //integral = integral + encoderDif;

}

void getSensorValue()
{
    RME=1;
    rightIR=RMR.read();
    LME=1;
    leftIR=LMR.read();
    URE=1;
    upperRIR=URR.read();
    ULE=1;
    upperLIR=ULR.read();
    IR_dif = leftIR - rightIR -0.15;
   // pc.printf("\n\n%f\n%f\n%f\n%f\n%f", leftIR,upperLIR, upperRIR,rightIR,IR_dif );
//    wait (0.5);
}

////////////////////////////////////////////////////////////////////////////
///////////////////// SPEED AND WALL ////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
void checkSpeed()
{
    if (Motor_LF >( speed+0.1) || Motor_RF > (speed_right + 0.10)) {
        Motor_LF = speed;
        Motor_RF = speed_right;
    } else if (Motor_LF >( speed-0.1) || Motor_RF > (speed_right -0.10)) {
        Motor_LF = speed;
        Motor_RF = speed_right;
    }
}

bool checkDeadEnd()
{
    if (upperRIR >0.40 &&  upperLIR > 0.40 && rightIR > 0.17 && leftIR >0.17 ) {
        PID_enable = false;

        Motor_LF =0;
        Motor_LB =speed;
        Motor_RF =0;
        Motor_RB =speed_right;
        wait (0.1);
        all_motor_off();
        wait (0.02);
        turnRight(2.5);  // truns out it takes more to do 180
        PID_enable = true;
        return true;
    }
    return false;

}

bool ifFrontWall()
{
    if (upperRIR >0.40 &&  upperLIR > 0.40) {
        PID_enable = false;

        Motor_LF =0;
        Motor_LB =speed;
        Motor_RF =0;
        Motor_RB =speed;
        wait (0.03);
        all_motor_off();
        wait (0.02);
        PID_enable = true;
        return true;
    }
    return false;
}



void goThroughMaze()
{
    if (ifFrontWall()) {
        if (rightIR < 0.1)
            turnRight();
        else if (leftIR < 0.1)
            turnLeft();
        else
            stop(); // if it goes to a deadend then stop
    }
}


void wallFollower()
{
    if (rightIR < 0.05) {
        stop();
        wait(1);
        travelNCell(0.5);
        all_motor_off();
        wait (1);
        turnRight();
    }
    checkDeadEnd();
}

void checkIfStuck()
{
    if ( ! stuck_flag ) return;
    if (MR_pulse < 1000 && ML_pulse < 1000) return;

    //MLEncoder.reset();
    //MREncoder.reset();
    PID_enable = 0;
    Motor_LF = 0;
    Motor_LB = speed;
    Motor_RF = 0;
    Motor_RB = speed_right;
    
    wait(3);
    //while (abs(MREncoder.getPulses()) < 520 && abs(MLEncoder.getPulses()) < 520 ) {
//        Motor_LF = 0;
//        Motor_LB = speed;
//        Motor_RF = 0;
//        Motor_RB = speed_right;
//    }

    all_motor_off();
    wait(5);
    proceed();
    stuck_flag =0;
    PID_enable = 1;
}


////////////////////////////////////////////////////////////////////////////
///////////////////// MAIN ////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

int main()
{
    Motor_LF = speed;
    Motor_LB = 0;
    Motor_RF = speed_right;
    Motor_RB = 0;
    MLEncoder.reset();
    MREncoder.reset();
    Systicker.attach_us(&systick, 100);
    led_red = 0;
    while (1) {
        //pc.printf ("\n\nEncoder Pulses:\n""Encoder left:%d Encoder right: %d", MLEncoder.getPulses(), MREncoder.getPulses());
        PID_enable = 1;
        //getEncoderValue();
        getSensorValue();

        wallFollower();


        //checkIfStuck();

        //while(1){
//            PID_enable = 1;
//            all_motor_off();
//            travelNCell(1);
//            all_motor_off();
//            wait(1);
//
//            }




    }
}