#include "mbed.h"
#include "TextLCD.h"
#include "Rtc_Ds1307.h"

Rtc_Ds1307 rtc(PTE0, PTE1);
DigitalOut red(LED1);
DigitalOut tog(PTE3);
TextLCD lcd(PTE30, PTE29, PTE23, PTE22, PTE21, PTE20); // rs, e, d4-d7
DigitalIn pin(PTA1); //button
Serial pc(USBTX, USBRX);
Rtc_Ds1307::Time_rtc tim = {};
PwmOut boop(PTD4); //alarm buzzer
Timer t;

void displayTime();
int setAlrm(bool ho);
bool hitIt(int hor, int min, Rtc_Ds1307::Time_rtc teim);

int Halrm = -1;
int Malrm = 0; 


int main() {
    
    tog.write(1);
    boop.write(0); //initialise buzzer
    boop.period(5);
    
    Ticker cloo; //declare a ticker to update clock every sec
    cloo.attach(&displayTime, 1); //the ticker runs the function that wipes the screen and displays the updated time
    
    rtc.startClock(); 
    
    while(1){
        
        wait_ms(50); //wait so button states do not overlap
        
        if(pin.read()){                     //once it's 1 start the detection loop to decide whether this is a hold or a double click
            
            cloo.detach();                  //stop the ticker while performing button operations
            
            t.reset();                     
            t.start();                      //start timer
            
            while(t.read() < 1){            //if it's not unpressed in a second - HOLD case
                                    
                if(!pin.read()){            //if it goes low, check for double click
                
                    t.reset();
               
                    while(t.read() < 1){      //listen for 1 sec for a second click
                    
                        if(pin.read()){          //if x = 1 execute DOUBLE CLICK - set alarm
                            lcd.cls();
                            lcd.printf("settin' alarm!");
                            wait(2);
                            
                            Halrm = setAlrm(true);
                            if(Halrm >= 0){
                                Malrm = setAlrm(false);
                                lcd.cls();
                                lcd.printf("Alarm: %d:%d", Halrm,Malrm);
                                wait(2);
                            }
                            break;
                        }
                    }
                break;
            }
        }
        
        
        
        while(pin.read()){                  //still pressed? Execute Button HOLD case, exit hold when no longer held
            
            rtc.getTime(tim);
            
            lcd.cls();
            lcd.printf("Today is the :\n%02d/%02d/%02d", tim.date, tim.mon, tim.year); //display date 
            wait(1);
            
        }
            
         cloo.attach(&displayTime, 1);      //re-enable ticker after date release   
         
    }
        
    t.stop();
    
    }
    
}

void displayTime(){ //get the time from the rtc chip and display it on the LCD
    
    Rtc_Ds1307::Time_rtc tm = tim;
    
    if (rtc.getTime(tm) ) {
        lcd.cls();
        lcd.printf("The time is :\n%02d:%02d:%02d", tm.hour, tm.min, tm.sec);   //display time
        
        if(hitIt(Halrm, Malrm, tm)){        //check if the time is right for alarmage 
            boop.write(0.5);
            while(!pin.read()){
                lcd.cls();
                lcd.printf("You should be alarmed");
                wait(0.2);
            }
            boop.write(0);
        }
        
    }
     red = !red;   
}
    
int setAlrm(bool ho){
    
    int mod;
    float spd;
    if(ho){  
        mod = 24;
        spd = 0.5;
    }else{
        mod = 60;
        spd = 0.25;
    }
    
    int homin = 0;
    bool sat = false;    
    bool DC = false;
    
    while(!sat){
    
        while(!pin.read() && !sat){
            
            lcd.cls();
            if(ho) lcd.printf("Hour: %02d\nDC to confirm", homin);
            else lcd.printf("Minutes: %02d\nDC to confirm", homin);
            
            wait(0.2);
                if(pin.read()){                     //once it's 1 start the detection loop to decide whether this is a hold or a double click
            
                t.reset();                     
                t.start();                      //start timer
            
                while(t.read() < 1){            //if it's not unpressed in a second - HOLD case
                                    
                    if(!pin.read()){            //if it goes low, check for double click
                
                    t.reset();
               
                    while(t.read() < 1){      //listen for 1 sec for a second click
                    
                        if(pin.read()){          //if x = 1 execute DOUBLE CLICK - confirm selection
                            lcd.cls();
                            if(ho) lcd.printf("Hour: %02d\nSet!", homin);
                            else lcd.printf("Minutes: %02d\nSet!", homin);
                            sat = true;
                            DC = true; 
                            wait(2);
                            break;
                        }
                    }
                break;
            }
        }
            if(!pin.read() && !DC){        //if unpressed - single click detected - cancel alarm
                lcd.cls();
                lcd.printf("Alarm Canceled!");
                homin = -1;
                return homin;
            }
            
            while(pin.read()){                  //still pressed? Execute Button HOLD case, exit hold when no longer held
            
                homin = (homin + 1)%mod;        //increment the value while the button is held
                lcd.cls();
                if(ho) lcd.printf("Hour: %02d", homin);
                else lcd.printf("Minutes: %02d", homin); 
                wait(spd);
            
            }      
        }       
        }
        
    }
    
    return homin;
}

//this function checks whether it's time to sound the alarms
//if the minute and the hour is the same as that of the alarm, return true
bool hitIt(int hor, int min, Rtc_Ds1307::Time_rtc teim){
    int x = teim.hour - hor;
    if(x == 0){
        int y = teim.min - min;   
        if(y == 0){
            return true;
        }
    }
        return false;    
}