//Rango says, hey there Connnor!

#include "mbed.h"

DigitalOut led(LED1);
AnalogIn Ain(PTB1);

int const MAX_B = 10;
int const alpha = 0.5;
int const AVG_LEN = 160;
float const DISP_MAX = 7; //size of display indexed from 0
float const trigger_high = DISP_MAX/2 + 1;
float const trigger_low = DISP_MAX/2 - 1;

int sample_buffer[2*MAX_B] = {};
int local_buffer[2*MAX_B] = {};
int avg_buffer[AVG_LEN] = {};
int read = 0;
int write = 0;

int avg_write = 0;

int avg_sum;
bool first;
float avg;
float pre_point;

bool rising = false;

Ticker sampler;

void sampling () {  //Sample Signal
    unsigned int sample = Ain.read_u16();
    sample_buffer[write++] = sample;
    write = write%(2*MAX_B);
    
}

float min_of_avg(){
    int min = avg_buffer[0];
    for (int i = 0; i < AVG_LEN; i++){
        if (avg_buffer[i] < min){
            min = avg_buffer[i];
        }
    }
    return min;
}

float max_of_avg(){
    int max = avg_buffer[0];
    for (int i = 0; i < AVG_LEN; i++){
        if (avg_buffer[i] > max){
            max = avg_buffer[i];
        }
    }
    return max;
}

float normalise(float point) {  //Normalise the value
    float avg_min = min_of_avg();
    return (DISP_MAX * (point / (max_of_avg() - avg_min)) + avg_min);
}

float filter (float output) {  //Filter signal digtally to make more precise
    float point = alpha*output + (1- alpha)*pre_point;
    point = normalise(point);
    return point;
}

float average(){
    float point;
    avg = avg_sum/AVG_LEN;
    int normalised = avg_buffer[avg_write-1] - avg;
    point = filter(normalised);
    
    return point;
    
    
}

bool above_trig_low(float point){
    if(point <= trigger_low){
        rising = false;
        return true;
    }
    return false;
}

bool above_trig_high(float point){
    if(point >= trigger_high){
        rising = true;
        return true;
    }
    return false;
}

void identify_pulse(float point) {
    // Implementation of hysteresis
    if(rising){
        if (!above_trig_low(point)){
            led = 1;
        } else {
            led = 0;
        }
    } else if (!rising){
        if (!above_trig_high(point)){
            led = 0;
        } else {
            led = 1;
        }
    }
}

float data_process() {  //Setup for data process
   float point ;
    if (first) {
        for (int i =0; i <MAX_B; i++) {
            int data = local_buffer[i];
            avg_buffer[avg_write] = data;
            avg_write = (++avg_write) % AVG_LEN;
            avg_sum += data;
        }
        if (avg_write == 0) {
            first = false;
            pre_point = local_buffer[MAX_B - 1];
        }
    }
    else {
        for (int i =0; i <MAX_B; i++) {
            int data = local_buffer[i];
            avg_sum = avg_sum + data - avg_buffer[avg_write];
            
            avg_buffer[avg_write] = data;
            avg_write = (++avg_write) % AVG_LEN;
            pre_point = point;
            point = average();
            identify_pulse(point);
        }
    }
    return point;  //The tenth point
        
}

void write_to_display(float output) {
}

int main() {
    sampler.attach(&sampling, 0.0125); //Sample at 80Hz 
    
    while(1) {
        if (write-read > MAX_B || read-write > MAX_B) {   // |write-read| > MAX_B/2
            for(int i = 0; i < MAX_B/2; i++) {
                local_buffer[i] =  sample_buffer[read];
                read = (++read) % MAX_B;
            }
        }
        float output = data_process();
        
        write_to_display(output);
    }
}



