#include "mbed.h"

#define max7219_reg_noop         0x00
#define max7219_reg_digit0       0x01
#define max7219_reg_digit1       0x02
#define max7219_reg_digit2       0x03
#define max7219_reg_digit3       0x04
#define max7219_reg_digit4       0x05
#define max7219_reg_digit5       0x06
#define max7219_reg_digit6       0x07
#define max7219_reg_digit7       0x08
#define max7219_reg_decodeMode   0x09
#define max7219_reg_intensity    0x0a
#define max7219_reg_scanLimit    0x0b
#define max7219_reg_shutdown     0x0c
#define max7219_reg_displayTest  0x0f

#define LOW 0
#define HIGH 1

Serial pc(USBTX,USBRX);

SPI max72_spi(PTD2, NC, PTD1);
DigitalOut load(PTD0); //will provide the load signal

int const NUM_COLS = 8;
char pattern[NUM_COLS] = { 0x00, 0x18, 0x3c, 0x7e, 0xff,0xe7, 0x42, 0x00};

void write_to_max( int reg, int col)
{
    load = LOW;            // begin
    max72_spi.write(reg);  // specify register
    max72_spi.write(col);  // put data
    load = HIGH;           // make sure data is loaded (on rising edge of LOAD/CS)
}

void setup_dot_matrix ()
{
    // initiation of the max 7219
    // SPI setup: 8 bits, mode 0
    max72_spi.format(8, 0);
     
  
  
    max72_spi.frequency(100000); //down to 100khx easier to scope ;-)
      

    write_to_max(max7219_reg_scanLimit, 0x07);
    write_to_max(max7219_reg_decodeMode, 0x00);  // using an led matrix (not digits)
    write_to_max(max7219_reg_shutdown, 0x01);    // not in shutdown mode
    write_to_max(max7219_reg_displayTest, 0x00); // no display test
    for (int e=1; e<=8; e++) {    // empty registers, turn all LEDs off
        write_to_max(e,0);
    }
   // maxAll(max7219_reg_intensity, 0x0f & 0x0f);    // the first 0x0f is the value you can set
     write_to_max(max7219_reg_intensity,  0x08);     
 
}

void clear(){
     for (int e=1; e<=8; e++) {    // empty registers, turn all LEDs off
        write_to_max(e,0);
    }
}

//writes 8 bytes to the display  
void pattern_to_display(char *testdata){
    int cdata; 
    for(int idx = 0; idx <= 7; idx++) {
        cdata = testdata[idx]; 
        write_to_max(idx+1,cdata);
    }
} 

int float_to_int(float flt){
    return (int) (flt + 0.5);
}

int main() {
    setup_dot_matrix ();      /* setup matric */
    pattern_to_display(pattern);
    wait_ms(5000);
    
    int temp_data[] = {7,6,4,2,1,3,5,6};
    
    int data_index = 0;
    int data ;
    int prev_data = 0;

    while (1){
        
        data = temp_data[data_index];
        
         for (int j = 0; j < NUM_COLS; j++){
            pattern[j] = pattern[j]<<1;
        }
        
        
        //Create line based on various conditions
        if (data < prev_data) {
            for (int i = data; i < prev_data; i++) {
            pattern[i] = pattern[i] + 0x01;
            }
        }
        
        else if ( data > prev_data) {
            for (int i = prev_data+1; i <= data; i++) {
            pattern[i] = pattern[i] + 0x01;
            }
        }
        
        else {
            pattern[data] = pattern[data] + 0x01;
        }
        
        
        pattern_to_display(pattern);
        prev_data = data;
        wait_ms(125);
        data_index = ++data_index % NUM_COLS;
        

        //for (int j = 0; j < NUM_COLS; j++){
//            pattern[j] = pattern[j]<<1;
//        }
//        data = temp_data[data_index];
//        
//        for (int i = 0; i <= data; i++) {
//            pattern[i] = pattern[i] + 0x01;
//        }
//        
//        pattern_to_display(pattern);
//        wait_ms(125);
//        data_index = ++data_index % NUM_COLS;
    }
}