#include "mbed.h"

#define max7219_reg_noop         0x00
#define max7219_reg_digit0       0x01
#define max7219_reg_digit1       0x02
#define max7219_reg_digit2       0x03
#define max7219_reg_digit3       0x04
#define max7219_reg_digit4       0x05
#define max7219_reg_digit5       0x06
#define max7219_reg_digit6       0x07
#define max7219_reg_digit7       0x08
#define max7219_reg_decodeMode   0x09
#define max7219_reg_intensity    0x0a
#define max7219_reg_scanLimit    0x0b
#define max7219_reg_shutdown     0x0c
#define max7219_reg_displayTest  0x0f

#define LOW 0
#define HIGH 1

//Testing 
Serial pc (USBTX, USBRX);

SPI max72_spi(PTD2, NC, PTD1);
DigitalOut load(PTD0); //will provide the load signal

int const NUM_COLS = 8;
//char pattern[NUM_COLS*2] = { 0x00, 0x18, 0x3c, 0x7e, 0xff,0xe7, 0x42, 0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x01,};
char pattern[NUM_COLS] = { 0x00, 0x18, 0x3c, 0x7e, 0xff,0xe7, 0x42, 0x00};
int symbols[10] = {0x3e413e, 0x217f01, 0x474931, 0x2a4936, 0x1c247f, 0x71514e, 0x1e2946,0x474870,0x364936,0x32493e};

void write_to_max( int reg, int col)
{
    load = LOW;            // begin
    max72_spi.write(reg);  // specify register
    max72_spi.write(col);  // put data
    load = HIGH;
}

void setup_dot_matrix ()
{
    // initiation of the max 7219
    // SPI setup: 8 bits, mode 0
    max72_spi.format(8, 0);
     
  
  
    max72_spi.frequency(100000); //down to 100khx easier to scope ;-)
      

    write_to_max(max7219_reg_scanLimit, 0x07);
    write_to_max(max7219_reg_decodeMode, 0x00);  // using an led matrix (not digits)
    write_to_max(max7219_reg_shutdown, 0x01);    // not in shutdown mode
    write_to_max(max7219_reg_displayTest, 0x00); // no display test
    for (int e=1; e<=8; e++) {    // empty registers, turn all LEDs off
        write_to_max(e,0);
    }
   // maxAll(max7219_reg_intensity, 0x0f & 0x0f);    // the first 0x0f is the value you can set
     write_to_max(max7219_reg_intensity,  0x08);     
 
}

void clear(){
     for (int e=1; e<=8; e++) {    // empty registers, turn all LEDs off
        write_to_max(e,0);
    }
}

//writes 8 bytes to the display  
void pattern_to_display(char *testdata){
    int cdata;
    for(int idx = 0; idx < 8; idx++) {
        cdata = testdata[idx];
        write_to_max(idx+1,cdata);
    }
} 

void get_num_pattern(int data) {
    int unit = data%10;
    data = data - unit;
    int ten = data%100;
    data = data-ten;
    int hundred = data%1000;
    
    int sym1 = symbols[unit];
    int sym2 = symbols[ten];
    int sym3 = symbols[hundred];
    
    char int_pattern[NUM_COLS] = {0x00, (sym1>>16), (sym1>>8 &0x00FF), (sym1&0x0000FF), 0x00, (sym2>>16), (sym2>>8 &0x00FF), (sym2&0x0000FF)};
    
    pattern_to_display(int_pattern);

}
    
   
    

int main() {
    setup_dot_matrix ();      /* setup matric */
    pattern_to_display(pattern);
    wait_ms(5000);
    
    int temp_data[] = {12,34,56,78,90,87,65,43,21};
    
    int data_index = 0;
    int data ;
    int prev_data = 0;

    while (1){
        
       data = temp_data[data_index];
       get_num_pattern(data);
       wait(1);
       data_index = ++data_index % NUM_COLS;
   }
}