#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "fonctions.h"
#include "image.h"


void AfficheImage(uint32_t Xpos, uint32_t Ypos, uint32_t Largeur, uint32_t Hauteur, const unsigned long *img){

    uint8_t i=0;
    uint8_t j=0;
    for (i=0; i<=Hauteur; i++){
        for (j=0; j<= Largeur; j++){
            
            BSP_LCD_DrawPixel(Xpos + j, Ypos + i, img[j + i*Largeur] + 0xFF000000); //j + i*Largeur
        }
        
    }
   
    }

void Page1()
{
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"Page1", CENTER_MODE);
}


void Page2()
{
    BSP_LCD_Clear(LCD_COLOR_ORANGE);
    BSP_LCD_SetBackColor(LCD_COLOR_GREEN);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"Page2", CENTER_MODE);

}

void Bienvenue()
{
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"Bienvenue", CENTER_MODE);
    
    AfficheImage(10, 10, 200, 124, image);
    
}

void AfficherPage(int NumeroPage)
{

    switch(NumeroPage) {
        case 0 :
            Bienvenue();
            
            break;
        case 1 :
            Page1();

            break;
        case 2 :
            Page2();
            printf("Affichage page %d\n", NumeroPage);
 
            break;

        //case 4 :
        //    printf("Affichage page %d\n", NumeroPage);
        //    break;
        default :
            PageErreur();
            printf("erreur appel AfficherPage %d", NumeroPage);

    }
}

void PageErreur(){
    BSP_LCD_Clear(LCD_COLOR_BLUE);
    BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"ERREUR", CENTER_MODE);
    }