#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "fonctions.h"
 
void Page1()
{
    BSP_LCD_Init(); //initialise l'écran LCD
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);

    BSP_LCD_Clear(LCD_COLOR_BLACK); //reset l'écran en fond noir
    BSP_LCD_SetFont(&LCD_DEFAULT_FONT);
    BSP_LCD_SetBackColor(LCD_COLOR_BLACK);//fond de l'écriture en noir
    BSP_LCD_SetTextColor(LCD_COLOR_ORANGE); //couleur de l'écriture 
    BSP_LCD_DisplayStringAt(0, 135, (uint8_t *)"BIENVENUE", CENTER_MODE); //affichage de BIENVENUE
    
    BSP_LCD_Clear(LCD_COLOR_BLACK);
    BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
    BSP_LCD_FillRect(4, 4, 138, 129); 
    BSP_LCD_SetTextColor(LCD_COLOR_BROWN);
    BSP_LCD_FillRect(146, 4, 138, 129);
    BSP_LCD_SetTextColor(LCD_COLOR_YELLOW);
    BSP_LCD_FillRect(288, 4, 138, 129);
    BSP_LCD_SetTextColor(LCD_COLOR_RED);
    BSP_LCD_FillRect(4, 137, 138, 129); 
    BSP_LCD_SetTextColor(LCD_COLOR_ORANGE);
    BSP_LCD_FillRect(146, 137, 138, 129);
    BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
    BSP_LCD_FillRect(288, 137, 138, 129);
        
    BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
    BSP_LCD_FillRect(435, 5, 45, 50); 
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_FillRect(435, 65, 45, 65);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_FillRect(435, 137, 45, 65);
    BSP_LCD_SetTextColor(LCD_COLOR_BROWN);
    BSP_LCD_FillRect(435, 215, 45, 50); 
}
 
 
void Page2()
{
    BSP_LCD_Clear(LCD_COLOR_ORANGE);
    BSP_LCD_SetBackColor(LCD_COLOR_GREEN);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"Page2", CENTER_MODE);
 
}
 
void Bienvenue()
{
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"Bienvenue", CENTER_MODE);
}
 
void AfficherPage(int NumeroPage)
{
 
    switch(NumeroPage) {
        case 0 :
            Bienvenue();
            
            break;
        case 1 :
            Page1();
 
            break;
        case 2 :
            Page2();
            printf("Affichage page %d\n", NumeroPage);
 
            break;
 
        //case 4 :
        //    printf("Affichage page %d\n", NumeroPage);
        //    break;
        default :
            PageErreur();
            printf("erreur appel AfficherPage %d", NumeroPage);
 
    }
}
 
void PageErreur(){
    BSP_LCD_Clear(LCD_COLOR_BLUE);
    BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"ERREUR", CENTER_MODE);
    }

    
        
    