//Found on Jim Hamblen's Solenoid Notebook page at https://developer.mbed.org/users/4180_1/notebook/an-introduction-to-solenoids/

#ifndef __SOLENOID_H__
#define __SOLENOID_H__

#include "mbed.h"

class Solenoid
{
public:
    Solenoid (PinName pin, float onTime=0.25, float onDelay=0.095);
    void write(bool state);
    Solenoid& operator= (bool value);
 
private:
    void Solenoid_Off_Int();
    void Solenoid_On_Int();
    DigitalOut _pin;
    Timeout tint;
    Timeout tondelay;
    float ontime;
    float delaytime;
};
Solenoid::Solenoid(PinName pin, float onTime, float onDelay) : _pin(pin), ontime(onTime), delaytime(onDelay)
{
    _pin=0;
 
}
void Solenoid::Solenoid_Off_Int()
{
    _pin=0;//OFF timer interrupt routine to auto turn off solenoid
}
void Solenoid::Solenoid_On_Int()
{
    _pin = 1;
    tint.attach(this,&Solenoid::Solenoid_Off_Int,ontime);//setup a timer interrupt for on time
}
void Solenoid::write(bool value)
{
    if (value!=0) {//ON so do auto off with timer interrupt
        tondelay.attach(this,&Solenoid::Solenoid_On_Int,delaytime);
    } else
        _pin = value;//solenoid turned off with a write call (not timers)
}
Solenoid& Solenoid::operator= (bool value)
{
    write(value);
    return *this;
}

#endif /* __SOLENOID_H__ */