#include "mbed.h"
#include "Regrind.h"
#include "RioRandHBridge.h"
#include "Solenoid.h"

#define OG1_TO_OG2_DIST 1
#define OG1_TO_OG3_DIST 2
#define SOLENOID_ON_TIME 0.125
#define SOLENOID_ON_DELAY 0.087
#define LED_ON_TIME 0.5
#define LED_ON_DELAY SOLENOID_ON_DELAY
#define REGRIND_ARRAY_SIZE 1
#define THRESHOLD 0.02
#define RETURN_THRESHOLD 0.01

Solenoid led1(LED1, LED_ON_TIME, LED_ON_DELAY); //Used as 1pps out indicator
Solenoid led2(LED2, LED_ON_TIME, LED_ON_DELAY);
Solenoid led3(LED3, LED_ON_TIME, LED_ON_DELAY);
Solenoid led4(LED4, LED_ON_TIME, LED_ON_DELAY);
DigitalOut onePPS_out(p29);
Solenoid solenoid(p30, SOLENOID_ON_TIME, SOLENOID_ON_DELAY); //Solenoid (PinName pin, float onTime=0.25, float onDelay=0.095);
RioRandHBridge augerMotors(p21, p25, p22, p23); //RioRandHBridge( PinName pinPwm1, PinName pinDir1, PinName pinPwm2, PinName pinDir2);
DigitalIn reverseMotor1pb(p26);
DigitalIn reverseMotor2pb(p24);
AnalogIn topMotorAdjuster(p19);
DigitalOut bottomMotorAdjuster(p16,0);
DigitalOut unused1(p17,0);
AnalogIn og1(p16);
AnalogIn og2(p20);
DigitalOut og3(p18,0);
InterruptIn divertParticle(p5);
Timer totalT;
DigitalOut startColor(p6);
//DigitalIn redColor(p5);
DigitalIn blueColor(p7);
DigitalIn greenColor(p8);
//Ticker 1pps;

Serial pc(USBTX,USBRX); //used for debugging

float og1Threshold = 0.3;
float og2Threshold = 0;
float og3Threshold = 0;
int   og1Oneshot = 0;
int   og2Oneshot = 0;
int   og3Oneshot = 0;
float og1_adc = 0;
float og2_adc = 0;
float og3_adc = 0;
int   og1Ndx = 0;
int   og2Ndx = 0;
int   og3Ndx = 0;
float og1_min = 0;
float og1_max = 2.7;
float og2_min = 0;
float og2_max = 0;
float og3_min = 0;
float og3_max = 0;
float og1_calibration = 0;
float og2_calibration = 0;
float og3_calibration = 0;

Regrind regrindArray[REGRIND_ARRAY_SIZE];
/*
void flip(){
    led1 = !led1;
    1pps_out = !1pps_out;
    }
*/
void divert(){
    regrindArray[og2Ndx].divert = 1;
    led3 = 1;
    }
void reverseMotor1(){
    augerMotors.Dir1 = !augerMotors.Dir1;
    }
void reverseMotor2(){
    augerMotors.Dir2 = !augerMotors.Dir2;
    }

int main() {
    //Start Clock
    totalT.start();
    //Setup Information
    /*
    led1 = 0;
    1pps_out = 0;
    1pps.attach(&flip, 1.0);
    */
    //Setup motors
    reverseMotor1pb.mode( PullUp );
    reverseMotor2pb.mode( PullUp );
    //reverseMotor1pb.attach_asserted( &reverseMotor1 );
    //reverseMotor2pb.attach_asserted (&reverseMotor2);
    augerMotors.setpwm1pulsewidth(0.0);
    augerMotors.setpwm2pulsewidth(0.0);
    augerMotors.motor1_ccw();
    augerMotors.motor2_ccw();
    
    //Spin up Motors until fluctuation of 10% seen
    
    
    //Calibrate the ADC
    //Done by spinning augers and measuring min and max then setting threshold as 0.9*(max-min) + min
    for(int i = 0; i<100;++i){
    og1_calibration += og1*3.3;
    og2_calibration += og2*3.3;
    }
    og1_calibration = og1_calibration/100;
    og2_calibration = og2_calibration/100;
    printf("og1_calibration value: %f\n\r",og1_calibration);
    printf("og2_calibration value: %f\n\r",og2_calibration);
    wait(3);
    
    divertParticle.rise(&divert);
    
    while(1) {
        /*
        if(redColor == 1){
            solenoid = 1; //actuate solenoid if red
            led1=1;
            }
            else {
            solenoid = 0; //actuate solenoid no matter what.
            led1=0;
            }
            */
        //Sample ADCs
        og1_adc = og1.read()*3.3;
        og2_adc = og2.read()*3.3;
        //og3_adc = og3.read()*3.3;
        //wait(0.01);
        //pc.printf("og1: %f og2: %f \n\r",og1_adc, og2_adc);

        if((og1_calibration - og1_adc > THRESHOLD) && (og1Oneshot != 1)){ //Something passed through og1
            og1Oneshot = 1;
            divertParticle.rise(&divert);
            //pc.printf("Regrind seen at OG 1 : %fV\n\r", og1_adc);
            led1 = 1;
            
            //Create Regrind
            regrindArray[og1Ndx%REGRIND_ARRAY_SIZE] = Regrind(totalT.read_us(), 1, 0, 0, 0, 0);
            startColor = 1;
            //wait(1);
        } //if(og1...)
        else if(og1_calibration - og1_adc < RETURN_THRESHOLD){ //Regrind has passed ok to reset og
            og1Oneshot = 0;
            
        }//else if(og1 ...)
        
        if((og2_calibration - og2_adc > THRESHOLD) && (og2Oneshot != 1)){
            og2Oneshot = 1;
            divertParticle.rise(NULL);
            regrindArray[og2Ndx%REGRIND_ARRAY_SIZE].setVelocity(OG1_TO_OG2_DIST);
            led2 = 1;
            if(regrindArray[og2Ndx].divert == 1){
            //wait_ms(95);
            solenoid = 1; //actuate solenoid if red
            led4 = 1;
            }
            else {
            //wait_ms(95);
            solenoid = 1; //Dont actuate if not red.
            led4 = 1;
            }
            regrindArray[og2Ndx].divert = 0; //reset divert flag
        }//if(og2..)
        else if(og2_calibration - og2_adc < RETURN_THRESHOLD){ //Regrind has passed ok to reset og
            og2Oneshot = 0;
            
        }//else if(og2 ...)
        /*
        if((og3_adc == 0) && (og3Oneshot != 1)){
            og3Oneshot = 1;
            led4 = 1;
            regrindArray[og3Ndx].setAcceleration(OG1_TO_OG3_DIST);
            if(regrindArray[og3Ndx].divert == 1){//Regrind has been selected to be diverted. Turn on solenoid.
                solenoid = 1;
            }
        }//if(og3..)
        else if(og3_adc == 1){ //Regrind has passed ok to reset og
            og3Oneshot = 0;
            
        }//else if(og3 ...)
        */
        /*
        //Check on 1pps clock
        if((totalT.read_us() % 2000000) < 1000000){
            led1 = 1;
            onePPS_out = 1;
        }
        else {//timer is in off cycle
            led1 = 0;
            onePPS_out = 0;
        }*/
        
        //Check if data writing flag is set - if so, write to SD card
        
        //Adjust PWM as necessary
        augerMotors.Dir1 = reverseMotor1pb;
        augerMotors.setpwm1pulsewidth(topMotorAdjuster.read());
        augerMotors.setpwm2pulsewidth(bottomMotorAdjuster.read());
        //pc.printf("top: %f bottom: %f\n\r",topMotorAdjuster.read(),bottomMotorAdjuster.read());
    } //while(1)
    totalT.stop();
}// int main()
