#include "mbed.h"
#include "Keypad.h"
#include <iostream>

//Ticker ticker;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
CAN can2(p30,p29); //p30(rx) and p29(tx)
CAN can1(p9, p10); //p9 (rx) and p10(tx)
CANMessage msg;
char counter = 0;

char Keytable[] = { '1', '2', '3', 'A', 
                    '4', '5', '6', 'B',   
                    '7', '8', '9', 'C',   
                    '*', '0', '#', 'D' };

uint32_t Index;
uint32_t cbAfterInput(uint32_t index) {
    Index = index;
    return 0;
}
    
int main() {
    //variables declared
    char mainLvl, partLvl;
    int toggle = 0;
    int squareToggle = 0;
    int digpotAmp = 0;
    Keypad::Keypad keypad(p21, p22, p23, p24, p25, p26, p27, p28, 20);
    keypad.attach(&cbAfterInput);
    keypad.start();
    
    Serial pc(USBTX, USBRX);
    
    while(1){
        pc.printf("This is the Black Box Tester input controller\r\n");
        pc.printf("Please select the desired command:\r\n");
        pc.printf("1. DAC Setup\r\n");
        pc.printf("2. Digital Potentiometer Setup\r\n");
        pc.printf("3. ADC Setup\r\n");
        pc.printf("\r\n");
        
        __wfi();
        mainLvl = Keytable[Index];
      
        switch(mainLvl)
        {
            case '1': // DAC Setup
            while(partLvl != '*')
            {
                 pc.printf("Please select the desired command:\r\n");
                 pc.printf("1. Enable DAC\r\n");
                 pc.printf("2. Disable DAC\r\n");
                 pc.printf("3. Toggle Sin 1 HZ wave\r\n");
                 pc.printf("4. Toggle Sin 10 HZ wave\r\n");
                 pc.printf("5. Toggle Square 1 HZ wave\r\n");
                 pc.printf("6. Toggle Square 10 HZ wave\r\n");
                 pc.printf("*: Please return to Main Menu\r\n");
                 pc.printf("\r\n");
                 __wfi();
                 partLvl = Keytable[Index];
               
                switch(partLvl)
                {
                    case '1':
                    counter = 5;
                    can1.write(CANMessage(1337, &counter, 1));
                    pc.printf("DAC Enabled\r\n");
                    pc.printf("\r\n");
                
                    break;
                    
                    case '2':
                    counter = 0;
                    can1.write(CANMessage(1337, &counter, 1));
                    pc.printf("DAC Disabled\r\n");
                    pc.printf("\r\n");
                 
                    break;
                    
                    case '3':
                     pc.printf("Sinusoid wave 1 HZ wave selected\r\n");
                     counter = 1;
                     can1.write(CANMessage(1337, &counter, 1));
                     toggle = 1;
                     break;
                    case '4':
                     pc.printf("Sinusoid wave 10 HZ wave selected\r\n");
                     counter = 3;
                     can1.write(CANMessage(1337, &counter, 1));
                     toggle = 10;
                     break;
                    case '5': 
                     pc.printf("Square wave 1 HZ wave selected\r\n");
                     counter = 2;
                     can1.write(CANMessage(1337, &counter, 1));
                     squareToggle = 1;
                     break;
                    case '6': 
                     pc.printf("Square wave 10 HZ wave selected\r\n");
                     counter = 4;
                     can1.write(CANMessage(1337, &counter, 1));
                     squareToggle = 10;
                     
                     break;
                     default:
                     break;
                    }         
            }
            partLvl = '0';
            break;
            
            case '2': // Digital Potentiometer Setup
            while(partLvl != '*')
            {
                 pc.printf("Please select the desired command:\r\n");
                 pc.printf("0. Set the Output Amplitude to 0 V\r\n");
                 pc.printf("1. Set the Output Amplitude to 1 V\r\n");
                 pc.printf("2. Set the Output Amplitude to 2 V\r\n");
                 pc.printf("3. Set the Output Amplitude to 3 V\r\n");
                 pc.printf("4. Set the Output Amplitude to 4 V\r\n");
                 pc.printf("5. Set the Output Amplitude to 5 V\r\n");
                 pc.printf("6. Increase Output Amplitude\r\n");
                 pc.printf("7. Decrease output Amplitude\r\n");
                 pc.printf("*: Please return to Main Menu\r\n");
                 pc.printf("\r\n");
                 __wfi();
                 partLvl = Keytable[Index];
                 //send(); // sends the CAN message 
                 switch(partLvl)
                {
                  case '0':
                  digpotAmp = 0;
                  pc.printf("Digital Potentiometer Amplitude: %d volts\r\n", digpotAmp);
                  
                  break;  
                  
                  case '1':
    
                  digpotAmp=1;
                  pc.printf("Digital Potentiometer Amplitude: %d volts\r\n", digpotAmp);
                  
                  break;  
                  
                  case '2':
              
                  digpotAmp=2;
                  pc.printf("Digital Potentiometer Amplitude: %d volts\r\n", digpotAmp);
                  
                  break;  
                  
                  case '3':
                
                  digpotAmp=3;
                  pc.printf("Digital Potentiometer Amplitude: %d volts\r\n", digpotAmp);
                  
                  break;  
                  
                  case '4':
               
                  digpotAmp=4;
                  pc.printf("Digital Potentiometer Amplitude: %d volts\r\n", digpotAmp);
                  
                  break;  
                  
                  case '5':
              
                  digpotAmp=5;
                  pc.printf("Digital Potentiometer Amplitude: %d volts\r\n", digpotAmp);
                  
                  break; 
                  
                  case '6':
                  digpotAmp ++;
                  if (digpotAmp == 6)
                  digpotAmp = 5;
                  pc.printf("Digital Potentiometer Amplitude: %d volts\r\n", digpotAmp);
                  break;  
                  
                  case '7':
                  digpotAmp --;
                  if (digpotAmp == -1)
                  digpotAmp = 0;
                  pc.printf("Digital Potentiometer Amplitude: %d volts\r\n", digpotAmp);
                  pc.printf("\r\n");
                  break;
    
                  default:
                  break;
                }
            }
            
              partLvl = '0';
              break;
              
            case '3': // ADC Setup
            {
             
             while(partLvl != '*') 
             {
                    pc.printf("Please select the desired subfunction\r\n");
                    pc.printf("1. Enable ADC\r\n");
                    pc.printf("2. Disable ADC\r\n");
                    pc.printf("*: Return to Main Menu\r\n");
                    pc.printf("\r\n");
                    __wfi(); 
                    partLvl = Keytable[Index];
                    //send(); // sends the CAN message
                    switch(partLvl)
                    {
                    
                    case '1':
                    counter = 1;
                    can1.write(CANMessage(1337, &counter, 1));
                    pc.printf("ADC Enabled\r\n");
                    pc.printf("\r\n");
                    break;
                    
                    case '2':
                    counter = 0;
                    can1.write(CANMessage(1337, &counter, 1));
                    pc.printf("ADC Disabled\r\n");
                    pc.printf("\r\n");
                    break;
                    
                    default:
                    break;
                    }
             } 
                partLvl = '0';
                break; 
            }
        }         
    }
}