// Joystick Library Example
//
// Reads the joystick x axis and fades green and red LEDs in response.
// The blue LED is turned on while the pushbutton is pressed.
 
#include "mbed.h"
#include <Joystick.h>
 
PwmOut led_R(LED1);
PwmOut led_G(LED2);
PwmOut led_B(LED3);
 
Joystick j(PTB0, PTB1, PTB2);
 
// call on joystick button release
void jrise(void) {
    led_B = 1.0f;
}
 
// call on joystick button press
void jfall(void) {
    led_B = 0.0f;
}
 
int main () {
    // setup
    led_R = 1.0f;
    led_G = 1.0f;
    led_B = 0.0f;
    joypos p;    // joystick position
    // attach joystick button interrupts
    j.rise(&jrise);
   j.fall(&jfall);
    float fade = 0.0f;
 
    // loop
    while (1) {
        p = j.read();
        fade = p.x;
        if (fade > 0.0) {
            led_R = 1.0f;
            led_G = 1.0f - (float)fade;
        } else if (fade < 0.0) {
            led_R = 1.0f + (float)fade;
            led_G = 1.0f;
        } else {
            led_R = 1.0f;
            led_G = 1.0f;
        }
        wait(0.01);
    }
}