#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"

class main {
public:
 
    main();
    /** Read the joystick position
     * The position is returned as a joypos value with x and y in the range [-1.0, 1.0].
     *
     * @returns Position structure of the joystick.
     */
    joypos read();

    /** Get the X position
     * Read the joystick's horizontal position, represented as a double value in the range [-1.0, 1.0].
     *
     * @returns Horizontal position of the joystick.
     */
    double getX();

    /** Get the Y position
     * Read the joystick's vertical position, represented as a double value in the range [-1.0, 1.0].
     *
     * @returns Vertical position of the joystick.
     */
    double getY();

    /** Get the raw X position
     * Read the joystick's raw horizontal position, represented as a double value in the range [0.0, 1.0].
     *
     * @returns Horizontal position of the joystick.
     */
    double getRawX();

    /** Get the raw Y position
     * Read the joystick's raw vertical position, represented as a double value in the range [0.0, 1.0].
     *
     * @returns Vertical position of the joystick.
     */
    double getRawY();

    /** Attach the rise interrupt
     * Attach a function pointer to call when a rising edge occurs on the button input.
     *
     * @param fptr Pointer to a void function. Set to NULL or 0 for none.
     */
    void rise(void (*fptr)(void));

    /** Attach the fall interrupt
     * Attach a function pointer to call when a falling edge occurs on the button input.
     *
     * @param fptr Pointer to a void function. Set to NULL or 0 for none.
     */
    void fall(void (*fptr)(void));

protected:
    AnalogIn _x;
    AnalogIn _y;
    InterruptIn _a;
};

#endif 
