#include "mbed.h"
#include "main.h"
#include "NOKIA_5110.h"
#include "char_object.h"
#include "Joystick.h"
 
// target is the KL25Z
#define PIN_JOYX PTB0    // A0
#define PIN_JOYY PTB1    // A1
#define PIN_JOYA PTB2
 
PwmOut led_R(LED1);
PwmOut led_G(LED2);
PwmOut led_B(LED3);
 
Joystick j(PIN_JOYX, PIN_JOYY, PIN_JOYA);
 
// call on joystick button release
void jrise(void) {
    led_B = 1.0f;
}
 
// call on joystick button press
void jfall(void) {
    led_B = 0.0f;
}

int main() {
    
    // setup: leds are off
    led_R = 1.0f;
    led_G = 1.0f;
    led_B = 1.0f;
    
    joypos p;    // joystick position
    // attach joystick button interrupts
    
    j.rise(&jrise);
    j.fall(&jfall);
    float fade = 0.0f;
    
/*  PinName mosi;
    PinName miso;
    PinName sclk;
    PinName dc;
    PinName sce;
    PinName rst;*/
    
    LcdPins myLcdPins = { PTC6, NC, PTC5, PTD2, PTD0, PTD3};
    NokiaLcd myLcd( myLcdPins);    // SPI is started here (8-bits, mode 1)
    myLcd.InitLcd();                // LCD is reset and DDRAM is cleared
    
    
//const bng_Width    = 14; actually 13, but in printing one column is somehow(?) lost
//const  bng_Height   = 32; multiple of 8 in order to adress lcd easier
//collision dimensions of bng: its x coordinate is (always topleft even with mirroring print) 
// x coordinate with y coordinate + h_adjusted but before jumping and crounching, we can use only x

char bng[] = {  
  0x00, 0x00, 0x00, 0x00, 0x80, 0xc0, 0xc0, 0xa0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x70, 0x88, 0xa4, 0xd7, 0x61, 0x04, 0xdb, 0xa0, 0x90, 0x68, 0x18, 0x00, 0x00,
  0x00, 0xf8, 0x07, 0x00, 0xe0, 0x20, 0x60, 0x87, 0x18, 0xe0, 0x00, 0x00, 0x00, 0x00,
  0x7c, 0xf3, 0x8c, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x38, 0xc7, 0xf8, 0x80, 0x00
};
 while(1)
    {
   myLcd.DrawBitmap(0,0,bng,14,32); //IMPORTANT: Y CAN BE [0-5] (6*8=48 PIXEL), also add one dummy column to compensate printing problem
      
        p = j.read();
        fade = p.x;
        if (fade > 0.0) {
            led_R = 1.0f;
            led_G = 1.0f - (float)fade;
        } else if (fade < 0.0) {
            led_R = 1.0f + (float)fade;
            led_G = 1.0f;
        } else {
            led_R = 1.0f;
            led_G = 1.0f;
        }
        wait(0.01);
    
        
    };
}

