#include "mbed.h"
#include "QMC5883L.h"
#define AVG_NUM 4

class Driver{
public:
    Driver(PinName speed_pin_R1, PinName direction_pin_R1,PinName speed_pin_R2, PinName direction_pin_R2,
    PinName speed_pin_L1,PinName direction_pin_L1,PinName speed_pin_L2, PinName direction_pin_L2) : 
    spd_R1(speed_pin_R1), dir_R1(direction_pin_R1), spd_R2(speed_pin_R2),dir_R2(direction_pin_R2), 
    spd_L1(speed_pin_L1), dir_L1(direction_pin_L1), spd_L2(speed_pin_L2), dir_L2(direction_pin_L2)
    {
        setup();
    }
        
    void setup() {
        spd_R1.period(0.005);
        spd_R2.period(0.005);
        spd_L1.period(0.005);
        spd_L2.period(0.005);
        dir=0;
    }
        
    void drive(float speed=1) {
        spd_L1=spd_L2=spd_R1=spd_R2=speed;
        dir_L1=dir_L2=dir_R1=dir_R2=0;
        dir=0;
    }
        
    void reverse(float speed=1) {
        spd_L1=spd_L2=spd_R1=spd_R2=1.0f-speed;
        dir_L1=dir_L2=dir_R1=dir_R2=1;
        dir=1;
    }
        
    void stop() {
        spd_L1=spd_L2=spd_R1=spd_R2=0;
        dir_L1=dir_L2=dir_R1=dir_R2=0;
    }
        
    void right(float speed=1) {
        dir_L1=dir_L2=dir_R1=dir_R2=dir;
        if(dir==0){
            spd_L1=spd_L2=speed;
            spd_R1=spd_R2=0;
        }
        else{
            spd_L1=spd_L2=1;
            spd_R1=spd_R2=1.0f-speed;
        }
        
    }
        
    void left(float speed=1) {
        dir_L1=dir_L2=dir_R1=dir_R2=dir;
        if(dir==0){
            spd_L1=spd_L2=0;
            spd_R1=spd_R2=speed;
        }
        else{
            spd_L1=spd_L2=1.0f-speed;
            spd_R1=spd_R2=1.0;
        }
        
    }
          
    void go(float speed=1) {
        if(dir==1){
            spd_L1=spd_L2=spd_R1=spd_R2=1.0f-speed;
            dir_L1=dir_L2=dir_R1=dir_R2=1;
        }
        else{
            spd_L1=spd_L2=spd_R1=spd_R2=speed;
            dir_L1=dir_L2=dir_R1=dir_R2=0;
        }
    }

private:
    PwmOut spd_R1;
    DigitalOut dir_R1;
    PwmOut spd_R2;
    DigitalOut dir_R2;
    PwmOut spd_L1;
    DigitalOut dir_L1;
    PwmOut spd_L2;
    DigitalOut dir_L2;
    int dir;
};

class Ultra {
public:
    Ultra(PinName echo_pin, PinName trig_pin) : echo(echo_pin), trig(trig_pin) {
        setup();
    }
        
    void tr() {
        echo_timer.start();
    }
        
    void tf() {
        echo_timer.stop();
    }
        
    void setup(float tt=25) {
        sound=((331.3f+0.606f*tt)/2)*0.0001f;//1e-4*BRZINA_ZVUKA/2
        repeat_count=0;
        echo.mode(PullDown);
        trig=0;
        echo.rise(callback(this, &Ultra::tr));
        echo.fall(callback(this, &Ultra::tf));
    }
        
    void trig_time() {
        trig=0;
    }
        
    float get_distance() {
        trig=1;
        trig_timeout.attach_us(callback(this, &Ultra::trig_time), 10);//dodati provjeru ludih brojeva 400+?
        echo_time=echo_timer.read_us();
        distance=echo_time*sound;
        echo_timer.reset();
        return distance;
    }

private:
    int repeat_count;
    InterruptIn echo;
    DigitalOut trig;
    Timer echo_timer;
    int echo_time;
    float distance;
    float sound;
    Timeout trig_timeout;
};

class Encoder {
public:
    Encoder(PinName pulse_pin) : pulse(pulse_pin) {
        pulse_prev=pulse;
    }
    
    int count_pulse() {
        pulse_now=pulse;
        if(pulse_now!=pulse_prev){
            pulse_num++;
            pulse_prev=pulse_now;
        }
        return pulse_num;
    }
    
    void clear_pulse() {
        pulse_num=0;
    }

private:
    int pulse_prev;
    DigitalIn pulse;
    int pulse_now;
    int pulse_num;
};

// PINs
Serial bt(PB_10, PC_5);
//Serial pc(PA_2, PA_3);
Driver motor(PB_3, PC_1, PA_10, PC_0, PB_4, PA_4, PB_5, PB_0);
Ultra senzor1(PC_10, PB_7);
Ultra senzor2(PC_12, PH_1);
Ultra senzor3(PA_1, PC_3);
Ultra senzor4(PC_9, PC_8);
Encoder tire_l(PC_11);
Encoder tire_r(PD_2);
InterruptIn wall_sensor(PC_6);
QMC5883L magnet(PB_9,PB_8);
DigitalOut magnet_reset(PA_12);

// Timers
Timeout senzor1_timeout;
Timeout senzor2_timeout;
Ticker compare_ticker;
Ticker encoder_ticker;
//Ticker magnet_ticker;// Ne radi

// Variables
float dist1,dist2,dist3,dist4;
int encoder_l, encoder_r;
int turn=0;
int wall_flag=0;
float temp;
double heading;
double x,y,z;
float all_data[360];
int data_flag=8;
int stop=0;
float dist_per_turn=0;
float return_data[5];
int wall_stop=0;
float car_len=26; //cm
int done=0;
int compare_flag=0;
//int AVG_NUM=4;
int ENC_NUM=1;
int start_everything=0;
int start_calculation=0;
int driving_done=0;

// Function prototypes
void measure1();
void measure2();
void measure_encoder();
void compare();
void move_distance(float len);
void find_closest_wall();
void parallel_to_wall();
void wall_sensor_rise();
void wall_sensor_fall();
void encoder_calibration(int num_of_cal);
void clear_encoder();
void rotation();
void move_to_corner();
void magnet_turn(float deg, char turn_dir);
void start_driving();
float check_for_bad(float *data,int size);
void set_zero_points();
void average_data();
void start_sequence();
void bt_control();

//Program za crtanje napisat.
//bt interupt control and print everything
// u kodu uvjet ako je encoder rl jako mali da se zanemari to provjeriti dal ce radit sa wall sensor
//u bt controle dodat isprobavanje raznih funkcija tipa move distance
//Moguci problem pozivanje float funkcije unuat void funkcije unutar timout elementa??


void measure1() {
    dist1=senzor1.get_distance();
    dist4=senzor4.get_distance();
    dist3=senzor3.get_distance();
    if(dist3<=40)compare_ticker.detach();
    senzor2_timeout.attach(&measure2,0.06);
}

void measure2() {
    dist2=senzor2.get_distance()-1.5f;
    dist3=senzor3.get_distance();
    /*Potrebno je ispraviti vrijednost senzora zbog pokazivanja krivih vrijednosti.
    Vrlo vjerojatno se radi o problemu sa samim senzorom.*/
    if(dist2<10)dist2*=0.9f;          
    if(dist3<=40)compare_ticker.detach();
    dist4=senzor4.get_distance();
    senzor1_timeout.attach(&measure1, 0.06);
}
        
void measure_encoder() {
    encoder_l=tire_l.count_pulse();
    encoder_r=tire_r.count_pulse();
}

void compare() {
    if(abs(dist1-dist2)<10) {
        compare_flag=0;
        if(dist1>(dist2+1)) {
            motor.left(0.75);
        }
        else if(dist1<(dist2-1)) {
            motor.right(0.75);
        }
        else {
            motor.go();
        }
    }
    else {
        /*compare_ticker.detach();
        motor.stop();
        wait(0.2);
        if(abs(dist2-dist1>10) && abs(dist2-dist1<100)) {
            compare_flag=1;
        }
        else if(dist2-dist1>100) {
            compare_flag=2;
        }
        else {
            compare_flag=0;
            compare_ticker.attach(&compare, 0.06);
        }*/
        motor.go();
    }
}

void move_distance(float len) {
    clear_encoder();
    float len_temp=(len*20)/dist_per_turn;
    while(len_temp>(encoder_l+encoder_r)/2.0){
        motor.go();
        wait(0.2);
    }
}


void find_closest_wall() {
    wait(0.5);
    if(abs(dist1-dist2)>1.5f || dist1>30){
        float temp_dist_list[4]={dist1,dist2,dist3,dist4};
        float temp_dist_side;
        if(temp_dist_list[0]>=temp_dist_list[1]){
            temp_dist_side=temp_dist_list[0];
        }
        else {
            temp_dist_side=temp_dist_list[1];
        }
        if(temp_dist_list[2]<=temp_dist_list[3]){
            if(temp_dist_list[2]>=temp_dist_side){
                while(dist3>(temp_dist_side*1.05f)){
                    motor.right();
                }
                motor.stop();
            }
        }
        else{
            if(temp_dist_list[3]>=temp_dist_side){
                while(dist3>(temp_dist_side*1.05f)){
                    motor.right();
                }
                motor.stop();
            }
            else{
                while(dist3>(temp_dist_list[3]*1.1f)){
                    motor.right();
                }
                motor.stop();
            }
        }
        
        while(dist3>35.0f || dist3<25.0f) {
            if(dist3>35.0f){
                motor.drive();
            }
            else{
                motor.reverse();
            }
        }  
    }
    motor.stop();
    wait(0.5);
} 

void parallel_to_wall() {
    motor.drive();
    motor.stop();
    while(abs(dist1-dist2)>1.5f || dist1>40){
        motor.left();
    }
    motor.stop();
}

/*void wall_sensor_rise() {
    wall_stop=1;
    set_zero_points();
    turn++;
    motor.reverse();
    move_distance(car_len/2);
    magnet_turn(30,'l');
    parallel_to_wall();
    set_zero_points();
    wall_stop=0;
}
    
void wall_sensor_fall() {
    set_zero_points();
    wall_stop=0;
}*/

void encoder_calibration(int num_of_cal=1) {
    float encoder_data;
    float distance_data;
    float calib_data=0;
    encoder_ticker.attach_us(&measure_encoder, 100);
    int a;
    for(a=0;a<num_of_cal;a++){ //kolko calibracija
        average_data();
        distance_data=return_data[2];
        while(dist4<return_data[2]+15){
            motor.drive();
            wait(0.5);
        }
        motor.stop();
        average_data();
        distance_data=(return_data[2]-distance_data);
        encoder_data=(encoder_l+encoder_r)/40;
        calib_data+=(distance_data/encoder_data);
        while(dist4>=return_data[2]-15){
            motor.reverse();
            wait(0.5);
        }
        motor.stop();
        tire_l.clear_pulse();
        tire_r.clear_pulse();
        wait(1);
    }
    dist_per_turn=calib_data/num_of_cal;
}

void clear_encoder() {
    tire_l.clear_pulse();
    tire_r.clear_pulse();
    encoder_r=0;
    encoder_l=0;
}

void rotation() {
        magnet.setRange(8);
        magnet.init();
        x= magnet.getXvalue();
        y= magnet.getYvalue();
        z= magnet.getZvalue();
        temp=magnet.getTemp();
        heading=magnet.getHeading();
} 

void move_to_corner() {
    while(dist4>15.0f){
        motor.reverse();
    }
    set_zero_points();
}

void magnet_turn(float deg=30, char turn_dir='l') {
    float temp_head=heading;
    while(abs(heading-temp_head)<deg){
        if(turn_dir=='l') {
            motor.left();
            wait_ms(200);
        }
        else {
            motor.right();
            wait_ms(200);
        }
        rotation();
        wait(0.1);
        if(abs(heading-temp_head)>200){
            float temp_head2=abs(abs(heading-temp_head)-360.0f);
            if(temp_head2>deg){
                break;
            }
        }
    }
}

void start_driving() {
    if(wall_stop!=1){
        compare_ticker.attach(&compare, 0.06);
        while(dist3>40){
            switch(compare_flag) {
                case 0:
                    rotation();
                    motor.drive();
                    break;
                case 1:
                    set_zero_points();
                    move_distance(car_len);
                    set_zero_points();
                    compare_ticker.attach(&compare, 0.06);
                    compare_flag=0;
                    break;
                case 3:
                    move_distance(car_len);
                    set_zero_points();
                    magnet_turn(40,'r');
                    move_distance(car_len);
                    parallel_to_wall();
                    turn--;
                    set_zero_points();
                    compare_ticker.attach(&compare, 0.06);
                    compare_flag=0;
                    break; 
            }
            wait_ms(200);
        }
        set_zero_points();
        magnet_turn();
        parallel_to_wall();
        clear_encoder();
        turn++;
        set_zero_points();//mozda ubaciti move to croner umjesto zero
        if(turn<4 && done!=1){
            start_driving();
        }
        else {
            driving_done=1;
        }
    }
    else{
        start_driving();
    }
}

float check_for_bad(float *data,int size) {
    int i;
    float sum=0;
    float range=0;
    float prev_range=0;
    for(i=0;i<size;i++){
        sum+=data[i];
    }
    float avg=sum/size;
    int array_flag=0;
    for(i=0;i<size;i++){
       range=abs(data[i]-avg);
       if(range>prev_range){
           array_flag=i;
           prev_range=range;
        }
    }
    avg=(sum-data[array_flag])/(size-1);
    return avg;
}
 
void set_zero_points() {
    motor.stop();
    compare_ticker.detach();
    senzor2_timeout.detach();
    senzor1_timeout.detach();
    wait_ms(100);
    average_data();
    rotation();
    all_data[data_flag]=heading;//return_data[0];
    all_data[data_flag+1]=return_data[1];
    all_data[data_flag+2]=return_data[2];
    all_data[data_flag+3]=return_data[3];
    all_data[data_flag+4]=return_data[4];
    all_data[data_flag+5]=encoder_l;
    all_data[data_flag+6]=encoder_r;
    all_data[data_flag+7]=turn;
    /*if(wall_stop==1) {
        all_data[data_flag+1]=0;
        all_data[data_flag+2]=0;
    }*/   
    data_flag+=8;
    clear_encoder();
    //heading=return_data[0];
    if(heading>all_data[0]-5 && heading<all_data[0]+5) {
        done=1;
    }
    else {
        done=0;
    }
    measure1();
    wait_ms(120);
}
 
void average_data() {
    //float check_data1[AVG_NUM];
    float check_data2[AVG_NUM];
    float check_data3[AVG_NUM];
    float check_data4[AVG_NUM];
    float check_data5[AVG_NUM];
    int i;
    for(i=0;i<AVG_NUM;i++){
         //rotation();
         dist4=senzor4.get_distance();
         dist1=senzor1.get_distance();
         dist3=senzor3.get_distance();
         wait_ms(60);
         dist2=senzor2.get_distance();
         wait_ms(60);
         //check_data1[i]=heading;
         check_data2[i]=dist3;
         check_data3[i]=dist4;
         check_data4[i]=dist1;
         check_data5[i]=dist2;       
    }
    //return_data[0]=check_for_bad(check_data1,AVG_NUM);
    return_data[1]=check_for_bad(check_data2,AVG_NUM);
    return_data[2]=check_for_bad(check_data3,AVG_NUM);
    return_data[3]=check_for_bad(check_data4,AVG_NUM);
    return_data[4]=check_for_bad(check_data5,AVG_NUM);
    dist1=return_data[3];
    dist2=return_data[4];
    dist3=return_data[1];
    dist4=return_data[2];
}
 
void start_sequence() {
    //wall_sensor.rise(&wall_sensor_rise);
    //wall_sensor.fall(&wall_sensor_fall);
    measure1();
    find_closest_wall();
    parallel_to_wall();
    compare_ticker.attach(&compare, 0.06);
    wait(0.1);
    move_to_corner();
    encoder_calibration(3);//dodat mogucnost zadavanja s bt
    turn=0;
    start_driving();
}

void calculation() {
    //Podsjetnik
    /*all_data[data_flag]=return_data[0]; rot
    all_data[data_flag+1]=return_data[1]; dist3 front
    all_data[data_flag+2]=return_data[2]; dist4 back
    all_data[data_flag+3]=return_data[3]; dist 1 backside
    all_data[data_flag+4]=return_data[4]; dist 2 front side
    all_data[data_flag+5]=encoder_l;
    all_data[data_flag+6]=encoder_r;
    all_data[data_flag+7]=turn;*/
    int i;
    float dist_factor=dist_per_turn/40;
    int meas_num=(data_flag/8)-1;
    int prev_turn=0;
    float prev_rot=0;
    float wall_rotation[100];
    float wall_length[100];
    int n=0;
    for(i=1;i<meas_num;i+=2) {
        float rot1=all_data[(8*i)];
        float rot2=all_data[(8*i)+8];
        float distfront1=all_data[(8*i)+1];
        float distfront2=all_data[(8*i)+9];
        float distback1=all_data[(8*i)+2];
        float distback2=all_data[(8*i)+10];
        float distbside1=all_data[(8*i)+3];
        float distbside2=all_data[(8*i)+11];
        float distfside1=all_data[(8*i)+4];
        float distfside2=all_data[(8*i)+12];
        int tirerotl1=all_data[(8*i)+5];
        int tirerotl2=all_data[(8*i)+13];
        int tirerotr1=all_data[(8*i)+6];
        int tirerotr2=all_data[(8*i)+14];
        int turn1=all_data[(8*i)+7];
        int turn2=all_data[(8*i)+15];
        float tire_dist=dist_factor*(tirerotl2+tirerotr2);
        if(distfront2>50) {
            distfront2=0;
        }
        if(distback1 >50) {
            distback1=0;
        }
        wall_length[n]=car_len+tire_dist+distback1+distfront2;
        if(turn1>prev_turn) {
            wall_rotation[n]=abs(rot1-prev_rot);
            if(wall_rotation[n]>=180) {
                wall_rotation[n]=360-wall_rotation[n];
            }
        }
        else if(turn1<prev_turn) {
            wall_rotation[n]=abs(rot1-prev_rot)*(-1);
            
        }
        else if(turn1==prev_turn && n>0) {
            wall_length[n]=(distbside1+distfside1)/2;
            wall_rotation[n]=-45;
            n++;
            wall_length[n]=car_len+tire_dist;
            wall_rotation[n]=45;
            n++;
            wall_length[n]=(distbside2+distfside2)/2;
            wall_rotation[n]=45;      
        }
        if(n==0) {//else if
            wall_rotation[n]=0;
        }    
        n++;
        prev_rot=rot2;
        prev_turn=turn2;
    }
    wait(5);
    int e;
    for(e=0;e<3;e++){
        bt.printf("Starting!");
        wait(1);
    }
    bt.printf("\n");
    bt.printf("Factor %f\n",dist_per_turn);
    for(e=0;e<n;e++){
        bt.printf("Wall L: %f.2 cm, Wall Angle: %f.2\n",wall_length[e],wall_rotation[e]);
        wait(2.5);
    }
    int j;
    for(j=0;i<3;j++){
        bt.printf("Starting!");
        wait(1);
    }
    bt.printf("\n");
    for(j=0;j<data_flag;j+=8){
        bt.printf("%f %f %f %f %f %f %f %f\n",all_data[j],all_data[j+1],all_data[j+2],all_data[j+3],all_data[j+4],all_data[j+5],all_data[j+6],all_data[j+7]);
        wait(1);
        }
    bt.printf("Done!");
}



void bt_control() {
    char test=bt.getc();
    switch(test){
        case 't':
            bt.printf("Current temperature is:\n");
            bt.printf("%f",temp);
            break;
        case 'g':
            bt.printf("Current heading is:\n");
            bt.printf("%f",heading);
            break;
        case 'f':
            motor.drive();
            break;
        case 'b':
            motor.reverse();
            break;
        case 'l':
            motor.left();
            break;
        case 'r':
            motor.right();
            break;
        case 'p':
            done=1;
            motor.stop();
            break;
        case 'c':
            //int ENC_NUM=1; 
            //Number of encoder calibrations nije implementirano.
            bt.printf("Number of encoder calibrations set to %d",test);
            break;
        case 'a':
            //int AVG_NUM=4;
            //Number of measurements, nije implementirano.
            bt.printf("Average measurement set to %d",test);
            break;
        case 'd':
            dist1=senzor1.get_distance();//popraviti average_funkciju
            dist4=senzor4.get_distance();
            dist3=senzor3.get_distance();
            dist2=senzor2.get_distance();
            bt.printf("Front: %f Back: %f Front right: %f Back right: %f",dist3,dist4,dist2,dist1);
            break;
        case 'h':
            bt.printf("Temp: t Heading: g\n Car control: f,b,r,l,p\n");
            bt.printf("Number of calibrations: c\n Number of measurements: a\n");
            bt.printf("Get distance data: d\n");
            bt.printf("Start mapping: s\n");
            break;
        case 's':
            done=0;
            start_everything=1;//bolje set start
            break;
        case 'e':
            if(driving_done==1)start_calculation=1;
            else {
                bt.printf("No done yet.");
            }
            break;
        default:
            bt.printf("Send 'h' for list of commands.");
            break;
    }
    while(bt.readable()) {
        bt.getc();    
    }
}


int main() {
        rotation();
        senzor1.setup(temp);
        senzor2.setup(temp);
        senzor3.setup(temp);
        senzor4.setup(temp);
        bt.attach(&bt_control,Serial::RxIrq); 
        while(1){
            if(start_everything==1) {
                start_sequence();
                start_everything=0;
            }
            if(start_calculation==1) {
                calculation();
                start_calculation=0;
                done=0;
                driving_done=0;
            }
            wait(1);
        }
}