#ifndef QMC5883L_H
#define QMC5883L_H

#include "mbed.h"
#include "math.h"

#define pi 3.14159265359 

/* Registri */
#define OUT_X_LSB    0x00 //ro - read only
#define OUT_X_MSB    0x01 //ro
#define OUT_Y_LSB    0x02 //ro
#define OUT_Y_MSB    0x03 //ro
#define OUT_Z_LSB    0x04 //ro
#define OUT_Z_MSB    0x05 //ro
#define STATUS       0x06 //ro
#define TEMP_LSB     0x07 //ro
#define TEMP_MSB     0x08 //ro
#define CONTROL_A    0x09 //rw - read write
#define CONTROL_B    0x0A //rw
#define SET_RESET    0x0B //rw
#define CHIP_ID      0x0D //ro 



class QMC5883L
{
    public:
        QMC5883L(PinName sda, PinName scl);
        void    setRange(int range);    //postavi range 2G ili 8G (2 ili 8)
        void    init();  
        short   getXvalue();
        short   getYvalue();
        short   getZvalue();
        float   getTemp();
        double  getHeading();
        
    private:
    
        void QMC5883L_w(char QMC5883L_reg, char QMC5883L_data); 
        char QMC5883L_r(char QMC5883L_reg); 
        short   range_data;
        float   mRes;  
        
     I2C QMC5883L_i2c;
};

#endif