 #include "mbed.h" //5.4.7 (144)

const PinName can1rxPins[] = {PA_11};
const PinName can1txPins[] = {PA_12};
const PinName can2rxPins[] = {PB_5};
const PinName can2txPins[] = {PB_6};

//CAN1
//0,0=OK 0,1=OK 0,2=OK 1,0=OK 1,1=OK 1,2=OK 2,0=OK 2,1=OK 2,2=OK
//CAN2
//0,0=RX_OK 0,1=OK 1,0=RX_OK 1,1=OK

CAN can(can1rxPins[0], can1txPins[0]);
CAN can1(can2rxPins[0], can2txPins[0]);

  //UART1, Tx, Rx (Debug)
DigitalOut led1(LED1);
DigitalIn button(USER_BUTTON);


Thread sendThread(osPriorityAboveNormal, 2048);
Thread canrx;
CANMessage messageIn;
CANMessage messageOut;

AnalogIn xin(A1);
AnalogIn yin(A0);

DigitalIn b1(D12);
DigitalIn b2(D11);
DigitalIn b3(D10);
DigitalIn b4(D9);
DigitalIn b5(D8);
DigitalIn b6(D7);
DigitalIn b7(D6);
DigitalIn b8(D5);

char payload[] = {0,0,0,0};
int id = 0x020;

void sendMessage()
{
    if(xin < 0.2f)
        payload[0] = 1;
    else if(xin > 0.8f)
        payload[0] = 2;
    else
        payload[0] = 0;
        
    id = 0x020;
        
    int status = can.write(CANMessage(id, payload, 4));
    wait(0.01);
    printf("Send status X: %d\r\n", status);
    
    if(yin < 0.2f)
        payload[0] = 2;
    else if(yin > 0.8f)
        payload[0] = 1;
    else
        payload[0] = 0;
        
    id = 0x010;
        
     status = can.write(CANMessage(id, payload, 4));
     wait(0.01);
    printf("Send status Y: %d\r\n\n", status);
    
    if(b5==0)
    {
    payload[0]=1;
    if(b8)
        id = 0x030;
    else
        id=0x070;
    status = can.write(CANMessage(id, payload, 4));
    printf("Send status linup: %d\r\n\n", status);
    wait(0.01);
    } 
    else if(b7==0)
    {
    payload[0]=2;
    if(b8)
        id = 0x030;
    else
        id=0x070;
    status = can.write(CANMessage(id, payload, 4));
    printf("Send status linDown: %d\r\n\n", status);
    wait(0.01);
    }
    else if (b5==1 && b7==1)
    {
    payload[0]=0;
    if(b8)
        id = 0x030;
    else
        id=0x070;  
    status = can.write(CANMessage(id, payload, 4));
    printf("Send status linStop: %d\r\n\n", status);
    wait(0.01);
    }
    
    // ----------------------------------------------
    if(b4==0)
    {
    payload[0]=1;
    id = 0x050;  
    status = can.write(CANMessage(id, payload, 4));
    printf("Send status linup: %d\r\n\n", status);
    wait(0.01);
    } 
    else if(b3==0)
    {
    payload[0]=2;
    id = 0x050;    
    status = can.write(CANMessage(id, payload, 4));
    printf("Send status linDown: %d\r\n\n", status);
    wait(0.01);
    }
    else if (b4==1 && b3==1)
    {
    payload[0]=0;
    id = 0x050;     
    status = can.write(CANMessage(id, payload, 4));
    printf("Send status linStop: %d\r\n\n", status);
    wait(0.01);
    }
    
    // ----------------------------------------------
    if(b1==0)
    {
    payload[0]=1;
    id = 0x040;  
    status = can.write(CANMessage(id, payload, 4));
    printf("Send status linup: %d\r\n\n", status);
    wait(0.01);
    } 
    else if(b2==0)
    {
    payload[0]=2;
    id = 0x040;    
    status = can.write(CANMessage(id, payload, 4));
    printf("Send status linDown: %d\r\n\n", status);
    wait(0.01);
    }
    else if (b1==1 && b2==1)
    {
    payload[0]=0;
    id = 0x040;     
    status = can.write(CANMessage(id, payload, 4));
    printf("Send status linStop: %d\r\n\n", status);
    wait(0.01);
    }
    
    //----------------------------------------------
    if(b6==0 && b8==1)
    {
    payload[0]=1;
    id = 0x060;  
    status = can.write(CANMessage(id, payload, 4));
    printf("Send status linup: %d\r\n\n", status);
    wait(0.01);
    } 
    else if(b6==0 && b8==0)
    {
    payload[0]=2;
    id = 0x060;    
    status = can.write(CANMessage(id, payload, 4));
    printf("Send status linDown: %d\r\n\n", status);
    wait(0.01);
    }
    else if (b6==1 && b8==0)
    {
    payload[0]=0;
    id = 0x060;     
    status = can.write(CANMessage(id, payload, 4));
    printf("Send status linStop: %d\r\n\n", status);
    wait(0.01);
    }
}


int main()
{
   b1.mode(PullUp);
b2.mode(PullUp);
b3.mode(PullUp);
b4.mode(PullUp);
b5.mode(PullUp);
b6.mode(PullUp);
b7.mode(PullUp);
b8.mode(PullUp); 
   
    printf("CAN receive / transmit test.\r\n");
    can.frequency(125000);
    can1.frequency(125000);
    printf("Running! \r\n");

    while(true)
    {            
        sendMessage();
        
        printf("%f\t%f\n\r", float(xin), float(yin));
        printf("b1: %d\tb2: %d\tb3: %d\tb4: %d\tb5: %d\tb6: %d\tb7: %d\tb8: %d\n\r", b1.read(), b2.read(), b3.read(), b4.read(), b5.read(), b6.read(), b7.read(), b8.read());
            
        osDelay(100);
    }
}  